/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.ServiceDefinitionService;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/services"})
@RestController
public class ServiceController {
    @Autowired
    private ServiceDefinitionService serviceDefinitionService;

    @GetMapping(value={"/status"})
    public ResponseEntity<RequestResponse> getAllServiceStatuses() {
        RequestResponse returnValue = new RequestResponse();
        try {
            List statusList = this.serviceDefinitionService.listServicesStatusWithLogLevel();
            returnValue.setData((Object)statusList);
            returnValue.setMessage("Services fetched successfully");
            returnValue.setStatus(HttpStatus.OK.value());
            returnValue.setIssue(Constants.NodeStatus.OK);
        }
        catch (Exception e) {
            returnValue.setMessage("Failed to fetch services");
            returnValue.setMessageDetail(e.getMessage());
            returnValue.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            returnValue.setIssue(Constants.NodeStatus.ERROR);
        }
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

