/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.scada_assets.service;

import com.coraltele.telemetry.background.NotificationManagerProcess;
import com.coraltele.telemetry.component.service.DeviceManagerService;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.Category;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.Location;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAssetOld;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.LocationRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetOldRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.Alert;
import com.coraltele.telemetry.db.telemetry.main.entity.AlertHistory;
import com.coraltele.telemetry.db.telemetry.main.entity.AlternateIp;
import com.coraltele.telemetry.db.telemetry.main.entity.CategoryService;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlternateIpRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.CategoryServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.DeviceModelRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.users.main.entity.UserLocation;
import com.coraltele.telemetry.db.users.main.repository.UserLocationRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.HTTPHelper;
import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.SnmpService;
import com.coraltele.telemetry.helper.SpringHelper;
import com.coraltele.telemetry.model.AlertWithAssetDataModel;
import com.coraltele.telemetry.model.DeviceManagerConfigurationModel;
import com.coraltele.telemetry.model.SCADATrapModel;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.model.interface_model.IAssetSummaryModel;
import com.coraltele.telemetry.model.interface_model.IDeviceCount;
import com.coraltele.telemetry.service.coralnms.category.model.CategoryFileListModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.AssetTree;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.AssetTreeForLocation;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.SCADAAssetModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.ServerGroupModel;
import com.coraltele.telemetry.service.main.model.IAssetAlertStatus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SCADAAssetService {
    private static final Logger logger = LogManager.getLogger(SCADAAssetService.class);
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    @Autowired
    SCADAAssetOldRepository scadaAssetOldRepository;
    @Autowired
    LocationRepository locationRepository;
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    AlertRepository alertRepository;
    @Autowired
    AlertHistoryRepository alertHistoryRepository;
    @Autowired
    CategoryServiceRepository categoryServiceRepository;
    @Autowired
    UserLocationRepository userLocationRepository;
    @Autowired
    SeverityRepository severityRepository;
    @Autowired
    AlternateIpRepository alternateIpRepository;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    NotificationManagerProcess notificationManagerProcess;
    @Autowired
    SnmpService snmpService;
    @Autowired
    ExtensionRepository extensionsRepository;
    @Autowired
    DeviceManagerService deviceManagerService;
    @Autowired
    DeviceModelRepository deviceModelRepository;
    Map<Integer, String> severityList = new ConcurrentHashMap();

    @PostConstruct
    public void initData() {
        this.severityRepository.findAll().forEach(severity -> {
            if (severity.getSeverityLevel() != null && severity.getSeverityName() != null) {
                this.severityList.put(severity.getSeverityLevel(), severity.getSeverityName());
            }
        });
    }

    public RequestResponse create(SCADAAssetModel data) {
        RequestResponse returnValue = new RequestResponse();
        SCADAAsset scadaAsset = new SCADAAsset();
        scadaAsset.setNodeId(data.getNodeId());
        scadaAsset.setIpAddress(data.getIpAddress());
        scadaAsset.setNodeName(data.getNodeName());
        scadaAsset.setCategory(data.getCategory());
        scadaAsset.setOid(data.getOid());
        scadaAsset.setStatus(data.isStatus());
        scadaAsset.setSwitchIP(data.getSwitchIP());
        scadaAsset.setStackId(data.getStackId());
        scadaAsset.setSwitchPort(data.getSwitchPort());
        scadaAsset.setLocation(data.getLocation());
        scadaAsset.setSeverity(data.getSeverity());
        scadaAsset.setSeverityBackGroundColor(data.getSeverityBackGroundColor());
        scadaAsset.setSeverityForeGroundColor(data.getSeverityForeGroundColor());
        scadaAsset.setXCoordinate(data.getXCoordinate());
        scadaAsset.setYCoordinate(data.getYCoordinate());
        scadaAsset.setServerGroupId(data.getServerGroupId());
        scadaAsset.setControl(data.getControl());
        scadaAsset.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
        scadaAsset.setSeverity(Integer.valueOf(0));
        scadaAsset.setSeverityUpdatedOn(scadaAsset.getCreatedOn());
        this.scadaAssetRepository.save((Object)scadaAsset);
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("data created successfully");
        return returnValue;
    }

    public RequestResponse getById(Long id) {
        RequestResponse returnValue = new RequestResponse();
        Optional scadaAsset = this.scadaAssetRepository.findById(id);
        if (scadaAsset.isPresent()) {
            SCADAAssetModel data = new SCADAAssetModel();
            data.setNodeId(((SCADAAsset)scadaAsset.get()).getNodeId());
            data.setIpAddress(((SCADAAsset)scadaAsset.get()).getIpAddress());
            data.setNodeName(((SCADAAsset)scadaAsset.get()).getNodeName());
            data.setCategory(((SCADAAsset)scadaAsset.get()).getCategory());
            data.setOid(((SCADAAsset)scadaAsset.get()).getOid());
            data.setStatus(((SCADAAsset)scadaAsset.get()).isStatus());
            data.setSwitchIP(((SCADAAsset)scadaAsset.get()).getSwitchIP());
            data.setSwitchPort(((SCADAAsset)scadaAsset.get()).getSwitchPort());
            data.setStackId(((SCADAAsset)scadaAsset.get()).getStackId());
            data.setLocation(((SCADAAsset)scadaAsset.get()).getLocation());
            data.setSeverity(data.getSeverity());
            data.setSeverityBackGroundColor(((SCADAAsset)scadaAsset.get()).getSeverityBackGroundColor());
            data.setSeverityForeGroundColor(((SCADAAsset)scadaAsset.get()).getSeverityForeGroundColor());
            data.setXCoordinate(((SCADAAsset)scadaAsset.get()).getXCoordinate());
            data.setYCoordinate(((SCADAAsset)scadaAsset.get()).getYCoordinate());
            data.setServerGroupId(((SCADAAsset)scadaAsset.get()).getServerGroupId());
            data.setControl(((SCADAAsset)scadaAsset.get()).getControl());
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setData((Object)data);
            return returnValue;
        }
        returnValue.setStatus(-1);
        returnValue.setMessage("Unable to return value");
        returnValue.setMessageDetail("Records not found");
        return returnValue;
    }

    public RequestResponse getAll() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<SCADAAssetModel> addValue = new ArrayList<SCADAAssetModel>();
        List list = this.scadaAssetRepository.findAll();
        for (SCADAAsset scadaAsset : list) {
            SCADAAssetModel data = new SCADAAssetModel();
            data.setNodeId(scadaAsset.getNodeId());
            data.setIpAddress(scadaAsset.getIpAddress());
            data.setNodeName(scadaAsset.getNodeName());
            data.setCategory(scadaAsset.getCategory());
            data.setOid(scadaAsset.getOid());
            data.setStatus(scadaAsset.isStatus());
            data.setSwitchIP(scadaAsset.getSwitchIP());
            data.setSwitchPort(scadaAsset.getSwitchPort());
            data.setStackId(scadaAsset.getStackId());
            data.setLocation(scadaAsset.getLocation());
            data.setSeverity(data.getSeverity());
            data.setSeverityBackGroundColor(scadaAsset.getSeverityBackGroundColor());
            data.setSeverityForeGroundColor(scadaAsset.getSeverityForeGroundColor());
            data.setXCoordinate(scadaAsset.getXCoordinate());
            data.setYCoordinate(scadaAsset.getYCoordinate());
            addValue.add(data);
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        return returnValue;
    }

    public RequestResponse update(SCADAAssetModel data, Long id) {
        RequestResponse returnValue = new RequestResponse();
        Optional scadaAsset = this.scadaAssetRepository.findById(id);
        if (scadaAsset.isPresent()) {
            ((SCADAAsset)scadaAsset.get()).setNodeId(data.getNodeId());
            ((SCADAAsset)scadaAsset.get()).setIpAddress(data.getIpAddress());
            ((SCADAAsset)scadaAsset.get()).setNodeName(data.getNodeName());
            ((SCADAAsset)scadaAsset.get()).setCategory(data.getCategory());
            ((SCADAAsset)scadaAsset.get()).setOid(data.getOid());
            ((SCADAAsset)scadaAsset.get()).setStatus(data.isStatus());
            ((SCADAAsset)scadaAsset.get()).setSwitchIP(data.getSwitchIP());
            ((SCADAAsset)scadaAsset.get()).setStackId(data.getStackId());
            ((SCADAAsset)scadaAsset.get()).setSwitchPort(data.getSwitchPort());
            ((SCADAAsset)scadaAsset.get()).setLocation(data.getLocation());
            ((SCADAAsset)scadaAsset.get()).setSeverity(data.getSeverity());
            ((SCADAAsset)scadaAsset.get()).setSeverityBackGroundColor(data.getSeverityBackGroundColor());
            ((SCADAAsset)scadaAsset.get()).setSeverityForeGroundColor(data.getSeverityForeGroundColor());
            ((SCADAAsset)scadaAsset.get()).setXCoordinate(data.getXCoordinate());
            ((SCADAAsset)scadaAsset.get()).setYCoordinate(data.getYCoordinate());
            this.scadaAssetRepository.save(scadaAsset.get());
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("data updated successfully");
            return returnValue;
        }
        returnValue.setStatus(-1);
        returnValue.setMessage("not found");
        returnValue.setMessageDetail("data not found you are looking for");
        return returnValue;
    }

    public List<SCADAAssetModel> findAll() {
        ArrayList<SCADAAssetModel> returnValue = new ArrayList<SCADAAssetModel>();
        if (Constants.ASSET_SOURCE == 0) {
            for (SCADAAssetOld asset : this.scadaAssetOldRepository.findAll()) {
                SCADAAssetModel assetModel = new SCADAAssetModel();
                assetModel.setId(asset.getId());
                assetModel.setNodeId(asset.getNodeId());
                assetModel.setIpAddress(asset.getIpAddress());
                assetModel.setNodeName(asset.getNodeName());
                assetModel.setCategory(asset.getCategory());
                assetModel.setOid(asset.getOid());
                assetModel.setStatus(asset.isStatus());
                assetModel.setSwitchIP(asset.getSwitchIP());
                assetModel.setSwitchPort(asset.getSwitchPort());
                assetModel.setStackId(asset.getStackId());
                assetModel.setLocation(asset.getLocation());
                assetModel.setSeverity(asset.getSeverity());
                assetModel.setSeverityForeGroundColor(asset.getSeverityForeGroundColor());
                assetModel.setSeverityBackGroundColor(asset.getSeverityBackGroundColor());
                assetModel.setXCoordinate(asset.getXCoordinate().toString());
                assetModel.setYCoordinate(asset.getYCoordinate().toString());
                assetModel.setManagementURL(asset.getManagementURL());
                assetModel.setLiveStatusURL(asset.getLiveStatusURL());
                assetModel.setBackgroundURL(asset.getBackgroundURL());
                assetModel.setDeviceMessage(asset.getDeviceMessage());
                returnValue.add(assetModel);
            }
        } else {
            for (SCADAAsset asset : this.scadaAssetRepository.findAll()) {
                SCADAAssetModel assetModel = new SCADAAssetModel();
                assetModel.setId(asset.getId());
                assetModel.setNodeId(asset.getNodeId());
                assetModel.setIpAddress(asset.getIpAddress());
                assetModel.setNodeName(asset.getNodeName());
                assetModel.setCategory(asset.getCategory());
                assetModel.setOid(asset.getOid());
                assetModel.setStatus(asset.isStatus());
                assetModel.setSwitchIP(asset.getSwitchIP());
                assetModel.setSwitchPort(asset.getSwitchPort());
                assetModel.setStackId(asset.getStackId());
                assetModel.setLocation(asset.getLocation());
                assetModel.setSeverity(asset.getSeverity());
                assetModel.setSeverityForeGroundColor(asset.getSeverityForeGroundColor());
                assetModel.setSeverityBackGroundColor(asset.getSeverityBackGroundColor());
                assetModel.setXCoordinate(asset.getXCoordinate());
                assetModel.setYCoordinate(asset.getYCoordinate());
                assetModel.setManagementURL(asset.getManagementURL());
                assetModel.setLiveStatusURL(asset.getLiveStatusURL());
                assetModel.setBackgroundURL(asset.getBackgroundURL());
                assetModel.setDeviceMessage(asset.getDeviceMessage());
                returnValue.add(assetModel);
            }
        }
        return returnValue;
    }

    public Optional<SCADAAssetModel> findByNodeId(Integer nodeId) {
        Optional<SCADAAssetModel> returnValue;
        if (Constants.ASSET_SOURCE == 0) {
            Optional<SCADAAssetModel> returnValue2;
            Optional data = this.scadaAssetOldRepository.findByNodeId(nodeId);
            Optional<SCADAAssetModel> optional = returnValue2 = data.isPresent() ? Optional.of(new SCADAAssetModel()) : Optional.empty();
            if (data.isPresent()) {
                SCADAAssetModel assetModel = (SCADAAssetModel)returnValue2.get();
                SCADAAssetOld asset = (SCADAAssetOld)data.get();
                assetModel.setId(asset.getId());
                assetModel.setNodeId(asset.getNodeId());
                assetModel.setIpAddress(asset.getIpAddress());
                assetModel.setNodeName(asset.getNodeName());
                assetModel.setCategory(asset.getCategory());
                assetModel.setOid(asset.getOid());
                assetModel.setStatus(asset.isStatus());
                assetModel.setSwitchIP(asset.getSwitchIP());
                assetModel.setSwitchPort(asset.getSwitchPort());
                assetModel.setStackId(asset.getStackId());
                assetModel.setLocation(asset.getLocation());
                assetModel.setSeverity(asset.getSeverity());
                assetModel.setSeverityForeGroundColor(asset.getSeverityForeGroundColor());
                assetModel.setSeverityBackGroundColor(asset.getSeverityBackGroundColor());
                assetModel.setXCoordinate(asset.getXCoordinate().toString());
                assetModel.setYCoordinate(asset.getYCoordinate().toString());
                assetModel.setManagementURL(asset.getManagementURL());
                assetModel.setLiveStatusURL(asset.getLiveStatusURL());
                assetModel.setBackgroundURL(asset.getBackgroundURL());
                assetModel.setDeviceMessage(asset.getDeviceMessage());
            }
            return returnValue2;
        }
        Optional data = this.scadaAssetRepository.findByNodeId(nodeId);
        Optional<SCADAAssetModel> optional = returnValue = data.isPresent() ? Optional.of(new SCADAAssetModel()) : Optional.empty();
        if (data.isPresent()) {
            SCADAAssetModel assetModel = (SCADAAssetModel)returnValue.get();
            SCADAAsset asset = (SCADAAsset)data.get();
            assetModel.setId(asset.getId());
            assetModel.setNodeId(asset.getNodeId());
            assetModel.setIpAddress(asset.getIpAddress());
            assetModel.setNodeName(asset.getNodeName());
            assetModel.setCategory(asset.getCategory());
            assetModel.setOid(asset.getOid());
            assetModel.setStatus(asset.isStatus());
            assetModel.setSwitchIP(asset.getSwitchIP());
            assetModel.setSwitchPort(asset.getSwitchPort());
            assetModel.setStackId(asset.getStackId());
            assetModel.setLocation(asset.getLocation());
            assetModel.setSeverity(asset.getSeverity());
            assetModel.setSeverityForeGroundColor(asset.getSeverityForeGroundColor());
            assetModel.setSeverityBackGroundColor(asset.getSeverityBackGroundColor());
            assetModel.setXCoordinate(asset.getXCoordinate());
            assetModel.setYCoordinate(asset.getYCoordinate());
            assetModel.setManagementURL(asset.getManagementURL());
            assetModel.setLiveStatusURL(asset.getLiveStatusURL());
            assetModel.setBackgroundURL(asset.getBackgroundURL());
            assetModel.setDeviceMessage(asset.getDeviceMessage());
        }
        return returnValue;
    }

    public List<SCADAAssetModel> findBySwitchIPAndSwitchPortAndStackId(String switchIP, Integer switchPort, Integer stackId) {
        ArrayList<SCADAAssetModel> returnValue = new ArrayList<SCADAAssetModel>();
        if (Constants.ASSET_SOURCE == 0) {
            logger.info("Search for {} {} {} in Old Asset Table", (Object)switchIP, (Object)switchPort, (Object)stackId);
            for (SCADAAssetOld asset : this.scadaAssetOldRepository.findBySwitchIPAndSwitchPortAndStackId(switchIP, switchPort, stackId)) {
                SCADAAssetModel assetModel = new SCADAAssetModel();
                assetModel.setId(asset.getId());
                assetModel.setNodeId(asset.getNodeId());
                assetModel.setIpAddress(asset.getIpAddress());
                assetModel.setNodeName(asset.getNodeName());
                assetModel.setCategory(asset.getCategory());
                assetModel.setOid(asset.getOid());
                assetModel.setStatus(asset.isStatus());
                assetModel.setSwitchIP(asset.getSwitchIP());
                assetModel.setSwitchPort(asset.getSwitchPort());
                assetModel.setStackId(asset.getStackId());
                assetModel.setLocation(asset.getLocation());
                assetModel.setSeverity(asset.getSeverity());
                assetModel.setSeverityForeGroundColor(asset.getSeverityForeGroundColor());
                assetModel.setSeverityBackGroundColor(asset.getSeverityBackGroundColor());
                assetModel.setXCoordinate(asset.getXCoordinate().toString());
                assetModel.setYCoordinate(asset.getYCoordinate().toString());
                assetModel.setManagementURL(asset.getManagementURL());
                assetModel.setLiveStatusURL(asset.getLiveStatusURL());
                assetModel.setBackgroundURL(asset.getBackgroundURL());
                assetModel.setDeviceMessage(asset.getDeviceMessage());
                returnValue.add(assetModel);
            }
        } else {
            logger.info("Search for {} {} {} in SCADA Asset Table", (Object)switchIP, (Object)switchPort, (Object)stackId);
            for (SCADAAsset asset : this.scadaAssetRepository.findBySwitchIPAndSwitchPortAndStackId(switchIP, switchPort, stackId)) {
                SCADAAssetModel assetModel = new SCADAAssetModel();
                assetModel.setId(asset.getId());
                assetModel.setNodeId(asset.getNodeId());
                assetModel.setIpAddress(asset.getIpAddress());
                assetModel.setNodeName(asset.getNodeName());
                assetModel.setCategory(asset.getCategory());
                assetModel.setOid(asset.getOid());
                assetModel.setStatus(asset.isStatus());
                assetModel.setSwitchIP(asset.getSwitchIP());
                assetModel.setSwitchPort(asset.getSwitchPort());
                assetModel.setStackId(asset.getStackId());
                assetModel.setLocation(asset.getLocation());
                assetModel.setSeverity(asset.getSeverity());
                assetModel.setSeverityForeGroundColor(asset.getSeverityForeGroundColor());
                assetModel.setSeverityBackGroundColor(asset.getSeverityBackGroundColor());
                assetModel.setXCoordinate(asset.getXCoordinate());
                assetModel.setYCoordinate(asset.getYCoordinate());
                assetModel.setManagementURL(asset.getManagementURL());
                assetModel.setLiveStatusURL(asset.getLiveStatusURL());
                assetModel.setBackgroundURL(asset.getBackgroundURL());
                assetModel.setDeviceMessage(asset.getDeviceMessage());
                returnValue.add(assetModel);
            }
        }
        return returnValue;
    }

    public void updateStatus(Long id, Integer severity, String backGroundColor, String foreGroundColor) {
        Optional scadaAsset;
        if (Constants.ASSET_SOURCE != 0 && (scadaAsset = this.scadaAssetRepository.findById(id)).isPresent()) {
            ((SCADAAsset)scadaAsset.get()).setStatus(severity == 0);
            ((SCADAAsset)scadaAsset.get()).setSeverity(severity);
            ((SCADAAsset)scadaAsset.get()).setSeverityBackGroundColor(backGroundColor);
            ((SCADAAsset)scadaAsset.get()).setSeverityForeGroundColor(foreGroundColor);
            this.scadaAssetRepository.save(scadaAsset.get());
        }
    }

    public Optional<SCADAAsset> getNodeByIPAddress(String ipAddress) {
        return this.scadaAssetRepository.findByIpAddress(ipAddress);
    }

    public Optional<SCADAAsset> getNodeByCellId(String cellId) {
        return this.scadaAssetRepository.findByCellId(cellId);
    }

    public AssetTreeForLocation getAssetTreeLocation(String userName, Integer locationId) {
        AssetTreeForLocation returnValue = new AssetTreeForLocation();
        List locations = null;
        if (Constants.ENABLE_LOCATION_FILTER.booleanValue()) {
            locations = new ArrayList();
            for (UserLocation userLocation : this.userLocationRepository.findByUsername(userName)) {
                Optional row = this.locationRepository.findByCode(userLocation.getLocationCode());
                if (!row.isPresent()) continue;
                locations.add(row.get());
            }
            for (Location childLocation : locations) {
                Boolean hasParent = false;
                if (childLocation.getParentLocation() != null) {
                    for (Location parentLocation : locations) {
                        if (!childLocation.getParentLocation().getCode().equals(parentLocation.getCode())) continue;
                        hasParent = true;
                    }
                }
                if (hasParent.booleanValue()) continue;
                childLocation.setParentLocation(null);
            }
        } else {
            locations = this.locationRepository.findAll();
        }
        returnValue.setDisplayMode("table");
        Integer level = 1;
        for (Location location : locations) {
            if (!location.getId().equals(locationId)) continue;
            AssetTree node = new AssetTree();
            node.setLevel(level);
            node.setId(location.getUuid().toString());
            node.setNodeId(Integer.valueOf(0));
            node.setIpAddress("");
            node.setName(location.getName());
            node.setCategory("Location");
            node.setStatus(Boolean.valueOf(true));
            node.setLocation(location.getCode());
            returnValue.getTree().add(node);
            this.addChildLocations(locations, level, node, location);
        }
        return returnValue;
    }

    public RequestResponse getAssetTree(String userName) {
        RequestResponse returnValue = new RequestResponse();
        List locations = null;
        if (Constants.ENABLE_LOCATION_FILTER.booleanValue()) {
            locations = new ArrayList();
            for (UserLocation userLocation : this.userLocationRepository.findByUsername(userName)) {
                Optional row = this.locationRepository.findByCode(userLocation.getLocationCode());
                if (!row.isPresent()) continue;
                locations.add(row.get());
            }
            for (Location childLocation : locations) {
                Boolean hasParent = false;
                if (childLocation.getParentLocation() != null) {
                    for (Location parentLocation : locations) {
                        if (!childLocation.getParentLocation().getCode().equals(parentLocation.getCode())) continue;
                        hasParent = true;
                    }
                }
                if (hasParent.booleanValue()) continue;
                childLocation.setParentLocation(null);
            }
        } else {
            locations = this.locationRepository.findAll();
        }
        ArrayList<AssetTree> treeData = new ArrayList<AssetTree>();
        Boolean hasParentLocation = false;
        Integer level = 1;
        for (Location location : locations) {
            if (location.getParentLocation() != null) continue;
            hasParentLocation = true;
            AssetTree node = new AssetTree();
            node.setLevel(level);
            node.setId(location.getUuid().toString());
            node.setNodeId(Integer.valueOf(0));
            node.setIpAddress("");
            node.setName(location.getName());
            node.setCategory("Location");
            node.setStatus(Boolean.valueOf(true));
            node.setLocation(location.getCode());
            treeData.add(node);
            this.addChildLocations(locations, level, node, location);
        }
        if (treeData.size() > 1) {
            ArrayList<AssetTree> parentNodeList = new ArrayList<AssetTree>();
            AssetTree parentNode = new AssetTree();
            parentNode.setLevel(Integer.valueOf(0));
            parentNode.setId("d-u-m-m-y-n-o-d-e");
            parentNode.setIpAddress("");
            parentNode.setCategory("Location");
            parentNode.setIpAddress("");
            parentNode.setName("");
            parentNode.setStatus(Boolean.valueOf(true));
            parentNode.setLocation("d-u-m-m-y-n-o-d-e");
            for (AssetTree assetTree : treeData) {
                parentNode.getChildren().add(assetTree);
            }
            parentNodeList.add(parentNode);
            returnValue.setData(parentNodeList);
        } else {
            returnValue.setData(treeData);
        }
        if (!hasParentLocation.booleanValue()) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to identify root location");
            returnValue.setMessageDetail("There was no root location defined. i.e. system was not able to identify a location without parent");
        }
        return returnValue;
    }

    public void addChildLocations(List<Location> allowedLocations, Integer level, AssetTree location, Location currentNode) {
        AssetTree node;
        if (level >= Constants.MAXIMUM_NESTING) {
            return;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Location allowedLocation : allowedLocations) {
            if (allowedLocation.getParentLocation() == null || !allowedLocation.getParentLocation().getCode().equals(currentNode.getCode())) continue;
            locations.add(allowedLocation);
        }
        List scadaAssets = this.scadaAssetRepository.findByLocationOrderBySeverityDescSeverityUpdatedOnAsc(location.getLocation());
        for (SCADAAsset scadaAsset : scadaAssets) {
            if (scadaAsset.getSwitchIP() != null && !scadaAsset.getSwitchIP().isEmpty()) continue;
            node = new AssetTree();
            if (scadaAsset.getUuid() == null) {
                scadaAsset.setUuid(UUID.randomUUID());
                this.scadaAssetRepository.save((Object)scadaAsset);
            }
            node.setLevel(Integer.valueOf(level + 1));
            node.setId(scadaAsset.getUuid().toString());
            node.setNodeId(scadaAsset.getNodeId());
            node.setIpAddress(scadaAsset.getIpAddress());
            node.setName(scadaAsset.getNodeName());
            node.setCategory(scadaAsset.getCategory());
            node.setStatus(Boolean.valueOf(scadaAsset.isStatus()));
            node.setLocation(location.getLocation());
            node.setCellId(scadaAsset.getCellId());
            node.setSeverity(scadaAsset.getSeverity());
            node.setSeverityUpdatedOn(scadaAsset.getSeverityUpdatedOn());
            node.setSuppressAggregation(scadaAsset.getSuppressAggregation());
            location.getChildren().add(node);
            this.addChildAssets(Integer.valueOf(level + 1), node);
        }
        for (Location row : locations) {
            node = new AssetTree();
            node.setLevel(Integer.valueOf(level + 1));
            node.setId(row.getUuid().toString());
            node.setNodeId(Integer.valueOf(0));
            node.setIpAddress("");
            node.setName(row.getName());
            node.setCategory("Location");
            node.setStatus(Boolean.valueOf(true));
            node.setLocation(row.getCode());
            location.getChildren().add(node);
            this.addChildLocations(allowedLocations, Integer.valueOf(level + 1), node, row);
        }
    }

    public void addChildAssets(Integer level, AssetTree treeNode) {
        AssetTree node;
        if (level >= Constants.MAXIMUM_NESTING) {
            return;
        }
        if (treeNode.getCellId() != null && !treeNode.getCellId().isEmpty()) {
            List imsis = this.imsiRepository.findByCellIdOrderByExtensionName(treeNode.getCellId());
            for (IMSI imsi : imsis) {
                node = new AssetTree();
                node.setLevel(Integer.valueOf(level + 1));
                node.setId(imsi.getUuid().toString());
                node.setNodeId(Integer.valueOf(0));
                node.setIpAddress("");
                node.setName(String.format("%s - %s", imsi.getExtensionName(), imsi.getExtensionNumber()));
                node.setCategory("IMSI");
                node.setStatus(imsi.getConnected());
                node.setLocation(treeNode.getLocation());
                node.setCellId("");
                treeNode.getChildren().add(node);
            }
        }
        List scadaAssets = this.scadaAssetRepository.findBySwitchIPOrderBySeverityDescSeverityUpdatedOnAsc(treeNode.getIpAddress());
        for (SCADAAsset scadaAsset : scadaAssets) {
            node = new AssetTree();
            node.setLevel(Integer.valueOf(level + 1));
            node.setId(scadaAsset.getUuid().toString());
            node.setNodeId(scadaAsset.getNodeId());
            node.setIpAddress(scadaAsset.getIpAddress());
            node.setName(scadaAsset.getNodeName());
            node.setCategory(scadaAsset.getCategory());
            node.setStatus(Boolean.valueOf(scadaAsset.isStatus()));
            node.setLocation(treeNode.getLocation());
            node.setCellId(scadaAsset.getCellId());
            node.setSeverity(scadaAsset.getSeverity());
            node.setSeverityUpdatedOn(scadaAsset.getSeverityUpdatedOn());
            node.setSuppressAggregation(scadaAsset.getSuppressAggregation());
            treeNode.getChildren().add(node);
            this.addChildAssets(Integer.valueOf(level + 1), node);
        }
    }

    public RequestResponse updateByServerGroupId(ServerGroupModel data) {
        RequestResponse returnValue = new RequestResponse();
        List list = this.scadaAssetRepository.findAll();
        if (data.getServerGroupId().equalsIgnoreCase("Primary") && data.getControl() == 1) {
            for (SCADAAsset scadaAsset : list) {
                if (scadaAsset.getServerGroupId().equalsIgnoreCase("Primary")) {
                    scadaAsset.setControl(Boolean.valueOf(true));
                    this.scadaAssetRepository.save((Object)scadaAsset);
                }
                scadaAsset.setControl(Boolean.valueOf(false));
                this.scadaAssetRepository.save((Object)scadaAsset);
            }
        }
        if (data.getServerGroupId().equalsIgnoreCase("Secondary") && data.getControl() == 1) {
            for (SCADAAsset scadaAsset : list) {
                if (scadaAsset.getServerGroupId().equalsIgnoreCase("Secondary")) {
                    scadaAsset.setControl(Boolean.valueOf(true));
                    this.scadaAssetRepository.save((Object)scadaAsset);
                }
                scadaAsset.setControl(Boolean.valueOf(false));
                this.scadaAssetRepository.save((Object)scadaAsset);
            }
        }
        returnValue.setStatus(0);
        returnValue.setMessage("updated");
        returnValue.setMessageDetail("data updated successfully");
        return returnValue;
    }

    public List<IAssetSummaryModel> getAssetSummary() {
        return this.scadaAssetRepository.assetSummary();
    }

    public List<IAssetSummaryModel> getAssetSummaryNotWorking() {
        return this.scadaAssetRepository.assetSummaryNotWorking();
    }

    public IDeviceCount getDeviceCount() {
        return this.scadaAssetRepository.deviceCount();
    }

    public void executeDeviceAction(String action, UUID deviceId) {
        Optional imsi = this.imsiRepository.findByUuid(deviceId);
        if (imsi.isPresent()) {
            HTTPHelper.sendDeviceAction((String)action, (String)((IMSI)imsi.get()).getExtensionNumber());
        }
    }

    public RequestResponse assignLocationToAsset(Long assetId, Integer locationId) {
        RequestResponse returnValue = new RequestResponse();
        Optional assetRecord = this.scadaAssetRepository.findById(assetId);
        if (assetRecord.isPresent()) {
            Optional locationRecord = this.locationRepository.findById(locationId);
            if (locationRecord.isPresent()) {
                SCADAAsset asset = (SCADAAsset)assetRecord.get();
                Location location = (Location)locationRecord.get();
                asset.setLocation(location.getCode());
                this.scadaAssetRepository.save((Object)asset);
            } else {
                returnValue.setStatus(-2);
                returnValue.setMessage("Unable to locate location");
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to locate asset");
        }
        return returnValue;
    }

    public RequestResponse updateCoordinates(SCADAAssetModel data) {
        logger.debug("Update ScadaAsset {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional scadaAsset = this.scadaAssetRepository.findById(data.getId());
        if (scadaAsset.isPresent()) {
            if (data.getXCoordinate() != null) {
                ((SCADAAsset)scadaAsset.get()).setXCoordinate(data.getXCoordinate());
            }
            if (data.getYCoordinate() != null) {
                ((SCADAAsset)scadaAsset.get()).setYCoordinate(data.getYCoordinate());
            }
            this.scadaAssetRepository.save(scadaAsset.get());
            returnValue.setStatus(0);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("scadaAsset Updated successfully");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(-1);
        returnValue.setMessage("not found");
        returnValue.setMessageDetail("scadaAsset not found");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public void updateServiceStatus(ServiceStatus serviceStatus) {
        Optional categoryService;
        logger.info("Status update received : {}", (Object)serviceStatus);
        if (serviceStatus.getAlias() == null || serviceStatus.getAlias().isEmpty()) {
            serviceStatus.setAlias(serviceStatus.getService());
        }
        if (Boolean.TRUE.equals(serviceStatus.getStatus())) {
            serviceStatus.setSeverity(Integer.valueOf(0));
            categoryService = this.categoryServiceRepository.findByCategoryCodeAndServiceCode(serviceStatus.getCategory(), serviceStatus.getAlias());
            if (categoryService.isPresent()) {
                serviceStatus.setAlertDescription(((CategoryService)categoryService.get()).getAlertDescription());
                serviceStatus.setDisableNotification(((CategoryService)categoryService.get()).getDisableNotification());
            }
            if (serviceStatus.getDisableNotification() == null) {
                serviceStatus.setDisableNotification(Boolean.valueOf(false));
            }
        } else {
            categoryService = this.categoryServiceRepository.findByCategoryCodeAndServiceCode(serviceStatus.getCategory(), serviceStatus.getAlias());
            if (categoryService.isPresent()) {
                serviceStatus.setSeverity(((CategoryService)categoryService.get()).getSeverity());
                serviceStatus.setAlertDescription(((CategoryService)categoryService.get()).getAlertDescription());
                serviceStatus.setDisableNotification(((CategoryService)categoryService.get()).getDisableNotification());
                if (serviceStatus.getDisableNotification() == null) {
                    serviceStatus.setDisableNotification(Boolean.valueOf(false));
                }
            } else {
                serviceStatus.setSeverity(Integer.valueOf(3));
            }
        }
        if (!StringUtils.hasLength((String)serviceStatus.getAlertDescription())) {
            serviceStatus.setAlertDescription(serviceStatus.getAlias());
        }
        logger.info("Severity update for received  service status: {}", (Object)serviceStatus);
        Optional scadaAsset = this.scadaAssetRepository.findById(serviceStatus.getAssetId());
        if (scadaAsset.isPresent()) {
            logger.info("Asset found {}", (Object)serviceStatus);
            SCADAAsset currentAsset = (SCADAAsset)scadaAsset.get();
            Optional deviceServiceAlert = this.alertRepository.findByAssetIdAndServiceCodeAndServiceNumber(serviceStatus.getAssetId(), serviceStatus.getService(), serviceStatus.getServiceNumber());
            Alert alert = null;
            boolean saveAlert = false;
            boolean sendNotification = Constants.ENABLE_ALERT_ON_ASSET_ATTRIBUTE_CHANGE;
            if (deviceServiceAlert.isPresent()) {
                logger.info("Alert already exists for {}", (Object)serviceStatus);
                alert = (Alert)deviceServiceAlert.get();
                if (!alert.getName().equals(currentAsset.getNodeName())) {
                    saveAlert = true;
                    alert.setName(currentAsset.getNodeName());
                }
                if (!alert.getCategoryCode().equals(currentAsset.getCategory())) {
                    saveAlert = true;
                    alert.setCategoryCode(currentAsset.getCategory());
                }
                if (!alert.getIpAddress().equals(currentAsset.getIpAddress())) {
                    saveAlert = true;
                    sendNotification = true;
                    alert.setIpAddress(currentAsset.getIpAddress());
                }
                if (alert.isStatus() != Boolean.TRUE.equals(serviceStatus.getStatus())) {
                    saveAlert = true;
                    sendNotification = true;
                    alert.setStatus(serviceStatus.getStatus().booleanValue());
                    if (alert.isStatus()) {
                        alert.setAlertClosedOn(Long.valueOf(Instant.now().getEpochSecond()));
                    } else {
                        alert.setAlertGeneratedOn(Long.valueOf(Instant.now().getEpochSecond()));
                        alert.setAlertClosedOn(null);
                    }
                }
                if (!alert.getSeverity().equals(serviceStatus.getSeverity())) {
                    saveAlert = true;
                    sendNotification = true;
                    alert.setSeverity(serviceStatus.getSeverity());
                }
                if (StringUtils.hasLength((String)serviceStatus.getAlias()) && !serviceStatus.getAlias().equals(alert.getAlias())) {
                    saveAlert = true;
                    alert.setAlias(serviceStatus.getAlias());
                }
                if (StringUtils.hasLength((String)serviceStatus.getStatusDetail()) && !serviceStatus.getStatusDetail().equals(alert.getStatusDetail())) {
                    saveAlert = true;
                    alert.setStatusDetail(serviceStatus.getStatusDetail());
                }
                if (!StringUtils.hasLength((String)alert.getLocationCode()) || !alert.getLocationCode().equals(currentAsset.getLocation())) {
                    saveAlert = true;
                    alert.setLocationCode(currentAsset.getLocation());
                }
                if (alert.getAlertDescription() == null) {
                    alert.setAlertDescription("");
                }
                if (StringUtils.hasLength((String)serviceStatus.getAlertDescription()) && !serviceStatus.getAlertDescription().equals(alert.getAlertDescription())) {
                    saveAlert = true;
                    alert.setAlertDescription(serviceStatus.getAlertDescription());
                }
            } else {
                sendNotification = true;
                logger.info("Creating new alert {}", (Object)serviceStatus);
                saveAlert = true;
                alert = new Alert();
                alert.setAssetId(serviceStatus.getAssetId());
                alert.setServiceCode(serviceStatus.getService());
                alert.setServiceNumber(serviceStatus.getServiceNumber());
                alert.setAlertGeneratedOn(Long.valueOf(Instant.now().getEpochSecond()));
                alert.setAlias(serviceStatus.getAlias());
                alert.setName(serviceStatus.getName());
                alert.setIpAddress(serviceStatus.getIpAddress());
                alert.setCategoryCode(serviceStatus.getCategory());
                alert.setStatus(serviceStatus.getStatus().booleanValue());
                alert.setSeverity(serviceStatus.getSeverity());
                alert.setStatusDetail(serviceStatus.getStatusDetail());
                alert.setLocationCode(currentAsset.getLocation());
                alert.setAlertDescription(serviceStatus.getAlertDescription());
                if (alert.isStatus()) {
                    alert.setAlertClosedOn(Long.valueOf(Instant.now().getEpochSecond()));
                }
            }
            if (saveAlert) {
                logger.info("Persisting alert to database {}", (Object)serviceStatus);
                this.alertRepository.save((Object)alert);
                if (alert.isStatus()) {
                    logger.info("Closing alerts in alert history {}", (Object)serviceStatus);
                    List history = this.alertHistoryRepository.findAllByAssetIdAndServiceCodeAndServiceNumberOrderByAlertGeneratedOn(serviceStatus.getAssetId(), serviceStatus.getService(), serviceStatus.getServiceNumber());
                    for (AlertHistory alertHistory : history) {
                        if (alertHistory.isStatus()) continue;
                        alertHistory.setAlertClosedOn(Long.valueOf(Instant.now().getEpochSecond()));
                        alertHistory.setStatus(true);
                        alertHistory.setStatusDetail(serviceStatus.getStatusDetail());
                        this.alertHistoryRepository.save((Object)alertHistory);
                    }
                } else {
                    logger.info("Opening alert in alert history {}", (Object)serviceStatus);
                    Optional alertHistory = this.alertHistoryRepository.findByAssetIdAndServiceCodeAndServiceNumberAndStatus(serviceStatus.getAssetId(), serviceStatus.getService(), serviceStatus.getServiceNumber(), false);
                    if (!alertHistory.isPresent()) {
                        AlertHistory logAlertHistory = new AlertHistory();
                        logAlertHistory.setAssetId(serviceStatus.getAssetId());
                        logAlertHistory.setName(serviceStatus.getName());
                        logAlertHistory.setIpAddress(serviceStatus.getIpAddress());
                        logAlertHistory.setCategoryCode(serviceStatus.getCategory());
                        logAlertHistory.setServiceCode(serviceStatus.getService());
                        logAlertHistory.setServiceNumber(serviceStatus.getServiceNumber());
                        logAlertHistory.setAlias(serviceStatus.getAlias());
                        logAlertHistory.setStatus(false);
                        logAlertHistory.setStatusDetail(serviceStatus.getStatusDetail());
                        logAlertHistory.setAlertGeneratedOn(Long.valueOf(Instant.now().getEpochSecond()));
                        logAlertHistory.setSeverity(serviceStatus.getSeverity());
                        logAlertHistory.setSmsAlertSend(Integer.valueOf(0));
                        logAlertHistory.setEmailAlertSend(Integer.valueOf(0));
                        logAlertHistory.setLocationCode(alert.getLocationCode());
                        logAlertHistory.setAlertDescription(alert.getAlertDescription());
                        this.alertHistoryRepository.save((Object)logAlertHistory);
                    }
                }
                IAssetAlertStatus assetSeverity = this.alertRepository.getAssetAlertStatus(serviceStatus.getAssetId());
                ObjectMapper mapper = new ObjectMapper();
                String data = "";
                try {
                    data = mapper.writeValueAsString((Object)assetSeverity);
                }
                catch (JsonProcessingException e) {
                    logger.error("Error while converting data : ==", (Throwable)e);
                }
                logger.info("Service Status of Asset : {} : {}", (Object)serviceStatus.getAssetId(), (Object)data);
                logger.info("Service Status of Asset : {} is {} : ", (Object)serviceStatus.getAssetId(), (Object)assetSeverity);
                Integer assetSeverityCode = null;
                assetSeverityCode = assetSeverity.getAlerts() == 0 ? Integer.valueOf(0) : Integer.valueOf(assetSeverity.getSeverity() == null ? 3 : assetSeverity.getSeverity());
                currentAsset.setSeverity(assetSeverityCode);
                currentAsset.setStatus(currentAsset.getSeverity() == 0);
                currentAsset.setSeverityUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                this.scadaAssetRepository.save((Object)currentAsset);
                if (Boolean.TRUE.equals(currentAsset.getDisableNotification()) || Boolean.TRUE.equals(serviceStatus.getDisableNotification())) {
                    logger.info("notification disabled for asset : {} {}", (Object)currentAsset.getNodeName(), (Object)currentAsset.getIpAddress());
                } else {
                    this.notificationManagerProcess.alertUpdate(currentAsset, serviceStatus);
                    logger.info("Sending notification for asset : {} {}", (Object)currentAsset.getNodeName(), (Object)currentAsset.getIpAddress());
                }
                if (sendNotification) {
                    logger.info("Sending SNMP Update");
                    this.sendSNMPUpdate(currentAsset, serviceStatus);
                    logger.info("SNMP Update Sent");
                }
            }
        } else {
            logger.error("Asset id {} does not exist for : {}", (Object)serviceStatus.getAssetId(), (Object)serviceStatus);
        }
    }

    public void sendSNMPUpdate(SCADAAsset scadaAsset, ServiceStatus serviceStatus) {
        SCADATrapModel data;
        String status;
        String oid = "";
        Boolean sendNotification = true;
        if (Boolean.TRUE.equals(serviceStatus.getDisableNotification()) || Boolean.TRUE.equals(scadaAsset.getDisableNotification())) {
            sendNotification = false;
        }
        if (serviceStatus.getCategory().equalsIgnoreCase("icc4") || serviceStatus.getCategory().equalsIgnoreCase("icc3")) {
            status = (String)this.severityList.get(serviceStatus.getSeverity());
            if (!StringUtils.hasLength((String)status)) {
                status = Boolean.TRUE.equals(serviceStatus.getStatus()) ? "OK" : "ERROR";
            }
            String slotInfo = "";
            String serviceCodeValue = "";
            String alias = serviceStatus.getAlias();
            if (!alias.startsWith("PS") && !alias.startsWith("CPU")) {
                slotInfo = "/ SLOT : " + serviceStatus.getSlot();
                if (StringUtils.hasText((String)serviceStatus.getService())) {
                    serviceCodeValue = serviceStatus.getService();
                }
            }
            Integer slotNumber = serviceStatus.getSlot();
            String slotName = alias;
            if (serviceCodeValue.equalsIgnoreCase("ICMP")) {
                slotNumber = scadaAsset.getSwitchPort();
                slotName = scadaAsset.getSwitchIP();
            }
            String slotOid = this.snmpService.getSlotOid(serviceStatus.getSlot());
            String serviceOid = this.snmpService.getServiceOid(alias.trim().toLowerCase());
            data = new SCADATrapModel(scadaAsset.getId(), scadaAsset.getOid(), scadaAsset.getNodeName() + slotInfo + "/ Name : " + alias, scadaAsset.getIpAddress(), status, serviceStatus.getStatusDetail(), slotNumber, slotName, scadaAsset.getStackId(), scadaAsset.getLocation(), scadaAsset.getDeviceMessage(), serviceCodeValue, serviceStatus.getSeverity());
            oid = " SlotOid : " + slotOid + " ServiceOid : " + serviceOid;
        } else {
            status = (String)this.severityList.get(serviceStatus.getSeverity());
            if (!StringUtils.hasLength((String)status)) {
                status = Boolean.TRUE.equals(serviceStatus.getStatus()) ? "OK" : "ERROR";
            }
            data = new SCADATrapModel(scadaAsset.getId(), scadaAsset.getOid(), scadaAsset.getNodeName(), scadaAsset.getIpAddress(), status, serviceStatus.getStatusDetail(), scadaAsset.getSwitchPort(), scadaAsset.getSwitchIP(), scadaAsset.getStackId(), scadaAsset.getLocation(), scadaAsset.getDeviceMessage(), serviceStatus.getAlertDescription(), serviceStatus.getSeverity());
        }
        if (Boolean.TRUE.equals(sendNotification)) {
            try {
                ObjectMapper obj = new ObjectMapper();
                String message = obj.writeValueAsString((Object)data);
                logger.info("Sending message : {} for Asset with IP : {}", (Object)(message + oid), (Object)data.getIpAddress());
                Messaging.getMessagingTemplate().convertAndSend((Object)"/app/v2/messaging/topic/events", (Object)message);
            }
            catch (Exception ex) {
                logger.error("Error while Sending message :", (Throwable)ex);
            }
        }
        logger.info("Sending SNMP Trap for {} {} {} {}", (Object)serviceStatus.getAssetId(), (Object)serviceStatus.getIpAddress(), (Object)serviceStatus.getCategory(), (Object)serviceStatus.getService());
        this.snmpService.sendTrap(data, scadaAsset.getCategory());
        logger.info("Sent SNMP Trap for {} {} {} {}", (Object)serviceStatus.getAssetId(), (Object)serviceStatus.getIpAddress(), (Object)serviceStatus.getCategory(), (Object)serviceStatus.getService());
    }

    public Optional<SCADAAsset> findByIPAddress(String ipAddress) {
        Optional alternateIP;
        Optional returnValue = this.scadaAssetRepository.findByIpAddress(ipAddress);
        if (!returnValue.isPresent() && (alternateIP = this.alternateIpRepository.findByAliasIpAddress(ipAddress)).isPresent()) {
            returnValue = this.scadaAssetRepository.findByIpAddress(((AlternateIp)alternateIP.get()).getIpAddress());
        }
        return returnValue;
    }

    public RequestResponse getByUuid(String uuid) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional scadaAsset = this.scadaAssetRepository.findByUuid(UUID.fromString(uuid));
            if (scadaAsset.isPresent()) {
                Optional categoryData;
                SCADAAssetModel data = new SCADAAssetModel();
                data.setId(((SCADAAsset)scadaAsset.get()).getId());
                data.setNodeId(((SCADAAsset)scadaAsset.get()).getNodeId());
                data.setIpAddress(((SCADAAsset)scadaAsset.get()).getIpAddress());
                data.setNodeName(((SCADAAsset)scadaAsset.get()).getNodeName());
                data.setCategory(((SCADAAsset)scadaAsset.get()).getCategory());
                data.setOid(((SCADAAsset)scadaAsset.get()).getOid());
                data.setStatus(((SCADAAsset)scadaAsset.get()).isStatus());
                data.setSwitchIP(((SCADAAsset)scadaAsset.get()).getSwitchIP());
                data.setSwitchPort(((SCADAAsset)scadaAsset.get()).getSwitchPort());
                data.setStackId(((SCADAAsset)scadaAsset.get()).getStackId());
                data.setLocation(((SCADAAsset)scadaAsset.get()).getLocation());
                data.setSeverity(data.getSeverity());
                data.setSeverityBackGroundColor(((SCADAAsset)scadaAsset.get()).getSeverityBackGroundColor());
                data.setSeverityForeGroundColor(((SCADAAsset)scadaAsset.get()).getSeverityForeGroundColor());
                data.setXCoordinate(((SCADAAsset)scadaAsset.get()).getXCoordinate());
                data.setYCoordinate(((SCADAAsset)scadaAsset.get()).getYCoordinate());
                data.setServerGroupId(((SCADAAsset)scadaAsset.get()).getServerGroupId());
                data.setControl(((SCADAAsset)scadaAsset.get()).getControl());
                data.setManagementURL(((SCADAAsset)scadaAsset.get()).getManagementURL());
                data.setLiveStatusURL(((SCADAAsset)scadaAsset.get()).getLiveStatusURL());
                data.setBackgroundURL(((SCADAAsset)scadaAsset.get()).getBackgroundURL());
                data.setDeviceMessage(((SCADAAsset)scadaAsset.get()).getDeviceMessage());
                data.setServerGroupId(((SCADAAsset)scadaAsset.get()).getServerGroupId());
                data.setCellId(((SCADAAsset)scadaAsset.get()).getCellId());
                data.setUuid(((SCADAAsset)scadaAsset.get()).getUuid().toString());
                data.setCreatedOn(((SCADAAsset)scadaAsset.get()).getCreatedOn());
                data.setSeverityUpdatedOn(((SCADAAsset)scadaAsset.get()).getSeverityUpdatedOn());
                data.setMacAddress(((SCADAAsset)scadaAsset.get()).getMacAddress());
                data.setDisableNotification(((SCADAAsset)scadaAsset.get()).getDisableNotification());
                data.setProductClass(((SCADAAsset)scadaAsset.get()).getProductClass());
                data.setProvisionMode(((SCADAAsset)scadaAsset.get()).getProvisionMode());
                data.setProductClass(((SCADAAsset)scadaAsset.get()).getProductClass());
                data.setProvisionNumber(((SCADAAsset)scadaAsset.get()).getProvisingVersion());
                data.setSuppressAggregation(((SCADAAsset)scadaAsset.get()).getSuppressAggregation());
                data.setSystemUpTime(((SCADAAsset)scadaAsset.get()).getSystemUpTime());
                data.setExtensionNumber(((SCADAAsset)scadaAsset.get()).getExtensionNumber());
                data.setLastHealthUpdateOn(((SCADAAsset)scadaAsset.get()).getLastHealthUpdateOn());
                data.setLastRebootOn(((SCADAAsset)scadaAsset.get()).getLastRebootOn());
                data.setLastRegistrationReceivedOn(((SCADAAsset)scadaAsset.get()).getLastRegistrationReceivedOn());
                data.setRebootOnSchedule(((SCADAAsset)scadaAsset.get()).getRebootOnSchedule());
                data.setRemoteMonitoring(((SCADAAsset)scadaAsset.get()).getRemoteMonitoring());
                if (StringUtils.hasText((String)((SCADAAsset)scadaAsset.get()).getCategory()) && (categoryData = this.categoryRepository.findByCode(((SCADAAsset)scadaAsset.get()).getCategory())).isPresent()) {
                    CategoryFileListModel categoryInfo = new CategoryFileListModel();
                    categoryInfo.setId(((Category)categoryData.get()).getId());
                    categoryInfo.setCode(((Category)categoryData.get()).getCode());
                    categoryInfo.setDescription(((Category)categoryData.get()).getDescription());
                    categoryInfo.setManagementURL(((Category)categoryData.get()).getManagementURL());
                    categoryInfo.setHasManagementInterface(((Category)categoryData.get()).getHasManagementInterface());
                    categoryInfo.setHasSelfDashboard(((Category)categoryData.get()).getHasSelfDashboard());
                    categoryInfo.setImageName(((Category)categoryData.get()).getImageName());
                    categoryInfo.setHeight(((Category)categoryData.get()).getHeight());
                    categoryInfo.setWidth(((Category)categoryData.get()).getWidth());
                    categoryInfo.setExport(((Category)categoryData.get()).getExport());
                    data.setCategoryData(categoryInfo);
                }
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData((Object)data);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to return value");
                returnValue.setMessageDetail("Records not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to return value");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }

    public RequestResponse saveReceivedSCADAAsset(AlertWithAssetDataModel alertData) {
        RequestResponse response = new RequestResponse();
        try {
            SCADAAsset asset = alertData.getScadaAsset();
            List alerts = alertData.getAlertData();
            Optional existingAsset = this.scadaAssetRepository.findByUuid(asset.getUuid());
            SCADAAsset scadaAsset = null;
            if (existingAsset.isPresent()) {
                scadaAsset = (SCADAAsset)existingAsset.get();
                SpringHelper.copyAllPropertiesExcept((Object)asset, (Object)scadaAsset, Arrays.asList("id"));
                this.scadaAssetRepository.save((Object)scadaAsset);
                logger.info("Existing asset updated with ID: {}", (Object)((SCADAAsset)existingAsset.get()).getId());
            } else {
                asset.setId(null);
                scadaAsset = (SCADAAsset)this.scadaAssetRepository.save((Object)asset);
                logger.info("New asset saved with ID: {}", (Object)scadaAsset.getId());
            }
            if (!alerts.isEmpty()) {
                Long assetId = scadaAsset.getId();
                for (Alert alert : alerts) {
                    alert.setAssetId(assetId);
                    Optional existingAlert = this.alertRepository.findByUuid(alert.getUuid());
                    if (existingAlert.isPresent()) {
                        Alert alertToSave = (Alert)existingAlert.get();
                        SpringHelper.copyAllPropertiesExcept((Object)alert, (Object)alertToSave, Arrays.asList("id"));
                        alertToSave.setAssetId(assetId);
                        this.alertRepository.save((Object)alertToSave);
                        continue;
                    }
                    alert.setId(null);
                    alert.setAssetId(assetId);
                    this.alertRepository.save((Object)alert);
                    logger.info("New alert saved, marked for sync: {}", (Object)alert.getUuid());
                }
            }
            response.setStatus(0);
            response.setMessage("Data saved successfully, alerts marked for sync");
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setMessage("Failed to save data");
            logger.error("Error while saving received data: ", (Throwable)e);
        }
        return response;
    }

    public RequestResponse uploadCSVStatus(MultipartFile file) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList successList = new ArrayList();
        ArrayList errorList = new ArrayList();
        try {
            if (file == null || !file.getOriginalFilename().endsWith(".csv")) {
                returnValue.setMessage("Invalid File. Only CSV Allowed.");
                return returnValue;
            }
            List records = this.readCsv(file);
            if (records.isEmpty()) {
                returnValue.setMessage("Empty CSV File");
                return returnValue;
            }
            CSVRecord header = (CSVRecord)records.get(0);
            RequestResponse validation = this.validateCsvHeaderStatus(header);
            if (validation.getMessage() != null && !validation.getMessage().isEmpty()) {
                return validation;
            }
            for (int i = 0; i < records.size(); ++i) {
                CSVRecord row = (CSVRecord)records.get(i);
                String nodeName = this.safe(row, "Node Name");
                String ip = this.safe(row, "IP Address");
                String category = this.safe(row, "Category");
                String location = this.safe(row, "Location");
                String mac = this.normalizeMac(this.safe(row, "Mac Address"));
                String extension = this.normalizeExtension(row);
                String invloc = this.safe(row, "INVLOC");
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("nodeName", nodeName);
                err.put("ip", ip);
                try {
                    Optional ext;
                    if (this.isEmpty(ip) || this.isEmpty(mac)) {
                        err.put("reason", "IP or MAC cannot be empty");
                        errorList.add(err);
                        continue;
                    }
                    if (!this.isEmpty(location) && !this.locationRepository.findByName(location).isPresent()) {
                        err.put("reason", "Location Not Found in Database: " + location);
                        errorList.add(err);
                        continue;
                    }
                    if (!this.isEmpty(category) && !this.categoryRepository.findByCode(category).isPresent()) {
                        err.put("reason", "Category Not Found: " + category);
                        errorList.add(err);
                        continue;
                    }
                    if (!this.isEmpty(extension) && !(ext = this.extensionsRepository.findByExtension(extension)).isPresent()) {
                        err.put("reason", "Extension Not Found: " + extension);
                        errorList.add(err);
                        continue;
                    }
                    boolean exists = this.scadaAssetRepository.findDuplicate(ip, mac).isPresent();
                    if (exists) {
                        err.put("reason", "Duplicate Record (IP + MAC Exists)");
                        errorList.add(err);
                        continue;
                    }
                    SCADAAsset asset = new SCADAAsset();
                    asset.setNodeName(nodeName);
                    asset.setIpAddress(ip);
                    asset.setCategory(this.isEmpty(category) ? null : category);
                    asset.setLocation(this.isEmpty(location) ? null : location);
                    asset.setMacAddress(mac);
                    asset.setExtensionNumber(this.isEmpty(extension) ? null : extension);
                    asset.setINVLOC(this.isEmpty(invloc) ? null : invloc);
                    this.scadaAssetRepository.save((Object)asset);
                    logger.info("the Provisioning method is ended for MAC {} and Extension {}: ", (Object)mac, (Object)extension);
                    logger.info("The Provisioning method is calling for MAC {} and Extension {}: ", (Object)mac, (Object)extension);
                    try {
                        DeviceManagerConfigurationModel config = new DeviceManagerConfigurationModel();
                        DeviceManagerConfigurationModel.Account account = new DeviceManagerConfigurationModel.Account();
                        account.setAccountNo("1");
                        account.setLabel(extension);
                        account.setExtensionNo(extension);
                        ArrayList<DeviceManagerConfigurationModel.Account> accounts = new ArrayList<DeviceManagerConfigurationModel.Account>();
                        accounts.add(account);
                        config.setAccount(accounts);
                        RequestResponse response = this.deviceManagerService.updateConfiguration(mac, config);
                        logger.info("the provisioning uploadSuccess {} and applySuccess {}: ", (Object)response.getStatus());
                        if (response.getStatus() == 0) {
                            HashMap<String, String> success = new HashMap<String, String>();
                            success.put("nodeName", nodeName);
                            success.put("ip", ip);
                            success.put("status", "SUCCESS");
                            successList.add(success);
                            logger.info("Provisioning SUCCESS for MAC {} and Extension {}", (Object)mac, (Object)extension);
                        } else {
                            this.scadaAssetRepository.delete((Object)asset);
                            String errorReason = "Provisioning FAILED for MAC" + mac + " or category " + category + " and Extension " + extension;
                            String mainReason = response.getMessage() != null ? response.getMessage() : "Provisioning FAILED for MAC " + mac + " or category " + category + errorReason;
                            err.put("reason", mainReason);
                            errorList.add(err);
                            logger.warn("Provisioning FAILED for MAC {} and Extension {}", (Object)mac, (Object)extension);
                        }
                        logger.info("the provisioning method is calling {}: ", (Object)response);
                    }
                    catch (Exception e) {
                        logger.info("Somthing went wrong {}: ", (Object)e.getMessage());
                    }
                    continue;
                }
                catch (Exception ex) {
                    err.put("reason", "Unexpected Error: " + ex.getMessage());
                    errorList.add(err);
                }
            }
            HashMap<String, Serializable> successReport = new HashMap<String, Serializable>();
            successReport.put("totalSuccess", Integer.valueOf(successList.size()));
            successReport.put("rows", successList);
            HashMap<String, Serializable> errorReport = new HashMap<String, Serializable>();
            errorReport.put("totalFailed", Integer.valueOf(errorList.size()));
            errorReport.put("rows", errorList);
            HashMap<String, HashMap<String, Serializable>> finalResponse = new HashMap<String, HashMap<String, Serializable>>();
            finalResponse.put("successReport", successReport);
            finalResponse.put("errorReport", errorReport);
            returnValue.setMessage("CSV processed successfully");
            returnValue.setData(finalResponse);
        }
        catch (Exception e) {
            returnValue.setMessage("System Error: " + e.getMessage());
        }
        return returnValue;
    }

    private RequestResponse validateCsvHeaderStatus(CSVRecord header) {
        RequestResponse resp = new RequestResponse();
        HashSet<String> expected = new HashSet<String>(Arrays.asList("node name", "ip address", "category", "location", "mac address", "extension number", "invloc"));
        HashSet<String> actual = new HashSet<String>();
        for (String key : header.toMap().keySet()) {
            if (key == null) continue;
            actual.add(key.trim().replaceAll("[\\uFEFF\\u200B\\u00A0]", "").toLowerCase());
        }
        if (!actual.containsAll(expected)) {
            resp.setMessage("Invalid CSV Header");
            return resp;
        }
        return resp;
    }

    private List<CSVRecord> readCsv(MultipartFile file) throws IOException {
        return CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreEmptyLines(false).withTrim().withIgnoreSurroundingSpaces().parse((Reader)new InputStreamReader(file.getInputStream(), "UTF-8")).getRecords();
    }

    private String safe(CSVRecord row, String key) {
        try {
            if (row.isMapped(key) && row.get(key) != null) {
                return row.get(key).replaceAll("[\\uFEFF-\\uFFFF\\u200B]", "").trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private String normalizeMac(String mac) {
        if (mac == null) {
            return "";
        }
        return mac.replaceAll("[\\uFEFF-\\uFFFF\\u200B]", "").trim().toLowerCase();
    }

    private String normalizeExtension(CSVRecord row) {
        try {
            if (row.isMapped("Extension Number") && row.get("Extension Number") != null) {
                return row.get("Extension Number").replaceAll("[^0-9]", "").trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

