/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.helper.JsonUtils;
import com.coraltele.telemetry.model.OldServiceDefModel;
import com.coraltele.telemetry.model.ServiceStatusResponseModel;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service
public class ServiceDefinitionService {
    private static final Logger logger = LogManager.getLogger(ServiceDefinitionService.class);
    private List<OldServiceDefModel> serviceDefs = Collections.emptyList();

    public ServiceDefinitionService() {
        this.readServiceListJson();
    }

    public void readServiceListJson() {
        String jsonPath = "default-data/services_list.json";
        logger.info("\ud83d\udcd6 Loading service definitions from {}", (Object)jsonPath);
        this.serviceDefs = JsonUtils.readListFromJson((String)jsonPath, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (this.serviceDefs.isEmpty()) {
            logger.warn("\u26a0\ufe0f No service definitions loaded from {}", (Object)jsonPath);
        } else {
            logger.info("\u2705 Loaded {} service definitions from {}", (Object)this.serviceDefs.size(), (Object)jsonPath);
        }
    }

    public List<ServiceStatusResponseModel> listServicesStatusWithLogLevel() {
        ArrayList<ServiceStatusResponseModel> statusList = new ArrayList<ServiceStatusResponseModel>();
        for (OldServiceDefModel def : this.serviceDefs) {
            ServiceStatusResponseModel res = new ServiceStatusResponseModel();
            String unitName = new File(def.getSystemd()).getName();
            res.setService(def.getService());
            res.setUnit(unitName);
            try {
                String line2;
                String line1;
                Process isActiveProc = new ProcessBuilder("systemctl", "is-active", unitName).redirectErrorStream(true).start();
                int exitCode = isActiveProc.waitFor();
                res.setActive(exitCode == 0 ? "active" : "inactive");
                Process isEnabledProc = new ProcessBuilder("systemctl", "is-enabled", unitName).redirectErrorStream(true).start();
                BufferedReader reader1 = new BufferedReader(new InputStreamReader(isEnabledProc.getInputStream()));
                StringBuilder sb1 = new StringBuilder();
                while ((line1 = reader1.readLine()) != null) {
                    sb1.append(line1).append("\n");
                }
                reader1.close();
                String enabledOutput = sb1.toString().trim();
                if (enabledOutput.contains("No such file or directory")) {
                    res.setEnabled("not-found");
                } else if (enabledOutput.isEmpty()) {
                    res.setEnabled("unknown");
                } else {
                    res.setEnabled(enabledOutput);
                }
                Process loadStateProc = new ProcessBuilder("systemctl", "show", "-p", "LoadState", unitName).redirectErrorStream(true).start();
                BufferedReader reader2 = new BufferedReader(new InputStreamReader(loadStateProc.getInputStream()));
                StringBuilder sb2 = new StringBuilder();
                while ((line2 = reader2.readLine()) != null) {
                    sb2.append(line2).append("\n");
                }
                reader2.close();
                String loadState = "not-found";
                for (String line : sb2.toString().split("\n")) {
                    if (!line.startsWith("LoadState=")) continue;
                    loadState = line.replace("LoadState=", "").trim();
                    break;
                }
                res.setLoaded(loadState);
            }
            catch (Exception e) {
                res.setActive("inactive");
                res.setLoaded("not-found");
                res.setEnabled("unknown");
                logger.warn("\u26a0\ufe0f Failed to fetch systemd info for {}: {}", (Object)def.getService(), (Object)e.getMessage());
            }
            String logLevel = this.detectLogLevelForService(def);
            res.setLogLevel(logLevel);
            statusList.add(res);
        }
        return statusList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String detectLogLevelForService(OldServiceDefModel def) {
        String logSource = def.getLogSource();
        String logDestination = def.getLogDestination();
        ArrayList<String> paths = new ArrayList<String>();
        if (logDestination != null && !logDestination.isEmpty()) {
            paths.add(logDestination);
        }
        if (logSource != null && !logSource.isEmpty()) {
            paths.add(logSource);
        }
        Iterator iterator = paths.iterator();
        block14: while (true) {
            if (!iterator.hasNext()) {
                logger.warn("\u26a0\ufe0f Could not detect log level, returning 'UNKNOWN'");
                return "UNKNOWN";
            }
            String pathStr = (String)iterator.next();
            File file = new File(pathStr);
            if (!file.exists()) {
                logger.warn("\u26a0\ufe0f Log config not found: {}", (Object)pathStr);
                continue;
            }
            logger.info("\ud83d\udd0d Reading log config: {}", (Object)pathStr);
            try {
                if (pathStr.toLowerCase().endsWith(".properties")) {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    Throwable throwable = null;
                    try {
                        String lvl;
                        String[] parts;
                        String line;
                        do {
                            if ((line = reader.readLine()) == null) continue block14;
                        } while (!(line = line.trim()).toLowerCase().startsWith("log4j.rootlogger") && !line.toLowerCase().startsWith("loglevel") || (parts = line.split("=")).length <= 1 || (lvl = parts[1].trim().split(",")[0]).isEmpty());
                        logger.info("\u2705 Detected log level '{}' from .properties: {}", (Object)lvl, (Object)pathStr);
                        String string = lvl.toUpperCase();
                        return string;
                    }
                    catch (Throwable line) {
                        throwable = line;
                        throw line;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        reader.close();
                        continue;
                    }
                }
                if (!pathStr.toLowerCase().endsWith(".xml")) continue;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver((publicId, systemId) -> new InputSource(new StringReader("")));
                Document doc = builder.parse(file);
                doc.getDocumentElement().normalize();
                NodeList root2x = doc.getElementsByTagNameNS("*", "Root");
                if (root2x.getLength() == 0) {
                    root2x = doc.getElementsByTagName("Root");
                }
                for (int i = 0; i < root2x.getLength(); ++i) {
                    String lvl;
                    Element root = (Element)root2x.item(i);
                    if (!root.hasAttribute("level") || (lvl = root.getAttribute("level").trim()).isEmpty()) continue;
                    logger.info("\u2705 Detected log level '{}' from <Root level> in {}", (Object)lvl, (Object)pathStr);
                    return lvl.toUpperCase();
                }
                NodeList root1x = doc.getElementsByTagNameNS("*", "root");
                if (root1x.getLength() == 0) {
                    root1x = doc.getElementsByTagName("root");
                }
                for (int i = 0; i < root1x.getLength(); ++i) {
                    Element root = (Element)root1x.item(i);
                    NodeList levels = root.getElementsByTagNameNS("*", "level");
                    if (levels.getLength() == 0) {
                        levels = root.getElementsByTagName("level");
                    }
                    for (int j = 0; j < levels.getLength(); ++j) {
                        String lvl;
                        Element levelEl = (Element)levels.item(j);
                        if (!levelEl.hasAttribute("value") || (lvl = levelEl.getAttribute("value").trim()).isEmpty()) continue;
                        logger.info("\u2705 Detected log level '{}' from <root><level value> in {}", (Object)lvl, (Object)pathStr);
                        return lvl.toUpperCase();
                    }
                }
                NodeList configs = doc.getElementsByTagName("Configuration");
                int i = 0;
                while (true) {
                    String lvl;
                    if (i >= configs.getLength()) continue block14;
                    Element conf = (Element)configs.item(i);
                    if (conf.hasAttribute("status") && !(lvl = conf.getAttribute("status").trim()).isEmpty() && !lvl.equalsIgnoreCase("off")) {
                        logger.info("\u2705 Detected log level '{}' from <Configuration status> in {}", (Object)lvl, (Object)pathStr);
                        return lvl.toUpperCase();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.warn("\u26a0\ufe0f Failed to parse {}: {}", (Object)pathStr, (Object)e.getMessage());
                continue;
            }
            break;
        }
    }
}

