/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.background.SwitchTopologyProcess;
import com.coraltele.telemetry.condition.EnableSNMP;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.AssetPortLocation;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.AssetPortLocationRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.NodeRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.SnmpRules;
import com.coraltele.telemetry.db.telemetry.main.repository.SnmpRulesRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.model.SNMPTrap;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.outage.service.OutageService;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.SCADAAssetModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Conditional(value={EnableSNMP.class})
public class SNMPTrapReceiverService
implements CommandResponder {
    private static final Logger logger = LogManager.getLogger(SNMPTrapReceiverService.class);
    @Autowired
    SCADAAssetService scadaAssetService;
    @Autowired
    NodeRepository nodeRepository;
    @Autowired
    OutageService outageService;
    @Autowired
    AssetPortLocationRepository assetPortLocationRepository;
    @Autowired
    SwitchTopologyProcess switchTopologyProcess;
    @Autowired
    SnmpRulesRepository snmpRulesRepository;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    private final ConcurrentMap<String, List<SnmpRules>> trapList = new ConcurrentHashMap();
    private MultiThreadedMessageDispatcher dispatcher;
    private Snmp snmp = null;
    private Address listenAddress;
    private ThreadPool threadPool;
    private static String listenAddressURL = "";
    private static int threadCount = 10;

    @PostConstruct
    public void startService() {
        logger.info("Enabling SNMP Trap Receiving");
        this.getRuleList();
        SNMPTrapReceiverService.readConfig();
        this.run();
    }

    private void getRuleList() {
        HashMap customTrapList = new HashMap();
        this.snmpRulesRepository.findAllByOrderByRulePriorityDesc().forEach(rule -> {
            if (!customTrapList.containsKey(rule.getTrapId())) {
                customTrapList.put(rule.getTrapId(), new ArrayList());
            }
            ((List)customTrapList.get(rule.getTrapId())).add(rule);
        });
        for (Map.Entry rule2 : customTrapList.entrySet()) {
            this.trapList.put(rule2.getKey(), Collections.unmodifiableList((List)rule2.getValue()));
        }
    }

    private static void readConfig() {
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            String configFile = "/etc/coraltelecom/callserver.manager.conf";
            input = new FileInputStream(configFile);
            prop.load(input);
            listenAddressURL = prop.getProperty("snmp.listenaddressurl", String.format("udp:%s/%d", Constants.SNMP_TRAP_RECEIVE_IP, Constants.SNMP_TRAP_RECEIVE_PORT));
            threadCount = Integer.parseInt(prop.getProperty("snmp.receiverthreads", "10"));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (null != input) {
                    ((InputStream)input).close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    private void run() {
        try {
            this.init();
            this.snmp.addCommandResponder((CommandResponder)this);
        }
        catch (Exception ex) {
            logger.error("Error in run {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void init() {
        try {
            this.threadPool = ThreadPool.create((String)"Trap", (int)threadCount);
            this.dispatcher = new MultiThreadedMessageDispatcher((WorkerPool)this.threadPool, (MessageDispatcher)new MessageDispatcherImpl());
            logger.info("Starting to listen on {}", (Object)listenAddressURL);
            this.listenAddress = GenericAddress.parse((String)listenAddressURL);
            Object transport = this.listenAddress instanceof UdpAddress ? new DefaultUdpTransportMapping((UdpAddress)this.listenAddress) : new DefaultTcpTransportMapping((TcpAddress)this.listenAddress);
            USM usm = new USM(SecurityProtocols.getInstance().addDefaultProtocols(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new PrivAES192());
            SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new PrivAES256());
            SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new Priv3DES());
            usm.setEngineDiscoveryEnabled(true);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            this.snmp = new Snmp((MessageDispatcher)this.dispatcher, (TransportMapping)transport);
            this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
            this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
            this.snmp.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3(usm));
            String username = "coral";
            String authPassPhrase = "coralpwd";
            String privacyPassPhrase = "coralpwd";
            this.snmp.getUSM().addUser(new OctetString(username), new UsmUser(new OctetString(username), AuthMD5.ID, new OctetString(authPassPhrase), PrivAES128.ID, new OctetString(privacyPassPhrase)));
            logger.info("SNMP Trap Receiver Starting");
            this.snmp.listen();
            logger.info("SNMP Trap Receiver Started");
        }
        catch (Exception ex) {
            logger.error("Error in init() {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public void processPdu(CommandResponderEvent crEvent) {
        block51: {
            try {
                String sourceAddress;
                int stackId;
                int portStatus;
                int switchPortNumber;
                block54: {
                    PDU pdu;
                    block52: {
                        Variable downEvent;
                        block53: {
                            logger.info("Received Trap");
                            switchPortNumber = -1;
                            portStatus = -1;
                            stackId = -1;
                            sourceAddress = "";
                            pdu = crEvent.getPDU();
                            String string = sourceAddress = crEvent.getPeerAddress() != null ? crEvent.getPeerAddress().toString() : "";
                            if (!sourceAddress.isEmpty()) {
                                sourceAddress = sourceAddress.split("/")[0];
                            }
                            Boolean trapOIDFound = false;
                            if (pdu.getType() == -92) {
                                PDUv1 pduV1 = (PDUv1)pdu;
                                String agentAddress = pduV1.getAgentAddress().toString();
                                String enterprise = pduV1.getEnterprise().toString();
                                String timeStamp = String.valueOf(pduV1.getTimestamp());
                                String genericTrap = String.valueOf(pduV1.getGenericTrap());
                                String specificTrap = String.valueOf(pduV1.getSpecificTrap());
                                String snmpVersion = String.valueOf(-92);
                                String communityString = new String(crEvent.getSecurityName());
                                logger.info("");
                                logger.info("===== NEW SNMP 1 TRAP RECEIVED ====");
                                logger.info("agentAddr {}", (Object)agentAddress);
                                logger.info("enterprise {}", (Object)enterprise);
                                logger.info("timeStamp {}", (Object)timeStamp);
                                logger.info("genericTrap {}", (Object)genericTrap);
                                logger.info("specificTrap {}", (Object)specificTrap);
                                logger.info("snmpVersion {}", (Object)snmpVersion);
                                logger.info("communityString {}", (Object)communityString);
                                this.parseV1(agentAddress, genericTrap, specificTrap, (PDU)pduV1);
                            } else if (pdu.getType() == -89) {
                                String errorStatus = String.valueOf(pdu.getErrorStatus());
                                String errorIndex = String.valueOf(pdu.getErrorIndex());
                                String requestId = String.valueOf(pdu.getRequestID());
                                String snmpVersion = String.valueOf(-89);
                                String communityString = new String(crEvent.getSecurityName());
                                logger.info("");
                                logger.info("===== NEW SNMP 2/3 TRAP RECEIVED ====");
                                logger.info("errorStatus {}", (Object)errorStatus);
                                logger.info("errorIndex {}", (Object)errorIndex);
                                logger.info("requestID {}", (Object)requestId);
                                logger.info("snmpVersion {}", (Object)snmpVersion);
                                logger.info("communityString {}", (Object)communityString);
                                Variable trapId = pdu.getVariable(SnmpConstants.snmpTrapOID);
                                if (trapId != null) {
                                    String trapIdValue = trapId.toString();
                                    if (trapIdValue.equals("1.3.6.1.4.1.15939.3.0")) {
                                        logger.info("Received Trap for Coral Telemetry");
                                        sourceAddress = pdu.getVariable(Constants.alertDeviceId).toString();
                                    }
                                    logger.info("Trap : {} received from : {}", (Object)trapIdValue, (Object)sourceAddress);
                                    Optional trapReceivedForAsset = this.scadaAssetService.findByIPAddress(sourceAddress);
                                    SnmpRules ruleApplied = null;
                                    Boolean trapStatus = null;
                                    if (trapReceivedForAsset.isPresent()) {
                                        SCADAAsset asset = (SCADAAsset)trapReceivedForAsset.get();
                                        List rules = (List)this.trapList.get(trapIdValue);
                                        if (rules != null && !rules.isEmpty()) {
                                            for (SnmpRules rule : rules) {
                                                Variable successOID;
                                                logger.info("Trap {} received from {} processing rules for {}", (Object)trapIdValue, (Object)sourceAddress, (Object)rule.getServiceCode());
                                                if (rule.getTrapIdType().equals("F")) {
                                                    trapStatus = false;
                                                } else if (rule.getTrapIdType().equals("S")) {
                                                    trapStatus = true;
                                                } else if (rule.getTrapIdType().equals("C") && (successOID = pdu.getVariable(new OID(rule.getSuccessVariable()))) != null) {
                                                    trapStatus = successOID.toString().toLowerCase().contains(rule.getSuccessValue().toLowerCase());
                                                }
                                                if (trapStatus != null) {
                                                    Variable serviceCodeVariable;
                                                    Boolean serviceCodeMatch = false;
                                                    if (Boolean.TRUE.equals(trapStatus)) {
                                                        serviceCodeVariable = pdu.getVariable(new OID(rule.getSuccessServiceCodeVariable()));
                                                        if (serviceCodeVariable != null) {
                                                            serviceCodeMatch = serviceCodeVariable.toString().toLowerCase().contains(rule.getSuccessServiceCodeValue().toLowerCase());
                                                        }
                                                    } else {
                                                        serviceCodeVariable = pdu.getVariable(new OID(rule.getFailureServiceCodeVariable()));
                                                        if (serviceCodeVariable != null) {
                                                            serviceCodeMatch = serviceCodeVariable.toString().toLowerCase().contains(rule.getFailureServiceCodeValue().toLowerCase());
                                                        }
                                                    }
                                                    if (!Boolean.TRUE.equals(serviceCodeMatch)) continue;
                                                    ruleApplied = rule;
                                                    continue;
                                                }
                                                logger.info("Unable to identify service status for Trap {} received from {}", (Object)trapIdValue, (Object)sourceAddress);
                                            }
                                            if (ruleApplied != null) {
                                                trapOIDFound = true;
                                                ServiceStatus serviceStatus = new ServiceStatus(asset.getId(), asset.getNodeName(), asset.getIpAddress(), asset.getCategory(), ruleApplied.getServiceCode(), trapStatus, Boolean.TRUE.equals(trapStatus) ? ruleApplied.getStatusDetailSuccess() : ruleApplied.getStatusDetailFailure(), ruleApplied.getSeverity(), ruleApplied.getAlias(), ruleApplied.getSlot(), "", Boolean.valueOf(false), "");
                                                this.scadaAssetService.updateServiceStatus(serviceStatus);
                                            } else {
                                                for (VariableBinding parameter : pdu.getVariableBindings()) {
                                                    logger.info("Unable to find service for tarp {} from {} ==> {} : {} ", (Object)trapIdValue, (Object)sourceAddress, (Object)parameter.getOid(), (Object)parameter.getVariable());
                                                }
                                            }
                                        } else if (trapIdValue.startsWith("1.3.6.1.4.1.15939.3.")) {
                                            logger.info("Alert {} received from {}", (Object)trapIdValue, (Object)sourceAddress);
                                            String deviceId = Optional.ofNullable(pdu.getVariable(Constants.alertDeviceId)).map(Variable::toString).orElse("");
                                            String alertService = Optional.ofNullable(pdu.getVariable(Constants.alertService)).map(Variable::toString).orElse("");
                                            String alertCurrentValue = Optional.ofNullable(pdu.getVariable(Constants.alertCurrentValue)).map(Variable::toString).orElse("");
                                            String alertThreshold = Optional.ofNullable(pdu.getVariable(Constants.alertThresholdValue)).map(Variable::toString).orElse("");
                                            String alertStatus = Optional.ofNullable(pdu.getVariable(Constants.alertStatus)).map(Variable::toString).orElse("1");
                                            String alertServiceNumber = Optional.ofNullable(pdu.getVariable(Constants.alertServiceNumber)).map(Variable::toString).orElse("");
                                            if (StringUtils.hasText((String)alertService)) {
                                                logger.info("Alert {} received from {} ==> Device ID : {}, Service : {}, Current Value : {}, Threshold : {}, Status : {}", (Object)trapIdValue, (Object)sourceAddress, (Object)deviceId, (Object)alertService, (Object)alertCurrentValue, (Object)alertThreshold, (Object)alertStatus);
                                                StringBuilder sb = new StringBuilder();
                                                sb.append("Alert");
                                                if (deviceId != null && !deviceId.isEmpty()) {
                                                    sb.append(String.format(", Device ID : %s", deviceId));
                                                }
                                                if (alertService != null && !alertService.isEmpty()) {
                                                    sb.append(String.format(", Service : %s", alertService));
                                                }
                                                if (alertServiceNumber != null && !alertServiceNumber.isEmpty()) {
                                                    sb.append(String.format(", Service Number : %s", alertServiceNumber));
                                                }
                                                if (alertCurrentValue != null && !alertCurrentValue.isEmpty()) {
                                                    sb.append(String.format(", Current Value : %s", alertCurrentValue));
                                                }
                                                if (alertThreshold != null && !alertThreshold.isEmpty()) {
                                                    sb.append(String.format(", Threshold : %s", alertThreshold));
                                                }
                                                if (alertStatus != null && !alertStatus.isEmpty()) {
                                                    sb.append(String.format(", Status : %s", alertStatus.equals("0") ? "OK" : "ALERT"));
                                                }
                                                String message = sb.toString();
                                                ServiceStatus serviceStatus = new ServiceStatus(asset.getId(), asset.getNodeName(), asset.getIpAddress(), asset.getCategory(), alertService, Boolean.valueOf(alertStatus.equals("0")), message, Integer.valueOf(Integer.parseInt(alertStatus)), alertService, Integer.valueOf(0), message, Boolean.valueOf(false), alertServiceNumber);
                                                this.scadaAssetService.updateServiceStatus(serviceStatus);
                                            } else {
                                                logger.info("Alert Service is empty for Trap {} received from {}", (Object)trapIdValue, (Object)sourceAddress);
                                            }
                                            trapOIDFound = true;
                                        } else {
                                            logger.info("Trap {} received from {} but no rules defined", (Object)trapIdValue, (Object)sourceAddress);
                                        }
                                    } else {
                                        logger.info("Trap {} received from {}, but asset not found", (Object)trapIdValue, (Object)sourceAddress);
                                    }
                                }
                            }
                            if (Boolean.TRUE.equals(trapOIDFound)) {
                                logger.info("Trap processed by Generic Algorithm");
                                break block51;
                            }
                            Variable nivettiCheck = pdu.getVariable(Constants.nivettiSwitch);
                            if (nivettiCheck == null) break block52;
                            logger.info("Packet received from Nivetti switch");
                            Variable upEvent = pdu.getVariable(Constants.nivettiEventUP);
                            downEvent = pdu.getVariable(Constants.nivettiEventDown);
                            if (upEvent == null) break block53;
                            portStatus = 1;
                            stackId = 0;
                            switchPortNumber = upEvent.toInt();
                            break block54;
                        }
                        if (downEvent == null) break block54;
                        portStatus = 0;
                        stackId = 0;
                        switchPortNumber = downEvent.toInt();
                        break block54;
                    }
                    logger.info("Packet received from Generic switch");
                    for (Object parameter : pdu.getVariableBindings()) {
                        String oid = parameter.getOid().toString();
                        String value = parameter.getVariable().toString().toLowerCase();
                        logger.info("Variable {} {}", (Object)oid, (Object)value);
                        try {
                            if (oid.startsWith("1.3.6.1.2.1.2.2.1.2.")) {
                                if (!value.startsWith("gigabitethernet") && !value.startsWith("gigaethernet")) continue;
                                String[] segments = value.split("/");
                                value = value.replace("gigabitethernet", "");
                                value = value.replace("gigaethernet", "");
                                if (segments.length == 3) {
                                    logger.info("Packet received from Generic switch - This is a stacked switch");
                                    switchPortNumber = Integer.parseInt(segments[2]);
                                    stackId = Integer.parseInt(segments[0]);
                                    continue;
                                }
                                if (segments.length != 2) continue;
                                logger.info("Packet received from Generic switch - This is a non stacked switch");
                                switchPortNumber = Integer.parseInt(segments[1]);
                                stackId = 0;
                                continue;
                            }
                            if (oid.startsWith("1.3.6.1.2.1.2.2.1.8.")) {
                                portStatus = Integer.parseInt(value);
                                continue;
                            }
                            if (!oid.startsWith("1.3.6.1.2.1.2.2.1.1.")) continue;
                            switchPortNumber = Integer.parseInt(value);
                            stackId = 0;
                        }
                        catch (Exception e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                logger.info("Switch port number & port status found. Source IP : {}, Port Number : {}, Stack Id : {}, Status : {}", (Object)sourceAddress, (Object)switchPortNumber, (Object)stackId, (Object)portStatus);
                if (switchPortNumber > -1 && portStatus > -1 && stackId > -1) {
                    try {
                        List scadaAssets = this.scadaAssetService.findBySwitchIPAndSwitchPortAndStackId(sourceAddress, Integer.valueOf(switchPortNumber), Integer.valueOf(stackId));
                        if (portStatus == 1) {
                            this.switchTopologyProcess.updateSwitchInfo(sourceAddress);
                        } else {
                            for (SCADAAssetModel scadaAsset : scadaAssets) {
                                ServiceStatus assetService = new ServiceStatus(scadaAsset.getId(), scadaAsset.getNodeName(), scadaAsset.getIpAddress(), scadaAsset.getCategory(), "ICMP", Boolean.valueOf(portStatus == 1), "", Integer.valueOf(portStatus == 1 ? 0 : 3), "", Integer.valueOf(0), "", Boolean.valueOf(false), "");
                                this.scadaAssetService.updateServiceStatus(assetService);
                            }
                        }
                        if (!scadaAssets.isEmpty()) break block51;
                        logger.info("No Asset Found for Source IP : {}, Port Number : {}, Stack Id : {}, Status : {}. Looking for alternate location", (Object)sourceAddress, (Object)switchPortNumber, (Object)stackId, (Object)portStatus);
                        Optional enforcedLocation = this.assetPortLocationRepository.findBySwitchIPAndSwitchPortAndStackId(sourceAddress, Integer.valueOf(switchPortNumber), Integer.valueOf(stackId));
                        if (enforcedLocation.isPresent()) {
                            logger.info("Alternate location Found for Source IP : {}, Port Number : {}, Stack Id : {}, Status : {}, Alternate location : {}", (Object)sourceAddress, (Object)switchPortNumber, (Object)stackId, (Object)portStatus, (Object)((AssetPortLocation)enforcedLocation.get()).getLocation());
                            Optional scadaAssetNode = this.scadaAssetService.findByNodeId(((AssetPortLocation)enforcedLocation.get()).getNodeId());
                            if (scadaAssetNode.isPresent()) {
                                SCADAAssetModel scadaAsset = (SCADAAssetModel)scadaAssetNode.get();
                                ServiceStatus assetService = new ServiceStatus(scadaAsset.getId(), scadaAsset.getNodeName(), scadaAsset.getIpAddress(), scadaAsset.getCategory(), "ICMP", Boolean.valueOf(portStatus == 1), "", Integer.valueOf(portStatus == 1 ? 0 : 3), "", Integer.valueOf(0), "", Boolean.valueOf(false), "");
                                this.scadaAssetService.updateServiceStatus(assetService);
                            }
                            break block51;
                        }
                        logger.info("No Alternate location Found for Source IP : {}, Port Number : {}, Stack Id : {}, Status : {}", (Object)sourceAddress, (Object)switchPortNumber, (Object)stackId, (Object)portStatus);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    break block51;
                }
                logger.info("Unable To Catch Trap");
            }
            catch (Exception ex) {
                logger.error("Error in processPdu() {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
    }

    private void parseV1(String agentAddress, String genericTrap, String specificTrap, PDU pdu) {
        logger.info("Parsing SNMP V1 Trap - {} {}, {}, {}", (Object)agentAddress, (Object)genericTrap, (Object)specificTrap, (Object)pdu);
        if (genericTrap.equals("6")) {
            logger.info("SNMP V1 Enterprise Specific Trap Received - Specific Trap: {}", (Object)specificTrap);
            SNMPTrap snmpTrap = new SNMPTrap();
            snmpTrap.setSpecificTrap(Integer.valueOf(Integer.parseInt(specificTrap)));
            for (VariableBinding parameter : pdu.getVariableBindings()) {
                String oid = parameter.getOid().toString();
                String value = parameter.getVariable().toString().toLowerCase();
                logger.info("Variable {} {}", (Object)oid, (Object)value);
                snmpTrap.setValue(oid, value);
            }
            if (snmpTrap.getSpecificTrap() == 1) {
                logger.info("Processing Power Status Trap: {}", (Object)snmpTrap);
                this.updatePowerStatus(snmpTrap);
            } else if (snmpTrap.getSpecificTrap() == 2) {
                logger.info("Processing Gate Status Trap: {}", (Object)snmpTrap);
                this.updateGateStatus(snmpTrap);
            } else {
                logger.info("Unknown Specific Trap Received: {} from {} but not processed", (Object)specificTrap, (Object)agentAddress);
            }
        } else {
            logger.info("SNMP V1 Standard Trap Received - Generic Trap: {} from {} but not processed", (Object)genericTrap, (Object)agentAddress);
        }
    }

    private void updateGateStatus(SNMPTrap snmpTrap) {
        logger.info("Processing Gate Status Trap for Extension Number: {}", (Object)snmpTrap.getExtensionNumber());
        String nodeStatus = snmpTrap.getNodeStatusName();
        List assets = this.scadaAssetRepository.findByExtensionNumber(snmpTrap.getExtensionNumber());
        if (assets.isEmpty()) {
            logger.info("No SCADA Asset found for Extension Number: {}", (Object)snmpTrap.getExtensionNumber());
        } else {
            SCADAAsset asset = (SCADAAsset)assets.get(0);
            logger.info("Found {} SCADA Asset for Extension Number: {}", (Object)asset, (Object)snmpTrap.getExtensionNumber());
            Boolean serviceStatusValue = nodeStatus.equals("CLOSED");
            ServiceStatus serviceStatus = new ServiceStatus(asset.getId(), asset.getNodeName(), asset.getIpAddress(), asset.getCategory(), "GATE", serviceStatusValue, String.format("Extension Gate Status: %s", nodeStatus), Integer.valueOf(Boolean.TRUE.equals(serviceStatusValue) ? 0 : 3), "GATE", Integer.valueOf(0), String.format("Extension Gate Status: %s", nodeStatus), Boolean.valueOf(false), "");
            this.scadaAssetService.updateServiceStatus(serviceStatus);
        }
    }

    private void updatePowerStatus(SNMPTrap snmpTrap) {
        List assets;
        logger.info("Processing Power Status Trap for Extension Number: {}", (Object)snmpTrap.getExtensionNumber());
        String[] nodeStatus = snmpTrap.getNodeStatusName().split(":");
        String chargeStatus = nodeStatus.length > 1 ? nodeStatus[0].trim() : "";
        String chargePercent = nodeStatus.length > 2 ? nodeStatus[1].trim() : "";
        Integer chargeLevel = 0;
        if (StringUtils.hasText((String)chargePercent)) {
            chargePercent = chargePercent.replace("%", "").trim();
            try {
                chargeLevel = Integer.parseInt(chargePercent);
            }
            catch (Exception e) {
                logger.error("Error parsing charge level from {}: {}", (Object)chargePercent, (Object)e.getMessage());
            }
        }
        if ((assets = this.scadaAssetRepository.findByExtensionNumber(snmpTrap.getExtensionNumber())).isEmpty()) {
            logger.info("No SCADA Asset found for Extension Number: {}", (Object)snmpTrap.getExtensionNumber());
        } else {
            SCADAAsset asset = (SCADAAsset)assets.get(0);
            logger.info("Found {} SCADA Asset for Extension Number: {}", (Object)asset, (Object)snmpTrap.getExtensionNumber());
            Boolean serviceStatusValue = chargeStatus.equals("NOT CHARGING");
            ServiceStatus serviceStatus = new ServiceStatus(asset.getId(), asset.getNodeName(), asset.getIpAddress(), asset.getCategory(), "PS", serviceStatusValue, String.format("Extension Battery Status: %s, Charge Level: %d%%", chargeStatus, chargeLevel), Integer.valueOf(Boolean.TRUE.equals(serviceStatusValue) ? 0 : 3), "PS", Integer.valueOf(0), String.format("Extension Battery Status: %s, Charge Level: %d%%", chargeStatus, chargeLevel), Boolean.valueOf(false), "");
            this.scadaAssetService.updateServiceStatus(serviceStatus);
            if (chargeStatus.equalsIgnoreCase("CHARGING")) {
                serviceStatusValue = chargeLevel > 50;
                serviceStatus = new ServiceStatus(asset.getId(), asset.getNodeName(), asset.getIpAddress(), asset.getCategory(), "BATTERY", serviceStatusValue, String.format("Extension Battery Status: %s, Charge Level: %d%%", chargeStatus, chargeLevel), Integer.valueOf(Boolean.TRUE.equals(serviceStatusValue) ? 0 : 3), "BATTERY", Integer.valueOf(0), String.format("Extension Battery Status: %s, Charge Level: %d%%", chargeStatus, chargeLevel), Boolean.valueOf(false), "");
                this.scadaAssetService.updateServiceStatus(serviceStatus);
            }
        }
    }
}

