/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnablePingCheck;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import com.coraltele.telemetry.thread.ICMPHealthCheckThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnablePingCheck.class})
public class ICMPHealthCheckProcess {
    private static final Logger logger = LogManager.getLogger(ICMPHealthCheckProcess.class);
    private static final Integer MAX_THREADS = 1;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    SCADAAssetService scadaAssetService;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting ICMP Thread for ping check");
            this.threadPool.execute((Runnable)new ICMPHealthCheckThread(this.scadaAssetRepository, this.scadaAssetService));
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }
}

