/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.dashboard.controller;

import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.UserDashboardLayout;
import com.coraltele.telemetry.service.coralnms.dashboard.model.UserDashboards;
import com.coraltele.telemetry.service.coralnms.dashboard.service.DashboardService;
import com.coraltele.telemetry.service.coralnms.userdashboard.model.UserDashboardModel;
import com.coraltele.telemetry.service.coralnms.userdashboard.service.UserDashboardService;
import com.coraltele.telemetry.service.coralnms.widget.model.WidgetModel;
import com.coraltele.telemetry.service.coralnms.widget.service.WidgetService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Principal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/dashboard"})
@RestController
public class DashboardController {
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private WidgetService widgetService;
    @Autowired
    private UserDashboardService userDashboardService;

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> list(Authentication auth) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            UserDashboards data = this.widgetService.getUserDashboards(auth.getName());
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/locations"})
    public ResponseEntity<RequestResponse> getLocations(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            returnValue.setData((Object)this.dashboardService.getLocations(principal.getName()));
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/assets"})
    public ResponseEntity<RequestResponse> getAssets() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            returnValue.setData((Object)this.dashboardService.getAssets());
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/widgets"})
    public ResponseEntity<RequestResponse> getWidgets(Authentication auth) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.widgetService.getWidgets(auth.getName());
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/dashboard/{id}"})
    public ResponseEntity<RequestResponse> getDashboardWidgets(Authentication auth, @PathVariable(value="id") String id) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            UserDashboardLayout data = this.widgetService.getDashboardLayout(auth.getName(), id);
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/assetDashboard/{id}"})
    public ResponseEntity<RequestResponse> getDashboardWidgets(@PathVariable(value="id") Long id) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            UserDashboards data = this.widgetService.getAssetDashboard(id);
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/widget/{id}"})
    public ResponseEntity<RequestResponse> getWidget(@PathVariable(value="id") String id) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            WidgetModel data = this.widgetService.getWidget(id);
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/saveDashboard"})
    public ResponseEntity<RequestResponse> saveDashboard(Authentication auth, @RequestBody UserDashboardModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        String dashboard = "";
        try {
            dashboard = objectMapper.writeValueAsString(data.getDashboard());
        }
        catch (JsonProcessingException e) {
            dashboard = "";
        }
        RequestResponse returnValue = this.userDashboardService.saveDashboard(auth.getName(), data.getWidgetId(), dashboard);
        if (returnValue.getStatus() == 0) {
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/dashboardGroupList"})
    public ResponseEntity<RequestResponse> lists(Authentication auth) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.widgetService.getUserDashboardsV2(auth.getName());
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

