/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.SendSmsHttpConnection;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SendSms {
    public String respObject = "";
    public String smsText = "";
    public String smsUrl = "";
    public String getCmd;
    public String smsResponse;
    private Boolean confFetched = null;
    private final RestTemplate restTemplate;
    private static final Logger logger = LogManager.getLogger(SendSms.class);
    SendSmsHttpConnection connectionAction = new SendSmsHttpConnection();

    public SendSms(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public boolean sendSmsUrl(String newSmsUrl) {
        boolean isSent = false;
        if (Boolean.TRUE.equals(this.confFetched)) {
            try {
                this.smsResponse = this.connectionAction.DoHttpUrlConnectionAction(newSmsUrl);
                if (this.smsResponse.equals("Success")) {
                    isSent = true;
                }
                return isSent;
            }
            catch (Exception e) {
                logger.info("Sms failed due to : {}", (Object)e.getMessage());
                return isSent;
            }
        }
        logger.info("Configuration not fetched, unable to send sms");
        return isSent;
    }

    @PostConstruct
    public void onService() throws JsonMappingException, JsonProcessingException {
        try {
            String apiUrl = "https://127.0.0.1/services/api/v2/systemConfig/list";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(apiUrl, HttpMethod.GET, entity, String.class, new Object[0]);
            this.respObject = (String)response.getBody();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(this.respObject);
            JsonNode smsData = jsonNode.get("data").get(0);
            this.smsText = smsData.get("smsText").asText();
            this.smsUrl = smsData.get("smsUrl").asText();
            logger.info("smsText {}, smsUrl{}", (Object)this.smsText, (Object)this.smsUrl);
            this.confFetched = true;
        }
        catch (Exception e) {
            logger.error("Unable to fetch sms configuration for NMS", (Object)e.getMessage());
            this.confFetched = false;
        }
    }
}

