/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.main.entity.NodePosition;
import com.coraltele.telemetry.db.telemetry.main.entity.Preference;
import com.coraltele.telemetry.db.telemetry.main.repository.NodePositionRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.PreferenceRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.PreferenceModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class PreferenceService {
    private static final Logger logger = LogManager.getLogger(PreferenceService.class);
    private static final String LINK_VIEW_KEY_PREFIX = "link-view";
    @Autowired
    private PreferenceRepository preferenceRepository;
    @Autowired
    private NodePositionRepository nodePositionRepository;
    @Autowired
    private ObjectMapper objectMapper;

    private String generateKey(String preferenceGroup, String viewMode, String assetId) {
        StringBuilder keyBuilder = new StringBuilder(preferenceGroup);
        keyBuilder.append(".");
        if (StringUtils.hasText((String)viewMode)) {
            keyBuilder.append(viewMode);
        }
        if (StringUtils.hasText((String)assetId)) {
            keyBuilder.append(".");
            keyBuilder.append(assetId);
        }
        return keyBuilder.toString();
    }

    public RequestResponse saveLinkViewPreference(PreferenceModel.LinkViewPreference linkViewPreference) {
        RequestResponse response = new RequestResponse();
        try {
            if (linkViewPreference.getTimestamp() == null) {
                linkViewPreference.setTimestamp(Instant.now().toString());
            }
            String key = this.generateKey(LINK_VIEW_KEY_PREFIX, linkViewPreference.getViewMode(), linkViewPreference.getAssetId());
            String value = this.objectMapper.writeValueAsString((Object)linkViewPreference.getPreferences());
            Preference preference = new Preference();
            preference.setPreferenceId(key);
            preference.setPreferenceValue(value);
            this.preferenceRepository.save((Object)preference);
            logger.info("Saved preference with key: {}", (Object)key);
            response.setStatus(0);
            response.setMessage("Preference saved successfully");
            response.setData((Object)linkViewPreference);
        }
        catch (Exception e) {
            logger.error("Error saving preference: ", (Throwable)e);
            response.setStatus(1);
            response.setMessage("Failed to save preference");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    public RequestResponse getLinkViewPreference(String viewMode, String assetId) {
        RequestResponse response = new RequestResponse();
        try {
            String key = this.generateKey(LINK_VIEW_KEY_PREFIX, viewMode, assetId);
            Optional preferenceOpt = this.preferenceRepository.findById((Object)key);
            if (preferenceOpt.isPresent()) {
                String value = ((Preference)preferenceOpt.get()).getPreferenceValue();
                PreferenceModel.LinkViewPreferenceData preferences = (PreferenceModel.LinkViewPreferenceData)this.objectMapper.readValue(value, PreferenceModel.LinkViewPreferenceData.class);
                PreferenceModel.LinkViewPreference preferenceDTO = new PreferenceModel.LinkViewPreference();
                preferenceDTO.setPreferences(preferences);
                preferenceDTO.setViewMode(viewMode);
                preferenceDTO.setAssetId(assetId);
                logger.info("Retrieved preference with key: {}", (Object)key);
                response.setStatus(0);
                response.setMessage("Preference retrieved successfully");
                response.setData((Object)preferenceDTO);
            } else {
                logger.info("No preference found for key: {}", (Object)key);
                response.setStatus(1);
                response.setMessage("Preference not found");
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving preference: ", (Throwable)e);
            response.setStatus(1);
            response.setMessage("Failed to retrieve preference");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    public RequestResponse deletePreference(String viewMode, String assetId) {
        RequestResponse response = new RequestResponse();
        try {
            String key = this.generateKey(LINK_VIEW_KEY_PREFIX, viewMode, assetId);
            if (this.preferenceRepository.existsById((Object)key)) {
                this.preferenceRepository.deleteById((Object)key);
                logger.info("Deleted preference with key: {}", (Object)key);
                response.setStatus(0);
                response.setMessage("Preference deleted successfully");
            } else {
                logger.info("No preference found to delete for key: {}", (Object)key);
                response.setStatus(1);
                response.setMessage("Preference not found");
            }
        }
        catch (Exception e) {
            logger.error("Error deleting preference: ", (Throwable)e);
            response.setStatus(1);
            response.setMessage("Failed to delete preference");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    private String generateNodePositionId(String viewMode, String assetId, String nodeId) {
        String effectiveViewMode = StringUtils.hasText((String)viewMode) ? viewMode : "top-level";
        String effectiveAssetId = StringUtils.hasText((String)assetId) ? assetId : effectiveViewMode;
        return effectiveViewMode + "." + effectiveAssetId + "." + nodeId;
    }

    public RequestResponse saveNodePosition(PreferenceModel.NodePosition nodePosition) {
        RequestResponse response = new RequestResponse();
        try {
            if (nodePosition.getTimestamp() == null) {
                nodePosition.setTimestamp(Instant.now().toString());
            }
            String id = this.generateNodePositionId(nodePosition.getViewMode(), nodePosition.getAssetId(), nodePosition.getNodeId());
            NodePosition entity = new NodePosition();
            entity.setId(id);
            entity.setAssetId(nodePosition.getAssetId());
            entity.setNodeId(nodePosition.getNodeId());
            entity.setViewMode(nodePosition.getViewMode());
            entity.setTimestamp(nodePosition.getTimestamp());
            if (nodePosition.getPosition() != null) {
                entity.setPositionX(nodePosition.getPosition().getX());
                entity.setPositionY(nodePosition.getPosition().getY());
            }
            this.nodePositionRepository.save((Object)entity);
            logger.info("Saved node position with id: {}", (Object)id);
            response.setStatus(0);
            response.setMessage("Node position saved successfully");
            response.setData((Object)nodePosition);
        }
        catch (Exception e) {
            logger.error("Error saving node position: ", (Throwable)e);
            response.setStatus(1);
            response.setMessage("Failed to save node position");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    public RequestResponse getNodePosition(String viewMode, String assetId, String nodeId) {
        RequestResponse response = new RequestResponse();
        try {
            String id = this.generateNodePositionId(viewMode, assetId, nodeId);
            Optional nodePositionOpt = this.nodePositionRepository.findById((Object)id);
            if (nodePositionOpt.isPresent()) {
                NodePosition entity = (NodePosition)nodePositionOpt.get();
                PreferenceModel.NodePosition nodePosition = new PreferenceModel.NodePosition();
                nodePosition.setAssetId(entity.getAssetId());
                nodePosition.setNodeId(entity.getNodeId());
                nodePosition.setViewMode(entity.getViewMode());
                nodePosition.setTimestamp(entity.getTimestamp());
                if (entity.getPositionX() != null || entity.getPositionY() != null) {
                    PreferenceModel.PositionData position = new PreferenceModel.PositionData();
                    position.setX(entity.getPositionX());
                    position.setY(entity.getPositionY());
                    nodePosition.setPosition(position);
                }
                logger.info("Retrieved node position with id: {}", (Object)id);
                response.setStatus(0);
                response.setMessage("Node position retrieved successfully");
                response.setData((Object)nodePosition);
            } else {
                logger.info("No node position found for id: {}", (Object)id);
                response.setStatus(1);
                response.setMessage("Node position not found");
            }
        }
        catch (Exception e) {
            logger.error("Error retrieving node position: ", (Throwable)e);
            response.setStatus(1);
            response.setMessage("Failed to retrieve node position");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    public RequestResponse deleteNodePosition(String viewMode, String assetId, String nodeId) {
        RequestResponse response = new RequestResponse();
        try {
            String id = this.generateNodePositionId(viewMode, assetId, nodeId);
            if (this.nodePositionRepository.existsById((Object)id)) {
                this.nodePositionRepository.deleteById((Object)id);
                logger.info("Deleted node position with id: {}", (Object)id);
                response.setStatus(0);
                response.setMessage("Node position deleted successfully");
            } else {
                logger.info("No node position found to delete for id: {}", (Object)id);
                response.setStatus(1);
                response.setMessage("Node position not found");
            }
        }
        catch (Exception e) {
            logger.error("Error deleting node position: ", (Throwable)e);
            response.setStatus(1);
            response.setMessage("Failed to delete node position");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }
}

