/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.SnmpAlert;
import com.coraltele.telemetry.db.telemetry.main.repository.SnmpAlertRepository;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SnmpAlertMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SnmpAlertMonitor.class);
    @Autowired
    private SnmpAlertRepository snmpAlertRepository;
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    @Autowired
    private SCADAAssetService scadaAssetService;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedDelay=30000L, initialDelay=5000L)
    public void monitorSnmpAlerts() {
        logger.debug("Triggering SNMP alert status monitor cycle (async)");
        try {
            this.threadPool.execute(() -> this.processAlertsAsync());
        }
        catch (Exception e) {
            logger.error("Error in SNMP alert monitor scheduling", (Throwable)e);
        }
    }

    public void processAlertsAsync() {
        List changedAlerts = this.snmpAlertRepository.findAlertsWithStatusChanges();
        logger.debug("Found {} alerts with status changes", (Object)changedAlerts.size());
        int alertsProcessed = 0;
        for (SnmpAlert snmpAlert : changedAlerts) {
            try {
                this.processAlertStatusChange(snmpAlert);
                ++alertsProcessed;
            }
            catch (Exception e) {
                logger.warn("Error processing alert: asset_uuid={}, service_code={}", new Object[]{snmpAlert.getId().getAssetUuid(), snmpAlert.getId().getServiceCode(), e});
            }
        }
        logger.debug("Alert monitor cycle completed. Processed: {} alerts", (Object)alertsProcessed);
    }

    private boolean processAlertStatusChange(SnmpAlert snmpAlert) {
        UUID assetUuid = snmpAlert.getId().getAssetUuid();
        String serviceCode = snmpAlert.getId().getServiceCode();
        try {
            Optional scadaAssetOpt = this.scadaAssetRepository.findByUuid(assetUuid);
            if (!scadaAssetOpt.isPresent()) {
                logger.warn("SCADA asset not found for SNMP alert: uuid={}", (Object)assetUuid);
                return false;
            }
            SCADAAsset scadaAsset = (SCADAAsset)scadaAssetOpt.get();
            logger.debug("Processing alert: asset_id={}, uuid={}, service={}, snmp_status={} (true=OK, false=ALERT)", new Object[]{scadaAsset.getId(), assetUuid, serviceCode, snmpAlert.isStatus()});
            ServiceStatus serviceStatus = new ServiceStatus();
            serviceStatus.setAssetId(scadaAsset.getId());
            serviceStatus.setName(scadaAsset.getNodeName());
            serviceStatus.setIpAddress(scadaAsset.getIpAddress());
            serviceStatus.setCategory(scadaAsset.getCategory());
            serviceStatus.setService(serviceCode);
            serviceStatus.setStatus(Boolean.valueOf(snmpAlert.isStatus()));
            serviceStatus.setStatusDetail(snmpAlert.getStatusDetail());
            serviceStatus.setSeverity(Integer.valueOf(3));
            serviceStatus.setAlias(this.mapServiceCodeToAlias(serviceCode));
            serviceStatus.setSlot(scadaAsset.getSwitchPort());
            logger.info("Triggering SCADAAssetService.updateServiceStatus for asset: {}, service: {}, status: {}", new Object[]{scadaAsset.getNodeName(), serviceCode, snmpAlert.isStatus()});
            this.scadaAssetService.updateServiceStatus(serviceStatus);
            logger.debug("Successfully processed alert for asset_uuid: {}, service: {}", (Object)assetUuid, (Object)serviceCode);
            return true;
        }
        catch (Exception e) {
            logger.error("Error processing alert status change for asset_uuid: {}, service_code: {}", new Object[]{assetUuid, serviceCode, e});
            return false;
        }
    }

    private String mapServiceCodeToAlias(String serviceCode) {
        switch (serviceCode) {
            case "SNMP_CONN": {
                return "SNMP Connection";
            }
            case "SNMP_DEV": {
                return "SNMP Device";
            }
            case "CPU": {
                return "CPU Usage";
            }
            case "MEM": {
                return "Memory Usage";
            }
            case "DISK": {
                return "Disk Usage";
            }
            case "LCUR": {
                return "Load Current";
            }
            case "LAVG": {
                return "Load Average";
            }
        }
        return serviceCode;
    }
}

