/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnablePingDiscovery;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.DiscoverSubnetRepository;
import com.coraltele.telemetry.thread.DiscoveryThread;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnablePingDiscovery.class})
public class DiscoveryProcess {
    private static final Logger logger = LogManager.getLogger(DiscoveryProcess.class);
    private DiscoveryThread discoveryThread;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    DiscoverSubnetRepository discoverSubnetRepository;

    @PostConstruct
    public void startService() {
        logger.info("Starting Discovery process");
        this.discoveryThread = new DiscoveryThread(this.discoverSubnetRepository, this.scadaAssetRepository);
        if (this.discoveryThread.isRunning) {
            logger.info("Discovery Thread Started");
        }
    }
}

