/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.snmpRules.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.snmpRules.model.SnmpRulesModel;
import com.coraltele.telemetry.service.main.snmpRules.service.SnmpRulesService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/app/v2/snmpRules"})
@RestController
public class SnmpRulesController {
    private static final Logger logger = LogManager.getLogger(SnmpRulesController.class);
    @Autowired
    private SnmpRulesService snmpService;

    @PostMapping(value={"/catalogue"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.snmpService.getAll();
        if (returnValue.getStatus() == 0) {
            logger.info("the list of values");
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody SnmpRulesModel data, Principal principal) {
        RequestResponse returnValue = this.snmpService.createData(data, principal.getName());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            logger.info("create data sucessfully..");
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody SnmpRulesModel data, Principal principal) {
        RequestResponse returnValue = this.snmpService.updateById(data, principal.getName());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            logger.info("update records sucessfully");
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{id}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.snmpService.deleteManualAlert(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            logger.info("delete records sucessfully");
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/read/{id}"})
    public ResponseEntity<RequestResponse> readById(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.snmpService.getById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            logger.info("read records by {}", (Object)id);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

