/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.polygon.routeCoordinate.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.RouteCoordinateModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.RouteProgressModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.UserDetailHistoryModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.service.RouteCoordinateService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/routeCoordinate"})
@RestController
public class RouteCoordinateController {
    @Autowired
    RouteCoordinateService routeCoordinateService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody RouteCoordinateModel data, Principal principal) {
        RequestResponse returnValue = this.routeCoordinateService.createMultiData(data, "API");
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/shiftProgress"})
    public ResponseEntity<RequestResponse> create(@RequestBody RouteProgressModel data, Principal principal) {
        RequestResponse returnValue = this.routeCoordinateService.routeProgress(data, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/user/{username}"})
    public ResponseEntity<RequestResponse> getAreaByUser(@PathVariable(value="username") String username) {
        RequestResponse returnValue = this.routeCoordinateService.getUserDetails(username);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/user"})
    public ResponseEntity<RequestResponse> getAreaByUserHistory(@RequestBody UserDetailHistoryModel data) {
        RequestResponse returnValue = this.routeCoordinateService.getUserDetailsHistory(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/monitor/{monitorUser}"})
    public ResponseEntity<RequestResponse> createMonitor(@PathVariable(value="monitorUser") String monitorUser) {
        RequestResponse returnValue = this.routeCoordinateService.monitorUser(monitorUser);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/clear-monitor"})
    public ResponseEntity<RequestResponse> clearMonitor() {
        RequestResponse returnValue = this.routeCoordinateService.clearMonitorUser();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

