/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.eventNotification.service;

import com.coraltele.telemetry.db.telemetry.main.entity.EventNotify;
import com.coraltele.telemetry.db.telemetry.main.repository.EventNotifyRepository;
import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.service.main.eventNotification.model.EventNotifyModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EventNotifyService {
    private static final Logger logger = LogManager.getLogger(EventNotifyService.class);
    @Autowired
    EventNotifyRepository eventNotifyRepository;

    public void sendNotification(EventNotifyModel data) {
        ObjectMapper obj = new ObjectMapper();
        try {
            EventNotify row = new EventNotify();
            row.setEventId(data.getEventId());
            row.setEventUUID(data.getEventUUID());
            row.setEventMessage(data.getEventMessage());
            row.setEventSeverity(data.getEventSeverity());
            row.setEventEpoch(data.getEventEpoch());
            row.setEventSource(data.getEventSource());
            row.setEventDestination(data.getEventDestination());
            row.setReadByUser(data.getReadByUser());
            row.setEventData(obj.writeValueAsString(data.getEventData()));
            this.eventNotifyRepository.save((Object)row);
            Messaging.sendAlert((EventNotifyModel)data);
            logger.info("Alert event send successfully to user:{} and data:{}", (Object)data.getEventDestination(), data.getEventData());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Unable to send event to user:{},and error:{}", (Object)data.getEventDestination(), (Object)e.getMessage());
        }
    }
}

