/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.model.ManualAlertCloseModel;
import com.coraltele.telemetry.service.main.service.AlertService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/alert"})
@RestController
@CrossOrigin(origins={"*"})
public class AlertController {
    private static final Logger logger = LogManager.getLogger(AlertController.class);
    @Autowired
    AlertService alertService;

    @GetMapping(value={"/active/list"})
    public ResponseEntity<RequestResponse> getActiveAlerts() {
        logger.info("Get active alerts");
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.alertService.getActiveAlerts());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/active/list/imageDetails"})
    public ResponseEntity<RequestResponse> getActiveAlertNotificationWithImage() {
        logger.info("Get active alerts with imageName");
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.alertService.getAlertNotification());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/active/summary"})
    public ResponseEntity<RequestResponse> getActiveAlertSummary() {
        logger.info("Get summary alerts");
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.alertService.getActiveAlertSummary());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/asset/active/{assetId}"})
    public ResponseEntity<RequestResponse> getActiveAlertsForAsset(@PathVariable(value="assetId") String assetId) {
        logger.info("Get Active alerts for an Asset");
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.alertService.getActiveAlertsForAsset(assetId));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/asset/history/{assetId}"})
    public ResponseEntity<RequestResponse> getAlertHistoryForAsset(@PathVariable(value="assetId") String assetId) {
        logger.info("Get summary alerts");
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.alertService.getAlertHistoryForAsset(assetId));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listAllAlertClose"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.alertService.getAll();
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/createManualAlert"})
    public ResponseEntity<RequestResponse> create(@RequestBody ManualAlertCloseModel data) {
        RequestResponse returnValue = this.alertService.createAlertManualClose(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateManualAlert"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody ManualAlertCloseModel data) {
        RequestResponse returnValue = this.alertService.updateById(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/deleteManualAlert/{id}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.alertService.deleteManualAlert(id);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/readManualAlert/{id}"})
    public ResponseEntity<RequestResponse> readById(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.alertService.getById(id);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

