/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.PreferenceService;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.PreferenceModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/preferences"})
public class PreferenceController {
    private static final Logger logger = LogManager.getLogger(PreferenceController.class);
    @Autowired
    private PreferenceService preferenceService;

    @PostMapping(value={"/link-view"})
    public ResponseEntity<RequestResponse> savePreference(@RequestBody PreferenceModel.LinkViewPreference linkViewPreference) {
        logger.info("Update link-view - viewMode: {}, assetId: {}", (Object)linkViewPreference.getViewMode(), (Object)linkViewPreference.getAssetId());
        RequestResponse returnValue = this.preferenceService.saveLinkViewPreference(linkViewPreference);
        if (returnValue.getStatus() == 0) {
            logger.info("Preference saved successfully - viewMode: {}, assetId: {}", (Object)linkViewPreference.getViewMode(), (Object)linkViewPreference.getAssetId());
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.error("Failed to save preference - viewMode: {}, assetId: {}, error: {}", (Object)linkViewPreference.getViewMode(), (Object)linkViewPreference.getAssetId(), (Object)returnValue.getMessage());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/link-view"})
    public ResponseEntity<RequestResponse> getPreference(@RequestParam String viewMode, @RequestParam(required=false, defaultValue="") String assetId) {
        logger.info("Get link-view - viewMode: {}, assetId: {}", (Object)viewMode, (Object)assetId);
        RequestResponse returnValue = this.preferenceService.getLinkViewPreference(viewMode, assetId);
        if (returnValue.getStatus() == 0) {
            logger.info("Preference retrieved successfully - viewMode: {}, assetId: {}", (Object)viewMode, (Object)assetId);
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.warn("Preference not found - viewMode: {}, assetId: {}", (Object)viewMode, (Object)assetId);
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/link-view"})
    public ResponseEntity<RequestResponse> deletePreference(@RequestParam String viewMode, @RequestParam(required=false, defaultValue="") String assetId) {
        logger.info("Delete link-view - viewMode: {}, assetId: {}", (Object)viewMode, (Object)assetId);
        RequestResponse returnValue = this.preferenceService.deletePreference(viewMode, assetId);
        if (returnValue.getStatus() == 0) {
            logger.info("Preference deleted successfully - viewMode: {}, assetId: {}", (Object)viewMode, (Object)assetId);
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.warn("Failed to delete preference - viewMode: {}, assetId: {}, error: {}", (Object)viewMode, (Object)assetId, (Object)returnValue.getMessage());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/node-position"})
    public ResponseEntity<RequestResponse> saveNodePosition(@RequestBody PreferenceModel.NodePosition nodePosition) {
        logger.info("Update node-position - viewMode: {}, assetId: {}, nodeId: {}", (Object)nodePosition.getViewMode(), (Object)nodePosition.getAssetId(), (Object)nodePosition.getNodeId());
        RequestResponse returnValue = this.preferenceService.saveNodePosition(nodePosition);
        if (returnValue.getStatus() == 0) {
            logger.info("Node position saved successfully - viewMode: {}, assetId: {}, nodeId: {}", (Object)nodePosition.getViewMode(), (Object)nodePosition.getAssetId(), (Object)nodePosition.getNodeId());
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.error("Failed to save node position - viewMode: {}, assetId: {}, nodeId: {}, error: {}", (Object)nodePosition.getViewMode(), (Object)nodePosition.getAssetId(), (Object)nodePosition.getNodeId(), (Object)returnValue.getMessage());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/node-position"})
    public ResponseEntity<RequestResponse> getNodePosition(@RequestParam(required=false, defaultValue="") String viewMode, @RequestParam(required=false, defaultValue="") String assetId, @RequestParam String nodeId) {
        logger.info("Get node-position - viewMode: {}, assetId: {}, nodeId: {}", (Object)viewMode, (Object)assetId, (Object)nodeId);
        RequestResponse returnValue = this.preferenceService.getNodePosition(viewMode, assetId, nodeId);
        if (returnValue.getStatus() == 0) {
            logger.info("Node position retrieved successfully - viewMode: {}, assetId: {}, nodeId: {}", (Object)viewMode, (Object)assetId, (Object)nodeId);
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.warn("Node position not found - viewMode: {}, assetId: {}, nodeId: {}", (Object)viewMode, (Object)assetId, (Object)nodeId);
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/node-position"})
    public ResponseEntity<RequestResponse> deleteNodePosition(@RequestParam(required=false, defaultValue="") String viewMode, @RequestParam(required=false, defaultValue="") String assetId, @RequestParam String nodeId) {
        logger.info("Delete node-position - viewMode: {}, assetId: {}, nodeId: {}", (Object)viewMode, (Object)assetId, (Object)nodeId);
        RequestResponse returnValue = this.preferenceService.deleteNodePosition(viewMode, assetId, nodeId);
        if (returnValue.getStatus() == 0) {
            logger.info("Node position deleted successfully - viewMode: {}, assetId: {}, nodeId: {}", (Object)viewMode, (Object)assetId, (Object)nodeId);
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.warn("Failed to delete node position - viewMode: {}, assetId: {}, nodeId: {}, error: {}", (Object)viewMode, (Object)assetId, (Object)nodeId, (Object)returnValue.getMessage());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

