/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.service;

import com.coraltele.telemetry.db.telemetry.main.entity.Alert;
import com.coraltele.telemetry.db.telemetry.main.entity.Task;
import com.coraltele.telemetry.db.telemetry.main.entity.TaskDetails;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.TaskDetailsRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.TaskRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskService {
    private static final Logger logger = LogManager.getLogger(TaskService.class);
    @Autowired
    TaskRepository taskRepository;
    @Autowired
    AlertRepository alertRepository;
    @Autowired
    TaskDetailsRepository taskDetailsRepository;

    public void createTask(Long assetId, String status, String serviceCode, String category, String ipAddress, String severityName) {
        logger.info("Creating new task: {} {} {} {} {} ", (Object)status, (Object)serviceCode, (Object)category, (Object)ipAddress, (Object)severityName);
        RequestResponse returnValue = new RequestResponse();
        try {
            List taskList;
            Optional alertDetail = this.alertRepository.findByAssetIdAndServiceCode(assetId, serviceCode);
            if (alertDetail.isPresent() && "Down".equals(status)) {
                Task task = new Task();
                task.setAssignedUser(Constants.TASK_ALERT_RECEIVER);
                task.setCreatedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
                task.setCreatedBy("system");
                task.setTasksName(serviceCode + ":" + category + "-" + ((Alert)alertDetail.get()).getIpAddress());
                task.setTaskDescription("Alert Generated Task");
                task.setTaskType(category);
                task.setTaskPriority(severityName);
                Long assignedOn = System.currentTimeMillis() / 1000L;
                logger.info("assignedOn:{}", (Object)assignedOn);
                task.setAssignedOn(assignedOn);
                Long expectedCompletion = assignedOn + 86400L;
                logger.info("assignedOn:{}", (Object)assignedOn);
                task.setExpectedCompletionDate(expectedCompletion);
                task.setCurrentStats("New");
                task.setAlertUuId(((Alert)alertDetail.get()).getUuid());
                task.setIsTaskCompleted(Boolean.valueOf(false));
                this.taskRepository.save((Object)task);
                returnValue.setStatus(0);
                returnValue.setMessage("created successfully");
                returnValue.setMessageDetail("Task created successfully");
                logger.info("Task saved: {}", (Object)returnValue.getMessage());
            } else if (alertDetail.isPresent() && !(taskList = this.taskRepository.findByAlertUuId(((Alert)alertDetail.get()).getUuid())).isEmpty()) {
                Task firstTask = (Task)taskList.get(0);
                for (Task row : taskList) {
                    row.setCurrentStats("Completed");
                    Long epoch = System.currentTimeMillis() / 1000L;
                    logger.info("epoch value:{}", (Object)epoch);
                    row.setChangedCompletionOn(epoch);
                    row.setExpectedCompletionDate(epoch);
                    row.setTaskCompletedOn(epoch);
                    row.setUpdatedBy("System");
                    row.setRemarks("System");
                    this.taskRepository.save((Object)row);
                    logger.info("changedCompletionOn:{}", (Object)row.getChangedCompletionOn());
                }
                TaskDetails taskDetails = new TaskDetails();
                taskDetails.setTaskId(firstTask.getId());
                taskDetails.setStatusUpdatedBy("System");
                taskDetails.setStatusUpdatedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
                taskDetails.setRemarks("Task automatically closed by system");
                this.taskDetailsRepository.save((Object)taskDetails);
                logger.info("Task ID: {}  , statusUpdatedOn: {}", (Object)taskDetails.getId(), (Object)taskDetails.getStatusUpdatedOn());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to create task");
            returnValue.setMessageDetail("Contact the administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
    }
}

