/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.MetricsData;
import com.coraltele.telemetry.model.CallModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class CallDataCollectionThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(CallDataCollectionThread.class);
    public volatile boolean isRunning = true;
    private Thread thread;
    RestTemplate restTemplate = new RestTemplate();

    public CallDataCollectionThread() {
        logger.info("Call Data Collection Thread");
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    @Override
    public void run() {
        while (true) {
            ResponseEntity response;
            if ((response = this.restTemplate.getForEntity(Constants.CALL_SERVER_IP + "/calls", CallModel[].class, new Object[0])).getBody() != null) {
                MetricsData.writeToHashMap((String)"activeCalls-calls", (Long)Long.valueOf(((CallModel[])response.getBody()).length));
                logger.info("Active Calls {}", (Object)((CallModel[])response.getBody()).length);
            } else {
                MetricsData.writeToHashMap((String)"activeCalls-calls", (Long)0L);
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("Unable to fetch call count ", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

