/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.widget_type.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.widget.service.WidgetService;
import com.coraltele.telemetry.service.coralnms.widget_type.model.WidgetTypeFileListModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class WidgetTypeService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final Logger logger = LogManager.getLogger(WidgetService.class);
    @Autowired
    WidgetTypeRepository widgetTypeRepository;

    private boolean doesWidgetTypeExist(Integer id) {
        return this.widgetTypeRepository.existsById((Object)id);
    }

    public RequestResponse storeDataIntoFile() throws IOException {
        RequestResponse returnValue = new RequestResponse();
        List list = this.widgetTypeRepository.findAll();
        ArrayList<WidgetTypeFileListModel> addValue = new ArrayList<WidgetTypeFileListModel>();
        ObjectMapper objectMapper = new ObjectMapper();
        String filePath = "/etc/coraltele/masters/widgetType.json";
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
                logger.info("New File Created Successfully");
            } else {
                logger.info("File Already Exists");
            }
            FileWriter fileWriter = new FileWriter(filePath);
            for (WidgetType widgetType : list) {
                if (!widgetType.isExport()) continue;
                WidgetTypeFileListModel data = new WidgetTypeFileListModel();
                data.setId(widgetType.getId());
                data.setCode(widgetType.getCode());
                data.setDescription(widgetType.getDescription());
                data.setExport(Boolean.valueOf(widgetType.isExport()));
                addValue.add(data);
            }
            String dataReceived = objectMapper.writeValueAsString(addValue);
            fileWriter.write(dataReceived);
            fileWriter.close();
            returnValue.setStatus(0);
            returnValue.setMessage("Stored ");
            returnValue.setMessageDetail("Data Stored Successfully");
            logger.info("Data Have Been Stored Successfully ");
        }
        catch (FileNotFoundException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Error while Storing Data Into File. ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs::", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse retrieveDataFromFileAndStoreInTable() throws IOException {
        RequestResponse returnValue = new RequestResponse();
        String filePath = "/etc/coraltele/masters/widgetType.json";
        try {
            WidgetTypeFileListModel[] data;
            File file = new File(filePath);
            if (!file.exists()) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("File Not Found");
                returnValue.setMessageDetail("File Not Present at the Server");
                logger.error("File not found");
                return returnValue;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            for (WidgetTypeFileListModel widgetTypeFileListModel : data = (WidgetTypeFileListModel[])objectMapper.readValue(file, WidgetTypeFileListModel[].class)) {
                Integer id = widgetTypeFileListModel.getId();
                WidgetType widgetType = new WidgetType();
                widgetType.setCode(widgetTypeFileListModel.getCode());
                widgetType.setDescription(widgetTypeFileListModel.getDescription());
                if (widgetTypeFileListModel.getExport() != null && !widgetTypeFileListModel.getExport().equals("")) {
                    widgetType.setExport(widgetTypeFileListModel.getExport().booleanValue());
                } else {
                    widgetType.setExport(true);
                }
                if (this.doesWidgetTypeExist(id)) {
                    String updateSql = "UPDATE coralnms.widget_type SET code=?, description=?, export=? WHERE id=?";
                    this.jdbcTemplate.update(updateSql, new Object[]{widgetType.getCode(), widgetType.getDescription(), widgetType.isExport(), id});
                    continue;
                }
                String insertSql = "INSERT INTO coralnms.widget_type (id,code, description, export) VALUES (?,?, ?, ?)";
                this.jdbcTemplate.update(insertSql, new Object[]{id, widgetType.getCode(), widgetType.getDescription(), widgetType.isExport()});
            }
            returnValue.setStatus(0);
            returnValue.setMessage("Data Retrieved and Stored");
            returnValue.setMessageDetail("Data Retrieved from File and Stored into Table Successfully");
            logger.info("Data Retrieved and Stored Successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present at the Server");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Error while Retrieving Data from File");
            returnValue.setMessageDetail("Unable to Retrieve Data from File");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        return returnValue;
    }
}

