/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telemetry.main.repository;

import com.coraltele.telemetry.db.telemetry.main.entity.Message;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MessageRepository
extends CrudRepository<Message, Integer> {
    public Optional<Message> findById(int var1);

    public Optional<Message> findByMessage(String var1);

    public List<Message> findAll();

    public List<Message> findByCreatedBy(String var1);

    public List<Message> findByCreatedByOrSentTo(String var1, String var2, Sort var3);

    public Page<Message> findAll(Pageable var1);

    @Modifying
    @Transactional
    @Query(value="update Message m set m.readByCreator = true where lower(m.createdBy) = :callSign")
    public void markMessageReadCreator(@Param(value="callSign") String var1);

    @Modifying
    @Transactional
    @Query(value="update Message m set m.readByRecipient = true where lower(m.sentTo) = :callSign")
    public void markMessageReadRecipient(@Param(value="callSign") String var1);

    @Query(value="select m from Message m where ((lower(m.createdBy) = :callSign and m.readByCreator = false)  or (lower(m.sentTo) = :callSign and m.readByRecipient = false)) and lower(m.createdBy) !=  'system' order by m.createdOn")
    public List<Message> getUnreadMessages(@Param(value="callSign") String var1);
}

