/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.DeviceManagerService;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.DeviceManagerConfigurationModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/deviceManager"})
public class DeviceManagerController {
    @Autowired
    private DeviceManagerService deviceService;

    @GetMapping(value={"/reboot/{macAddress}"})
    public ResponseEntity<RequestResponse> rebootDevice(@PathVariable String macAddress) {
        RequestResponse returnValue = new RequestResponse();
        String ApiName = "reboot";
        if (returnValue.getStatus() == 0) {
            returnValue = this.deviceService.resetOrReboot(macAddress, ApiName);
            return ResponseEntity.ok((Object)returnValue);
        }
        returnValue.setMessage("Reboot api call fail.");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/reset/{macAddress}"})
    public ResponseEntity<RequestResponse> resetDevice(@PathVariable String macAddress) {
        RequestResponse returnValue = new RequestResponse();
        String ApiName = "factoryReset";
        if (returnValue.getStatus() == 0) {
            returnValue = this.deviceService.resetOrReboot(macAddress, ApiName);
            return ResponseEntity.ok((Object)returnValue);
        }
        returnValue.setMessage("Reset api call fail.");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/updateConfiguration/{macAddress}"})
    public ResponseEntity<RequestResponse> uploadAndUpdateFile(@PathVariable String macAddress) {
        RequestResponse returnValue = new RequestResponse();
        String updateCall = "configuration";
        String Version2 = "";
        byte[] FileData = null;
        if (returnValue.getStatus() == 0) {
            returnValue = this.deviceService.upload(FileData, macAddress, updateCall, Version2);
            return ResponseEntity.ok((Object)returnValue);
        }
        returnValue.setMessage("Api configuration file upload and update failed.");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/updateFirmware/{macAddress}"})
    public ResponseEntity<RequestResponse> methodOfFirmwareUpdate(@PathVariable String macAddress) {
        RequestResponse returnValue = new RequestResponse();
        String updateCall = "firmware";
        if (returnValue.getStatus() == 0) {
            returnValue = this.deviceService.update(macAddress, updateCall);
            return ResponseEntity.ok((Object)returnValue);
        }
        returnValue.setMessage("Api firmware file upload and update failed.");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/uploadandupdateFirmware/{macAddress}"})
    public ResponseEntity<RequestResponse> methodOfFirmwareUploadAndUpdate(@PathVariable String macAddress) {
        RequestResponse returnValue = new RequestResponse();
        String updateCall = "firmware";
        String Version2 = "";
        byte[] FileData = null;
        if (returnValue.getStatus() == 0) {
            returnValue = this.deviceService.upload(FileData, macAddress, updateCall, Version2);
            return ResponseEntity.ok((Object)returnValue);
        }
        returnValue.setMessage("Api firmware file upload and update failed.");
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update/configuration/{macAddress}"})
    public ResponseEntity<RequestResponse> updateConfiguration(@PathVariable String macAddress, @RequestBody DeviceManagerConfigurationModel config) {
        RequestResponse response = new RequestResponse();
        if (macAddress == null || macAddress.trim().isEmpty()) {
            response.setStatus(-1);
            response.setMessage("MAC Address is missing.");
            return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
        }
        try {
            response = this.deviceService.updateConfiguration(macAddress, config);
            if (response.getStatus() == 0) {
                response.setMessage("Configuration updated successfully.");
                return ResponseEntity.ok((Object)response);
            }
            return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setMessage("Unexpected error while updating configuration.");
            response.setMessageDetail(e.getMessage());
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    @PostMapping(value={"/get/configuration/{macAddress}"})
    public ResponseEntity<RequestResponse> getConfiguration(@PathVariable String macAddress) {
        RequestResponse response = new RequestResponse();
        if (macAddress == null || macAddress.trim().isEmpty()) {
            response.setStatus(-1);
            response.setMessage("MAC Address is missing.");
            return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
        }
        try {
            response = this.deviceService.getConfiguration(macAddress);
            if (response.getStatus() == 0) {
                response.setMessage("Configuration fetch successfully.");
                return ResponseEntity.ok((Object)response);
            }
            return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setMessage("Unexpected error while fetch configuration.");
            response.setMessageDetail(e.getMessage());
            return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

