/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.JsonUtils;
import com.coraltele.telemetry.model.ExtensionModel;
import com.coraltele.telemetry.model.SCADATrapModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SnmpService {
    private TransportMapping<UdpAddress> transport;
    private Snmp snmp;
    private static final Logger logger = LogManager.getLogger(SnmpService.class);
    private final Hashtable<Integer, String> slotOidTable = new Hashtable();
    private final Hashtable<String, String> serviceOidTable = new Hashtable();

    public SnmpService() throws IOException {
        this.transport = StringUtils.hasText((String)Constants.SNMP_TRAP_SEND_SOURCE_IP) ? new DefaultUdpTransportMapping(new UdpAddress(String.format("%s/%d", Constants.SNMP_TRAP_SEND_SOURCE_IP, Constants.SNMP_TRAP_SEND_SOURCE_PORT))) : new DefaultUdpTransportMapping();
        this.snmp = new Snmp(this.transport);
        this.transport.listen();
        this.loadSlotAndServiceData();
    }

    private void loadSlotAndServiceData() {
        String slotPath = "default-data/icc-slot.json";
        String servicePath = "default-data/service.json";
        logger.info(" Loading icc-slot details from {}", (Object)slotPath);
        logger.info(" Loading service details from {}", (Object)servicePath);
        List iccSlotList = JsonUtils.readListFromJson((String)slotPath, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List serviceList = JsonUtils.readListFromJson((String)servicePath, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (iccSlotList.isEmpty()) {
            logger.warn("\u26a0\ufe0f No icc-slot details loaded from {}", (Object)slotPath);
        } else {
            iccSlotList.forEach(s -> this.slotOidTable.put(s.getSlotId(), s.getSlotOid()));
            logger.info("\u2705 Loaded icc-slot details from {}", (Object)slotPath);
        }
        if (serviceList.isEmpty()) {
            logger.warn("\u26a0\ufe0f No service details loaded from {}", (Object)servicePath);
        } else {
            serviceList.forEach(s -> this.serviceOidTable.put(s.getServiceId().toLowerCase(), s.getServiceOid()));
            logger.info("\u2705 Loaded service details from {}", (Object)servicePath);
        }
    }

    public String getSlotOid(Integer slot) {
        return (String)this.slotOidTable.get(slot);
    }

    public String getServiceOid(String name) {
        return (String)this.serviceOidTable.get(name.toLowerCase());
    }

    public synchronized void sendTrap(SCADATrapModel data, String category) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonData = "";
        if (data.getDeviceMessage() == null) {
            data.setDeviceMessage("");
        }
        if (data.getServiceCode() == null) {
            data.setServiceCode("");
        }
        if (data.getOid() == null || data.getOid().isEmpty()) {
            data.setOid(".1.3.6.1.4.1.15939.9999");
        }
        if (data.getSlotId() == null) {
            data.setSlotId(Integer.valueOf(-1));
        }
        if (data.getSlotName() == null) {
            data.setSlotName("");
        }
        if (data.getStackId() == null) {
            data.setStackId(Integer.valueOf(-1));
        }
        try {
            jsonData = objectMapper.writeValueAsString((Object)data);
        }
        catch (JsonProcessingException e1) {
            logger.error("Unable to convert data to JSON", (Throwable)e1);
        }
        logger.info("Send update local WSS server");
        if (StringUtils.hasText((String)Constants.SNMP_EVENT_SEND_URL)) {
            this.sendPost(jsonData);
        } else {
            logger.info("SNMP-EVENT-SEND-URL is empty");
        }
        logger.info("Update sent to local WSS server");
        if (Constants.ENABLE_SCADA_MESSAGE.booleanValue()) {
            logger.info("Sending SNMP Trap");
            try {
                String slotOid = "";
                String serviceOid = "";
                if (StringUtils.hasText((String)category) && (category.equalsIgnoreCase("icc4") || category.equalsIgnoreCase("icc3"))) {
                    slotOid = (String)this.slotOidTable.get(data.getSlotId());
                    serviceOid = (String)this.serviceOidTable.get(data.getSlotName().trim().toLowerCase());
                    logger.info("\ud83d\udd0d Mapped slotId={} \u2192 slotOid={}, slotName={} \u2192 serviceOid={}", (Object)data.getSlotId(), (Object)slotOid, (Object)data.getSlotName(), (Object)serviceOid);
                }
                for (String scadaServer : Constants.getScadaServers()) {
                    if (scadaServer.trim().isEmpty()) continue;
                    try {
                        CommunityTarget cTarget = new CommunityTarget();
                        cTarget.setCommunity(new OctetString(Constants.COMMUNITY));
                        cTarget.setVersion(1);
                        cTarget.setAddress((Address)new UdpAddress(scadaServer + "/" + Constants.SCADA_PORT));
                        cTarget.setRetries(2);
                        cTarget.setTimeout(5000L);
                        PDU pdu = new PDU();
                        String trapOID = data.getOid();
                        if (Constants.TELEMETRY_VERSION >= 2) {
                            trapOID = ".1.3.6.1.4.1.15939.5";
                            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(".1.3.6.1.4.1.15939.4.7")));
                        } else {
                            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(trapOID)));
                        }
                        pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new OctetString(new Date().toString())));
                        pdu.add(new VariableBinding(SnmpConstants.snmpTrapAddress, (Variable)new IpAddress(data.getIpAddress())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.1"), (Variable)new Integer32(data.getNodeId().intValue())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.2"), (Variable)new OctetString(data.getNodeName())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.3"), (Variable)new Integer32(data.getSeverity().intValue())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.4"), (Variable)new OctetString(data.getStatus())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.5"), (Variable)new OctetString(data.getStatusDetails())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.6"), (Variable)new Integer32(data.getSlotId().intValue())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.7"), (Variable)new OctetString(data.getSlotName())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.8"), (Variable)new Integer32(data.getStackId().intValue())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.9"), (Variable)new OctetString(data.getDeviceMessage())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.10"), (Variable)new OctetString(data.getOid())));
                        pdu.add(new VariableBinding(new OID(trapOID + ".1000.11"), (Variable)new OctetString(data.getServiceCode())));
                        if (slotOid != null) {
                            pdu.add(new VariableBinding(new OID(trapOID + ".1000.12"), (Variable)new OctetString(slotOid)));
                        } else {
                            slotOid = "";
                        }
                        if (serviceOid != null) {
                            pdu.add(new VariableBinding(new OID(trapOID + ".1000.13"), (Variable)new OctetString(serviceOid)));
                        } else {
                            serviceOid = "";
                        }
                        jsonData = jsonData + " slotOid: " + slotOid + ", serviceOid: " + serviceOid;
                        pdu.setType(-89);
                        this.snmp.send(pdu, (Target)cTarget);
                        this.snmp.close();
                        logger.info("Trap send to finished {} : trap details {}", (Object)scadaServer, (Object)jsonData);
                    }
                    catch (Exception e) {
                        logger.error("Unable to send to trap to {} : trap details {}", (Object)scadaServer, (Object)jsonData, (Object)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to open send socket using IP {} and port {}  {}", (Object)Constants.SNMP_TRAP_SEND_SOURCE_IP, (Object)Constants.SNMP_TRAP_SEND_SOURCE_PORT, (Object)e);
            }
        } else {
            logger.info("Skipped Sending SNMP Trap");
        }
    }

    public void sendTrapToTelemetry(Long epoch, OID trapOID, String label, String ipAddress, String value, String threshold, int status, String serviceNumber) {
        try {
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(Constants.COMMUNITY));
            target.setVersion(1);
            target.setAddress((Address)new UdpAddress(Constants.SNMP_AGENT_TARGET_IP + "/" + Constants.SNMP_AGENT_TARGET_PORT));
            target.setRetries(2);
            target.setTimeout(1500L);
            PDU pdu = new PDU();
            pdu.setType(-89);
            pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(epoch.longValue())));
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)trapOID));
            pdu.add(new VariableBinding(new OID(Constants.alertDeviceId), (Variable)new OctetString(ipAddress)));
            pdu.add(new VariableBinding(new OID(Constants.alertService), (Variable)new OctetString(label)));
            pdu.add(new VariableBinding(new OID(Constants.alertCurrentValue), (Variable)new OctetString(value)));
            pdu.add(new VariableBinding(new OID(Constants.alertThresholdValue), (Variable)new OctetString(threshold)));
            pdu.add(new VariableBinding(new OID(Constants.alertStatus), (Variable)new Integer32(status)));
            pdu.add(new VariableBinding(new OID(Constants.alertServiceNumber), (Variable)new OctetString(serviceNumber)));
            this.snmp.send(pdu, (Target)target);
            logger.info("SNMP trap sent to {}:{}", (Object)Constants.SNMP_AGENT_TARGET_IP, (Object)Constants.SNMP_AGENT_TARGET_PORT);
        }
        catch (Exception e) {
            logger.error("Error sending SNMP trap: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void sendPost(String data) {
        try {
            logger.info("Sending snmp-events to external websocket server: {} Data : {}", (Object)Constants.SNMP_EVENT_SEND_URL, (Object)data);
            HttpPost post = new HttpPost(Constants.SNMP_EVENT_SEND_URL);
            StringEntity requestEntity = new StringEntity(data, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            try (CloseableHttpClient httpClient = HttpClients.createDefault();
                 CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                String responseData = EntityUtils.toString((HttpEntity)response.getEntity());
                logger.info(responseData);
            }
            catch (Exception ex) {
                logger.error("Error while sending data to websocket server {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        catch (Exception ex) {
            logger.error("Error in sendPost()  {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public void sendExtensionUpdate(ExtensionModel data) {
        ObjectMapper objectMapper = new ObjectMapper();
        String jsonData = "";
        try {
            jsonData = objectMapper.writeValueAsString((Object)data);
        }
        catch (JsonProcessingException e1) {
            logger.error("Unable to convert data to JSON", (Throwable)e1);
        }
        for (String scadaServer : Constants.getScadaServers()) {
            if (scadaServer.trim().isEmpty()) continue;
            try {
                logger.info("Extension Trap send to start {} : trap details {}", (Object)scadaServer, (Object)jsonData);
                DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(new UdpAddress(String.format("%s/%d", Constants.SNMP_TRAP_SEND_SOURCE_IP, Constants.SNMP_TRAP_SEND_SOURCE_PORT)));
                CommunityTarget cTarget = new CommunityTarget();
                cTarget.setCommunity(new OctetString(Constants.COMMUNITY));
                cTarget.setVersion(1);
                cTarget.setAddress((Address)new UdpAddress(scadaServer + "/" + Constants.SCADA_PORT));
                cTarget.setRetries(2);
                cTarget.setTimeout(5000L);
                PDU pdu = new PDU();
                pdu.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new OctetString(new Date().toString())));
                pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(".1.3.6.1.4.1.15939.4.8")));
                pdu.add(new VariableBinding(SnmpConstants.snmpTrapAddress, (Variable)new IpAddress(data.getIpAddress())));
                pdu.add(new VariableBinding(new OID(".1.3.6.1.4.1.15939.5.2000.1"), (Variable)new OctetString(data.getNumber())));
                pdu.add(new VariableBinding(new OID(".1.3.6.1.4.1.15939.5.2000.2"), (Variable)new OctetString(data.getName())));
                pdu.add(new VariableBinding(new OID(".1.3.6.1.4.1.15939.5.2000.4"), (Variable)new OctetString(data.getLocation())));
                pdu.add(new VariableBinding(new OID(".1.3.6.1.4.1.15939.5.2000.3"), (Variable)new OctetString(data.getCallStatus())));
                pdu.setType(-89);
                Snmp snmp = new Snmp((TransportMapping)transport);
                snmp.send(pdu, (Target)cTarget);
                snmp.close();
                transport.close();
                logger.info("Trap send to finished {} : trap details {}", (Object)scadaServer, (Object)jsonData);
            }
            catch (Exception e) {
                logger.error("Unable to send to trap to {} : trap details {}", (Object)scadaServer, (Object)jsonData, (Object)e);
            }
        }
    }
}

