/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import com.coraltele.telemetry.db.users.main.entity.Role;
import com.coraltele.telemetry.db.users.main.repository.RoleRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRoleRepository;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class JwtUserDetailConfiguration
implements UserDetailsService {
    @Autowired(required=true)
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        Optional user = this.userRepository.findByUsername(username);
        if (!user.isPresent()) {
            throw new UsernameNotFoundException("User not found with username: " + username);
        }
        return new User(((com.coraltele.telemetry.db.users.main.entity.User)user.get()).getUsername(), ((com.coraltele.telemetry.db.users.main.entity.User)user.get()).getPassword(), new ArrayList());
    }

    public boolean hasRole(String username, String roleCode) {
        boolean returnValue = false;
        Optional user = this.userRepository.findByUsername(username);
        Optional role = this.roleRepository.findByShortCode(roleCode);
        if (user.isPresent() && role.isPresent()) {
            returnValue = this.userRoleRepository.findByUserAndRole((com.coraltele.telemetry.db.users.main.entity.User)user.get(), (Role)role.get()).isPresent();
        }
        return returnValue;
    }
}

