/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.helper.ICMPHelper;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PingCheckThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(PingCheckThread.class);
    SCADAAssetService scadaAssetService;
    ServiceStatus[] deviceList;

    public PingCheckThread(ServiceStatus[] deviceList, SCADAAssetService scadaAssetService) {
        this.scadaAssetService = scadaAssetService;
        this.deviceList = deviceList;
    }

    @Override
    public void run() {
        for (ServiceStatus device : this.deviceList) {
            Boolean isReachable = ICMPHelper.isIPAddressReachable((String)device.getIpAddress());
            device.setStatus(isReachable);
            ServiceStatus serviceStatus = new ServiceStatus(device);
            logger.info("Ping Check for {} {} {} {}", (Object)serviceStatus.getAssetId(), (Object)serviceStatus.getService(), (Object)serviceStatus.getIpAddress(), (Object)serviceStatus.getStatus());
            this.scadaAssetService.updateServiceStatus(serviceStatus);
        }
    }
}

