/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.user.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.user.model.UserModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/app/v2/auth"})
@RestController
public class UserAuthenticationController {
    private static final Logger logger = LogManager.getLogger(UserAuthenticationController.class);

    @PostMapping(value={"/status"})
    public ResponseEntity<RequestResponse> registerUser(@RequestBody UserModel data) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)"Active");
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/play"})
    public ResponseEntity<Resource> playMedia(@RequestParam(value="filePath") String filePath) {
        try {
            Path mediaPath = Paths.get(filePath, new String[0]).toAbsolutePath().normalize();
            UrlResource resource = new UrlResource(mediaPath.toUri());
            if (!resource.exists()) {
                logger.error("File not found at path: {}", (Object)filePath);
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            if (!resource.isReadable()) {
                logger.error("File at path {} is not readable", (Object)filePath);
                return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(null);
            }
            String mediaType = Files.probeContentType(mediaPath);
            if (mediaType == null) {
                mediaType = "application/octet-stream";
            }
            logger.info("Serving media file from path: {}", (Object)filePath);
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)mediaType)).body((Object)resource);
        }
        catch (MalformedURLException e) {
            logger.error("Invalid file path: {}", (Object)filePath, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
        }
        catch (IOException e) {
            logger.error("Error reading file at path: {}", (Object)filePath, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/upload/apkFile"})
    public ResponseEntity<RequestResponse> uploadFile(@RequestParam(value="file") MultipartFile file) {
        RequestResponse requestResponse = new RequestResponse();
        if (file.isEmpty()) {
            requestResponse.setIssue(Constants.NodeStatus.BAD_INPUT_DATA);
            requestResponse.setMessage("File is empty");
            requestResponse.setMessageDetail("No file was uploaded");
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        try {
            String originalFilename;
            Path baseDir = Paths.get("/var/www/files/ppdr/", new String[0]);
            if (!Files.exists(baseDir, new LinkOption[0])) {
                Files.createDirectories(baseDir, new FileAttribute[0]);
            }
            if ((originalFilename = file.getOriginalFilename()) == null || !originalFilename.endsWith(".apk")) {
                requestResponse.setIssue(Constants.NodeStatus.BAD_INPUT_DATA);
                requestResponse.setMessage("Invalid file type");
                requestResponse.setMessageDetail("Only .apk files are allowed");
                return ResponseEntity.badRequest().body((Object)requestResponse);
            }
            Path filePath = baseDir.resolve(originalFilename);
            String fileNameWithoutExtension = originalFilename.substring(0, originalFilename.lastIndexOf(46));
            String fileExtension = originalFilename.substring(originalFilename.lastIndexOf(46));
            int counter = 1;
            while (Files.exists(filePath, new LinkOption[0])) {
                filePath = baseDir.resolve(fileNameWithoutExtension + "_" + counter + fileExtension);
                ++counter;
            }
            try (InputStream inputStream = file.getInputStream();){
                Files.copy(inputStream, filePath, StandardCopyOption.REPLACE_EXISTING);
            }
            requestResponse.setIssue(Constants.NodeStatus.OK);
            requestResponse.setMessage("File uploaded");
            requestResponse.setMessageDetail("APK file uploaded successfully");
            requestResponse.setData((Object)filePath.getFileName().toString());
            return ResponseEntity.ok((Object)requestResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            requestResponse.setMessage("Error uploading file");
            requestResponse.setMessageDetail(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)requestResponse);
        }
    }

    @PostMapping(value={"/listApkFiles"})
    public ResponseEntity<String> listApkFiles() {
        RequestResponse requestResponse = new RequestResponse();
        ObjectMapper objectMapper = new ObjectMapper();
        Path baseDir = Paths.get("/var/www/files/ppdr/", new String[0]);
        try {
            if (!Files.exists(baseDir, new LinkOption[0]) || !Files.isDirectory(baseDir, new LinkOption[0])) {
                requestResponse.setIssue(Constants.NodeStatus.BAD_INPUT_DATA);
                requestResponse.setMessage("Invalid directory");
                requestResponse.setMessageDetail("The specified directory does not exist or is not a folder");
                return ResponseEntity.badRequest().body((Object)objectMapper.writeValueAsString((Object)requestResponse));
            }
            ArrayList apkFiles = new ArrayList();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
            DirectoryStream<Path> stream = Files.newDirectoryStream(baseDir, "*.apk");
            for (Path filePath : stream) {
                BasicFileAttributes attributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
                String uploadedOn = Instant.ofEpochMilli(attributes.lastModifiedTime().toMillis()).atZone(ZoneId.systemDefault()).format(formatter);
                HashMap<String, String> fileDetails = new HashMap<String, String>();
                fileDetails.put("fileName", filePath.getFileName().toString());
                fileDetails.put("uploadedOn", uploadedOn);
                apkFiles.add(fileDetails);
            }
            stream.close();
            requestResponse.setIssue(Constants.NodeStatus.OK);
            requestResponse.setMessage("APK files retrieved successfully");
            requestResponse.setMessageDetail("List of .apk files with upload date and time");
            requestResponse.setData(apkFiles);
            String jsonResponse = objectMapper.writeValueAsString((Object)requestResponse);
            return ResponseEntity.ok((Object)jsonResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            requestResponse.setMessage("Error retrieving APK files");
            requestResponse.setMessageDetail(e.getMessage());
            try {
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)objectMapper.writeValueAsString((Object)requestResponse));
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
                return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
        }
    }

    @GetMapping(value={"/download/{filename}"})
    public ResponseEntity<Resource> downloadFile(@PathVariable(value="filename") String filename) {
        try {
            Path baseDir = Paths.get("/var/www/files/ppdr/", new String[0]);
            Path filePath = baseDir.resolve(filename).normalize();
            if (!Files.exists(filePath, new LinkOption[0]) || !Files.isReadable(filePath)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            UrlResource resource = new UrlResource(filePath.toUri());
            if (!resource.exists() || !resource.isReadable()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = Files.probeContentType(filePath);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).body((Object)resource);
        }
        catch (MalformedURLException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/listen/{filename}"})
    public ResponseEntity<Resource> listenFile(@PathVariable(value="filename") String filename) {
        try {
            logger.info("Request file : {}", (Object)filename);
            Path baseDir = Paths.get("/home/coralswitch/queuesounds/", new String[0]);
            Path filePath = baseDir.resolve(filename).normalize();
            if (!Files.exists(filePath, new LinkOption[0]) || !Files.isReadable(filePath)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            UrlResource resource = new UrlResource(filePath.toUri());
            if (!resource.exists() || !resource.isReadable()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = Files.probeContentType(filePath);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).body((Object)resource);
        }
        catch (MalformedURLException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/listen-live-message/{filename}"})
    public ResponseEntity<Resource> listenLiveMessageFile(@PathVariable(value="filename") String filename) {
        try {
            logger.info("Request file : {}", (Object)filename);
            Path baseDir = Paths.get("/home/coralswitch/recorded-messages/", new String[0]);
            Path filePath = baseDir.resolve(filename).normalize();
            if (!Files.exists(filePath, new LinkOption[0]) || !Files.isReadable(filePath)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            UrlResource resource = new UrlResource(filePath.toUri());
            if (!resource.exists() || !resource.isReadable()) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = Files.probeContentType(filePath);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).body((Object)resource);
        }
        catch (MalformedURLException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(null);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

