/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.geo_pin.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.GeoPIN;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.GeoPINRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.telemetry.db.telemetry.main.entity.UserZone;
import com.coraltele.telemetry.db.telemetry.main.repository.UserCoordinateRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.HTTPHelper;
import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.ImsiZoneDeptartmentModel;
import com.coraltele.telemetry.model.geospatial.IMSIGeoTagModel;
import com.coraltele.telemetry.model.geospatial.TagModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.ChannelMessage;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.DeviceInformationModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.GeoPinModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.IMSIDataModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.RadioLinkModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.RadioUpdateDataModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.ZoneMessageModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GeoTaggingService {
    private static final Logger logger = LogManager.getLogger(GeoTaggingService.class);
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    GeoPINRepository geoPINRepository;
    @Autowired
    ExtensionRepository extensionRepository;
    @Autowired
    SCADAAssetRepository scAdaAssetRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserZoneRepository userZoneRepository;
    @Autowired
    UserCoordinateRepository userCoordinateRepository;

    public RequestResponse updateIMSICoordinates(IMSIGeoTagModel data) {
        Optional extension;
        RequestResponse returnValue = new RequestResponse();
        ImsiZoneDeptartmentModel imsiZoneDeptartmentValue = new ImsiZoneDeptartmentModel();
        try {
            if (Boolean.FALSE.equals(Constants.DISABLE_IMSI_LOCATION_UPDATE)) {
                Optional imsi = this.imsiRepository.findById((Object)data.getImsi());
                String currentZone = "";
                String currentDepartment = "";
                List userZone = this.userZoneRepository.getZone(data.getGeoX(), data.getGeoY());
                if (!userZone.isEmpty()) {
                    currentZone = ((UserZone)userZone.get(0)).getCode();
                }
                if (imsi.isPresent()) {
                    IMSI dataToSave = (IMSI)imsi.get();
                    dataToSave.setGeoX(data.getGeoX());
                    dataToSave.setGeoY(data.getGeoY());
                    dataToSave.setAlias(data.getAlias());
                    dataToSave.setDirection(data.getDirection());
                    dataToSave.setDeviceType(data.getDeviceType());
                    dataToSave.setUserName(data.getUserName());
                    dataToSave.setZone(currentZone);
                    dataToSave.setRadioLinkEpoch(Long.valueOf(System.currentTimeMillis()));
                    dataToSave.setRLinkStatus(Boolean.valueOf(data.getLinkStatus() != null ? data.getLinkStatus() : false));
                    Optional extension2 = this.extensionRepository.findByExtension(dataToSave.getExtensionNumber());
                    if (extension2.isPresent()) {
                        currentDepartment = ((Extension)extension2.get()).getDepartment();
                    }
                    dataToSave.setDepartment(currentDepartment);
                    imsiZoneDeptartmentValue.setImsiZone(dataToSave.getZone());
                    imsiZoneDeptartmentValue.setImsiDepartment(dataToSave.getDepartment());
                    this.imsiRepository.save((Object)dataToSave);
                    returnValue.setData((Object)imsiZoneDeptartmentValue);
                    Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "geoTagUpdate"), (Object)data);
                } else {
                    Optional extension3 = this.extensionRepository.findByExtension(data.getImsi());
                    if (extension3.isPresent()) {
                        currentDepartment = ((Extension)extension3.get()).getDepartment();
                    }
                    imsiZoneDeptartmentValue = this.addIMSI(data, currentZone, currentDepartment);
                    returnValue.setData((Object)imsiZoneDeptartmentValue);
                }
                returnValue.setStatus(0);
                returnValue.setMessage("Imsi Zone and Department Values :");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Error while finding Zone and Department of IMSI.");
            e.printStackTrace();
            logger.error("Error while finding Zone and Department of IMSI: {} {}", (Object)e.getMessage(), (Object)e);
        }
        if (!StringUtils.hasText((String)imsiZoneDeptartmentValue.getImsiZone()) && (extension = this.extensionRepository.findByExtension(data.getImsi())).isPresent()) {
            imsiZoneDeptartmentValue.setImsiZone(((Extension)extension.get()).getZone());
            returnValue.setData((Object)imsiZoneDeptartmentValue);
        }
        return returnValue;
    }

    public RequestResponse updateExtensionCoordinates(IMSIGeoTagModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            ImsiZoneDeptartmentModel imsiZoneDeptartmentValue = new ImsiZoneDeptartmentModel();
            if (Boolean.FALSE.equals(Constants.DISABLE_IMSI_LOCATION_UPDATE)) {
                Optional imsi = this.imsiRepository.findByExtensionNumber(data.getImsi());
                String currentZone = "";
                String currentDepartment = "";
                List userZone = this.userZoneRepository.getZone(data.getGeoX(), data.getGeoY());
                if (!userZone.isEmpty()) {
                    currentZone = ((UserZone)userZone.get(0)).getCode();
                }
                if (imsi.isPresent()) {
                    IMSI dataToSave = (IMSI)imsi.get();
                    dataToSave.setGeoX(data.getGeoX());
                    dataToSave.setGeoY(data.getGeoY());
                    dataToSave.setAlias(data.getAlias());
                    dataToSave.setDirection(data.getDirection());
                    dataToSave.setDeviceType(data.getDeviceType());
                    dataToSave.setUserName(data.getUserName());
                    dataToSave.setZone(currentZone);
                    dataToSave.setUpdatedBy(currentDepartment);
                    Optional extension = this.extensionRepository.findByExtension(dataToSave.getExtensionNumber());
                    if (extension.isPresent()) {
                        currentDepartment = ((Extension)extension.get()).getDepartment();
                    }
                    dataToSave.setDepartment(currentDepartment);
                    imsiZoneDeptartmentValue.setImsiZone(dataToSave.getZone());
                    imsiZoneDeptartmentValue.setImsiDepartment(dataToSave.getDepartment());
                    this.imsiRepository.save((Object)dataToSave);
                    returnValue.setData((Object)imsiZoneDeptartmentValue);
                    Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "geoTagUpdate"), (Object)data);
                } else {
                    Optional extension = this.extensionRepository.findByExtension(data.getImsi());
                    if (extension.isPresent()) {
                        currentDepartment = ((Extension)extension.get()).getDepartment();
                    }
                    imsiZoneDeptartmentValue = this.addIMSI(data, currentZone, currentDepartment);
                    returnValue.setData((Object)imsiZoneDeptartmentValue);
                }
                returnValue.setStatus(0);
                returnValue.setMessage("Imsi Zone and Department Values :");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Error while finding Zone and Department of IMSI.");
            e.printStackTrace();
            logger.error("Error while finding Zone and Department of IMSI: {} {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public RequestResponse getGeoTagList() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TagModel> data = new ArrayList<TagModel>();
        List imsiList = this.imsiRepository.findAll();
        for (IMSI imsi : imsiList) {
            TagModel row = new TagModel();
            row.setTagType("imsi");
            row.setId(imsi.getImsiNumber());
            row.setName(String.format("%s - %s", imsi.getExtensionName(), imsi.getExtensionNumber()));
            row.setExtensionNumber(imsi.getExtensionNumber());
            row.setGeoX(imsi.getGeoX());
            row.setGeoY(imsi.getGeoY());
            row.setStatus(imsi.getConnected());
            row.setEmergencyStatus(imsi.getEmergencyStatus());
            row.setZone(imsi.getZone());
            row.setDepartment(imsi.getDepartment());
            row.setCreatedOn(imsi.getCreatedOn());
            row.setDeviceType(imsi.getDeviceType());
            if (imsi.getData() != null && !imsi.getData().isEmpty()) {
                try {
                    ObjectMapper om = new ObjectMapper();
                    IMSIDataModel imsiData = (IMSIDataModel)om.readValue(imsi.getData(), IMSIDataModel.class);
                    row.setData((Object)imsiData);
                }
                catch (Exception om) {
                    // empty catch block
                }
            }
            if (imsi.getExtensionNumber() != null && StringUtils.hasText((String)imsi.getExtensionNumber())) {
                row.setUserName(this.getUserByExtension(imsi.getExtensionNumber()));
            }
            data.add(row);
        }
        List geoPinList = this.geoPINRepository.findAll();
        for (GeoPIN pin : geoPinList) {
            TagModel row = new TagModel();
            row.setTagType("pin");
            row.setId(pin.getId().toString());
            row.setName(pin.getName());
            row.setGeoX(pin.getGeoX());
            row.setGeoY(pin.getGeoY());
            row.setStatus(Boolean.valueOf(true));
            row.setEmergencyStatus("");
            data.add(row);
        }
        returnValue.setData(data);
        return returnValue;
    }

    public RequestResponse createGeoPIN(GeoPinModel data) {
        logger.debug("create new geoPin : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            GeoPIN geoPIN = new GeoPIN();
            geoPIN.setName(data.getName());
            geoPIN.setGeoX(data.getGeoX());
            geoPIN.setGeoY(data.getGeoY());
            this.geoPINRepository.save((Object)geoPIN);
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("GeoPIN created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create geoPin");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(GeoPinModel data) {
        logger.debug("Update GeoPin {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional geoPin = this.geoPINRepository.findById(data.getId());
        if (!geoPin.isPresent()) {
            returnValue.setStatus(-1);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("GeoPin not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getGeoX() != null) {
            ((GeoPIN)geoPin.get()).setGeoX(data.getGeoX());
        }
        if (data.getGeoY() != null) {
            ((GeoPIN)geoPin.get()).setGeoY(data.getGeoY());
        }
        if (data.getName() != null) {
            ((GeoPIN)geoPin.get()).setName(data.getName());
        }
        this.geoPINRepository.save(geoPin.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("GeoPin Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse enableEmergency(String imsi) {
        logger.debug("Enable emergency for imsi {}", (Object)imsi);
        RequestResponse returnValue = new RequestResponse();
        List userCoordinateRow = this.userCoordinateRepository.findByExtensionNumber(imsi);
        if (!userCoordinateRow.isEmpty()) {
            try {
                ((UserCoordinate)userCoordinateRow.get(0)).setEmergencyStatus("Emergency");
                ((UserCoordinate)userCoordinateRow.get(0)).setEmergencyCreatedOn(LocalDateTime.now());
                this.userCoordinateRepository.save(userCoordinateRow.get(0));
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to Mark Emergency");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to Mark Emergency");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse clearEmergency(String extensionNumber) {
        logger.debug("Enable emergency for extensionNumber {}", (Object)extensionNumber);
        RequestResponse returnValue = new RequestResponse();
        List imsiRow = this.userCoordinateRepository.findByExtensionNumber(extensionNumber);
        if (!imsiRow.isEmpty()) {
            try {
                for (UserCoordinate row : imsiRow) {
                    row.setEmergencyStatus("");
                    this.userCoordinateRepository.save((Object)row);
                }
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to Clear Emergency");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to Clear Emergency");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse deleteGeoPin(Long id) {
        logger.debug("Delete geoPin id {}", (Object)id);
        RequestResponse returnValue = new RequestResponse();
        Optional geoPIN = this.geoPINRepository.findById(id);
        if (geoPIN.isPresent()) {
            try {
                this.geoPINRepository.deleteById((Object)id);
                returnValue.setStatus(0);
                returnValue.setMessage("geoPin deleted");
                logger.info(returnValue.getMessage());
            }
            catch (Exception ex) {
                returnValue.setStatus(-1);
                returnValue.setMessage("Unable to delete geoPin");
                returnValue.setMessageDetail("Contact with your administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)ex);
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to delete record");
            returnValue.setMessageDetail("Record Not found");
            logger.error(returnValue.getMessageDetail());
        }
        return returnValue;
    }

    public RequestResponse sendZoneMessage(ZoneMessageModel data) {
        RequestResponse returnValue = new RequestResponse();
        List dataToSendMessages = this.imsiRepository.findAllByZone(data.getZone());
        for (IMSI imsi : dataToSendMessages) {
            ChannelMessage message = new ChannelMessage();
            message.setTopic(String.format("dm_%s_alert", imsi.getExtensionNumber()));
            message.setSubTopic(data.getZone());
            message.setNumber(imsi.getExtensionNumber());
            message.setName(data.getMessage());
            HTTPHelper.sendToWebSocket((ChannelMessage)message);
        }
        return returnValue;
    }

    public ImsiZoneDeptartmentModel addIMSI(IMSIGeoTagModel data, String currentZone, String currentDepartment) {
        logger.info("data for imsi creation:{}", (Object)data);
        String extensionName = "";
        ImsiZoneDeptartmentModel returnValue = new ImsiZoneDeptartmentModel();
        try {
            Optional extensionData = this.extensionRepository.findByExtension(data.getImsi());
            Optional assetId = this.scAdaAssetRepository.findById(Long.valueOf(1L));
            if (extensionData.isPresent() && ((Extension)extensionData.get()).getName() != null) {
                extensionName = ((Extension)extensionData.get()).getName();
            }
            IMSI newRecord = new IMSI();
            newRecord.setImsiNumber(data.getImsi());
            newRecord.setCellId("0x0000000");
            newRecord.setConnected(Boolean.valueOf(true));
            if (assetId.isPresent()) {
                newRecord.setAsset((SCADAAsset)assetId.get());
            }
            newRecord.setExtensionName(extensionName);
            newRecord.setExtensionNumber(data.getImsi());
            newRecord.setGeoX(data.getGeoX());
            newRecord.setGeoY(data.getGeoY());
            newRecord.setAlias(data.getAlias());
            newRecord.setDirection(data.getDirection());
            newRecord.setDeviceType(data.getDeviceType());
            newRecord.setUserName(data.getUserName());
            newRecord.setZone(currentZone);
            newRecord.setDepartment(currentDepartment);
            returnValue.setImsiZone(newRecord.getZone());
            returnValue.setImsiDepartment(newRecord.getDepartment());
            this.imsiRepository.save((Object)newRecord);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error while adding new Imsi : {} {} ", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public RequestResponse getGeoTagListCabRadio() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TagModel> data = new ArrayList<TagModel>();
        List imsiList = this.imsiRepository.findByDeviceType("CAB Radio");
        for (IMSI imsi : imsiList) {
            TagModel row = new TagModel();
            row.setTagType("imsi");
            row.setId(imsi.getImsiNumber());
            row.setName(String.format("%s - %s", imsi.getExtensionName(), imsi.getExtensionNumber()));
            row.setExtensionNumber(imsi.getExtensionNumber());
            row.setGeoX(imsi.getGeoX());
            row.setGeoY(imsi.getGeoY());
            row.setStatus(imsi.getConnected());
            row.setEmergencyStatus(imsi.getEmergencyStatus());
            row.setAlias(imsi.getAlias());
            row.setDeviceType(imsi.getDeviceType());
            row.setUserName(imsi.getUserName());
            row.setDirection(imsi.getDirection());
            row.setCreatedOn(imsi.getCreatedOn());
            row.setDeviceType(imsi.getDeviceType());
            if (imsi.getData() != null && !imsi.getData().isEmpty()) {
                try {
                    ObjectMapper om = new ObjectMapper();
                    IMSIDataModel imsiData = (IMSIDataModel)om.readValue(imsi.getData(), IMSIDataModel.class);
                    row.setData((Object)imsiData);
                }
                catch (Exception om) {
                    // empty catch block
                }
            }
            data.add(row);
        }
        List geoPinList = this.geoPINRepository.findAll();
        for (GeoPIN pin : geoPinList) {
            TagModel row = new TagModel();
            row.setTagType("pin");
            row.setId(pin.getId().toString());
            row.setName(pin.getName());
            row.setGeoX(pin.getGeoX());
            row.setGeoY(pin.getGeoY());
            row.setStatus(Boolean.valueOf(true));
            row.setEmergencyStatus("");
            data.add(row);
        }
        returnValue.setData(data);
        return returnValue;
    }

    public String getZoneOfUser(String username) {
        Optional extensionData;
        String extension = this.getExtensionOfUser(username);
        if (extension != null && StringUtils.hasText((String)extension) && (extensionData = this.extensionRepository.findByExtension(extension)).isPresent()) {
            return ((Extension)extensionData.get()).getZone();
        }
        return "";
    }

    public String getExtensionOfUser(String username) {
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            String contactNo = ((User)user.get()).getContactNo();
            Optional data = this.extensionRepository.findByExtension(contactNo);
            if (data.isPresent() && contactNo.equals(((Extension)data.get()).getExtension())) {
                String extensionType = ((Extension)data.get()).getExtensionType();
                if ("phone".equals(extensionType) || "agent".equals(extensionType)) {
                    return contactNo;
                }
            } else {
                Optional extension = this.extensionRepository.findByAssignedUserAndExtensionType(username, "phone");
                if (extension.isPresent()) {
                    return ((Extension)extension.get()).getExtension();
                }
                return "";
            }
        }
        return "";
    }

    public RequestResponse getGeoTagListCabRadioCoordinates(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TagModel> data = new ArrayList<TagModel>();
        List imsiList = this.imsiRepository.findByDeviceType("CAB Radio");
        String zoneOfUser = this.getZoneOfUser(principal.getName());
        List allDirection = this.userZoneRepository.findByDescription(zoneOfUser);
        logger.info("Current data of UserZone Master is:{}", (Object)allDirection.size());
        if (!allDirection.isEmpty()) {
            UserZone activeZone = (UserZone)allDirection.get(0);
            for (IMSI imsi : imsiList) {
                if (!activeZone.getDescription().equals(zoneOfUser)) continue;
                TagModel row = new TagModel();
                row.setTagType("imsi");
                row.setId(imsi.getImsiNumber());
                row.setName(String.format("%s - %s", imsi.getExtensionName(), imsi.getExtensionNumber()));
                row.setExtensionNumber(imsi.getExtensionNumber());
                row.setGeoX(imsi.getGeoX());
                row.setGeoY(imsi.getGeoY());
                row.setStatus(imsi.getConnected());
                row.setEmergencyStatus(imsi.getEmergencyStatus());
                row.setAlias(imsi.getAlias());
                row.setDeviceType(imsi.getDeviceType());
                row.setUserName(imsi.getUserName());
                row.setDirection(imsi.getDirection());
                row.setCreatedOn(imsi.getCreatedOn());
                row.setDeviceType(imsi.getDeviceType());
                if (imsi.getData() != null && !imsi.getData().isEmpty()) {
                    try {
                        ObjectMapper om = new ObjectMapper();
                        IMSIDataModel imsiData = (IMSIDataModel)om.readValue(imsi.getData(), IMSIDataModel.class);
                        row.setData((Object)imsiData);
                    }
                    catch (Exception om) {
                        // empty catch block
                    }
                }
                data.add(row);
            }
            List geoPinList = this.geoPINRepository.findAll();
            for (GeoPIN pin : geoPinList) {
                TagModel row = new TagModel();
                row.setTagType("pin");
                row.setId(pin.getId().toString());
                row.setName(pin.getName());
                row.setGeoX(pin.getGeoX());
                row.setGeoY(pin.getGeoY());
                row.setStatus(Boolean.valueOf(true));
                row.setEmergencyStatus("");
                data.add(row);
            }
            returnValue.setData(data);
        }
        return returnValue;
    }

    public RequestResponse getEmergentStatusList() {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TagModel> data = new ArrayList<TagModel>();
        List imsiList = this.userCoordinateRepository.getALLEmergency();
        if (!imsiList.isEmpty()) {
            for (UserCoordinate imsi : imsiList) {
                TagModel row = new TagModel();
                row.setTagType("user-coordinate");
                row.setUserCoordinateId(imsi.getId());
                row.setName(String.format("%s - %s", imsi.getUsername(), imsi.getExtensionNumber()));
                row.setExtensionNumber(imsi.getExtensionNumber());
                row.setGeoX(imsi.getGeoX());
                row.setGeoY(imsi.getGeoY());
                row.setStatus(imsi.getConnected());
                row.setEmergencyStatus(imsi.getEmergencyStatus());
                row.setAlias(imsi.getAlias());
                row.setDeviceType(imsi.getDeviceType());
                row.setUserName(imsi.getUsername());
                row.setDirection(imsi.getDirection());
                row.setCreatedOn(imsi.getEmergencyCreatedOn());
                data.add(row);
            }
        } else {
            logger.error("there is no any emergency");
            returnValue.setStatus(2);
            returnValue.setMessage("No Any Active emergency");
            return returnValue;
        }
        returnValue.setData(data);
        returnValue.setStatus(0);
        returnValue.setMessage("list of emergency");
        return returnValue;
    }

    public RequestResponse getGeoTagByZone(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<TagModel> data = new ArrayList<TagModel>();
        String zoneOfUser = this.getZoneOfUser(principal.getName());
        List imsiList = this.imsiRepository.findAllByZone(zoneOfUser);
        for (IMSI imsi : imsiList) {
            TagModel row = new TagModel();
            row.setTagType("imsi");
            row.setId(imsi.getImsiNumber());
            row.setName(String.format("%s - %s", imsi.getExtensionName(), imsi.getExtensionNumber()));
            row.setExtensionNumber(imsi.getExtensionNumber());
            row.setGeoX(imsi.getGeoX());
            row.setGeoY(imsi.getGeoY());
            row.setStatus(imsi.getConnected());
            row.setEmergencyStatus(imsi.getEmergencyStatus());
            row.setAlias(imsi.getAlias());
            row.setDeviceType(imsi.getDeviceType());
            row.setUserName(imsi.getUserName());
            row.setDirection(imsi.getDirection());
            row.setCreatedOn(imsi.getCreatedOn());
            if (imsi.getData() != null && !imsi.getData().isEmpty()) {
                try {
                    ObjectMapper om = new ObjectMapper();
                    IMSIDataModel imsiData = (IMSIDataModel)om.readValue(imsi.getData(), IMSIDataModel.class);
                    row.setData((Object)imsiData);
                }
                catch (Exception om) {
                    // empty catch block
                }
            }
            data.add(row);
        }
        List geoPinList = this.geoPINRepository.findAll();
        for (GeoPIN pin : geoPinList) {
            TagModel row = new TagModel();
            row.setTagType("pin");
            row.setId(pin.getId().toString());
            row.setName(pin.getName());
            row.setGeoX(pin.getGeoX());
            row.setGeoY(pin.getGeoY());
            row.setStatus(Boolean.valueOf(true));
            row.setEmergencyStatus("");
            data.add(row);
        }
        returnValue.setData(data);
        return returnValue;
    }

    public RequestResponse updateIMSI(RadioLinkModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<RadioUpdateDataModel> radioUpdateData = new ArrayList<RadioUpdateDataModel>();
        try {
            Optional imsi = this.imsiRepository.findById((Object)data.getImsi());
            if (imsi.isPresent()) {
                IMSI dataToSave = (IMSI)imsi.get();
                dataToSave.setTrainNumber(data.getTrainNumber());
                dataToSave.setRadioLinkEpoch(Long.valueOf(System.currentTimeMillis()));
                this.imsiRepository.save((Object)dataToSave);
                returnValue.setStatus(0);
                returnValue.setMessage("IMSI updated successfully");
                for (RadioUpdateDataModel radioData : data.getRadioUpdateData()) {
                    Optional radioIMSI = this.imsiRepository.findByExtensionNumber(radioData.getExtNumber());
                    if (!radioIMSI.isPresent()) continue;
                    IMSI data1 = (IMSI)radioIMSI.get();
                    RadioUpdateDataModel radioUpdate = new RadioUpdateDataModel();
                    radioUpdate.setImsi(data1.getImsiNumber());
                    radioUpdate.setExtNumber(data1.getExtensionNumber());
                    radioUpdate.setRadioLinkEpoch(data1.getRadioLinkEpoch());
                    radioUpdate.setRLinkStatus(Boolean.valueOf(data1.getRLinkStatus() != null ? data1.getRLinkStatus() : false));
                    radioUpdateData.add(radioUpdate);
                }
                returnValue.setData(radioUpdateData);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("IMSI not found");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Error while finding IMSI.");
            e.printStackTrace();
            logger.error("Error while findingIMSI: {},{}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public IMSI getImsiByExtension(String extension) {
        try {
            return this.imsiRepository.findByExtensionNumber(extension).orElse(null);
        }
        catch (Exception e) {
            logger.error("Error fetching IMSI by extension: " + extension, (Throwable)e);
            return null;
        }
    }

    public String getUserByExtension(String extension) {
        List userList = this.userRepository.findByContactNo(extension);
        if (!userList.isEmpty()) {
            return ((User)userList.get(0)).getUsername();
        }
        return "";
    }

    public void updateDeviceUser(DeviceInformationModel data) {
        logger.info("Device Information for imsi:{}", (Object)data);
        Optional imSiData = this.imsiRepository.findByDeviceId(data.getDeviceId());
        if (imSiData.isPresent()) {
            if (data.getDeviceId() != null) {
                ((IMSI)imSiData.get()).setDeviceId(data.getDeviceId());
            }
            if (data.getBatteryPercentage() != null) {
                ((IMSI)imSiData.get()).setBatteryPercentage(data.getBatteryPercentage());
            }
            if (data.getRsrpData() != null) {
                if (data.getRsrpData().getSim1() != null) {
                    ((IMSI)imSiData.get()).setRsRpSim1(data.getRsrpData().getSim1());
                }
                if (data.getRsrpData().getSim2() != null) {
                    ((IMSI)imSiData.get()).setRsRpSim2(data.getRsrpData().getSim2());
                }
            }
            if (data.getUsername() != null) {
                ((IMSI)imSiData.get()).setUserName(data.getUsername());
            }
            this.imsiRepository.save(imSiData.get());
        }
    }
}

