/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.db.coralapps.entity.Agent;
import com.coraltele.telemetry.db.coralapps.entity.OperatorMaster;
import com.coraltele.telemetry.db.coralapps.repository.AgentRepository;
import com.coraltele.telemetry.db.coralapps.repository.OperatorMasterRepository;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.model.CDRSetAgentNameModel;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class GetAgentFullName {
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private OperatorMasterRepository callCenterOperatorMasterRepository;
    @Autowired
    private AgentRepository agentRepository;

    public CDRSetAgentNameModel getAgentName(String agentName) {
        CDRSetAgentNameModel returnValue = new CDRSetAgentNameModel();
        Optional operatorMasterData = this.callCenterOperatorMasterRepository.findByExtension(agentName);
        boolean isAcd = operatorMasterData.isPresent();
        if (isAcd) {
            if (operatorMasterData.isPresent() && StringUtils.hasText((String)((OperatorMaster)operatorMasterData.get()).getOperatorCode())) {
                Optional userDeatils = this.userRepository.findByUsername(((OperatorMaster)operatorMasterData.get()).getOperatorCode());
                if (userDeatils.isPresent() && StringUtils.hasText((String)((User)userDeatils.get()).getDescription())) {
                    returnValue.setAgentName(((User)userDeatils.get()).getDescription());
                } else {
                    returnValue.setAgentName(((OperatorMaster)operatorMasterData.get()).getOperatorCode());
                }
                returnValue.setAgent(((OperatorMaster)operatorMasterData.get()).getOperatorCode());
            } else {
                returnValue.setAgentName(agentName);
            }
        } else {
            Optional userDetailsOptional = this.userRepository.findByUsername(agentName);
            Optional agentDataOptional = this.agentRepository.findByName(agentName);
            if (userDetailsOptional.isPresent() && agentDataOptional.isPresent()) {
                User userDetails = (User)userDetailsOptional.get();
                Agent agentData = (Agent)agentDataOptional.get();
                if (!StringUtils.hasText((String)userDetails.getDescription())) {
                    userDetails.setDescription("");
                }
                if (!StringUtils.hasText((String)agentData.getAgentFullName())) {
                    agentData.setAgentFullName("");
                }
                if (StringUtils.hasText((String)userDetails.getDescription())) {
                    if (!userDetails.getDescription().equalsIgnoreCase(agentData.getAgentFullName())) {
                        agentData.setAgentFullName(userDetails.getDescription());
                        this.agentRepository.save((Object)agentData);
                    }
                    returnValue.setAgentName(userDetails.getDescription());
                } else {
                    returnValue.setAgentName(agentName);
                }
            } else {
                returnValue.setAgentName(agentName);
            }
        }
        return returnValue;
    }
}

