/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.main.entity.SubscriberAlertCurrent;
import com.coraltele.telemetry.db.telemetry.main.repository.SubscriberAlertCurrentRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.SnmpService;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AlertEngineService {
    private static final Logger logger = LoggerFactory.getLogger(AlertEngineService.class);
    @Autowired
    private SubscriberAlertCurrentRepository subscriberAlertCurrentRepository;
    @Autowired
    SnmpService snmpService;

    @Transactional(transactionManager="telemetryTransactionManager")
    public void raiseAlert(String subscriberNumber, String service, int severity, String reason) {
        Optional existingAlertOpt = this.subscriberAlertCurrentRepository.findBySubscriberNumberAndService(subscriberNumber, service);
        Long currentTime = Instant.now().getEpochSecond();
        logger.debug("Alert received for subscriber: {}, service: {}, severity: {}", new Object[]{subscriberNumber, service, severity});
        if (existingAlertOpt.isPresent()) {
            SubscriberAlertCurrent alert = (SubscriberAlertCurrent)existingAlertOpt.get();
            if (alert.getClosedAt() != null) {
                logger.info("Reopening alert for subscriber: {}, service: {}", (Object)subscriberNumber, (Object)service);
                alert.setOpenedAt(currentTime);
                alert.setLastSeenAt(currentTime);
                alert.setClosedAt(null);
                alert.setSeverity(Integer.valueOf(severity));
                alert.setReason(reason);
                alert.setHistoryId(UUID.randomUUID().toString());
                this.subscriberAlertCurrentRepository.save((Object)alert);
                this.snmpService.sendTrapToTelemetry(currentTime, Constants.SNMP_AGENT_CALL_SERVER_SUBSCRIBER_TRAP, service, "", "", "", severity, subscriberNumber);
            } else {
                alert.setLastSeenAt(currentTime);
                alert.setSeverity(Integer.valueOf(severity));
                alert.setReason(reason);
                this.subscriberAlertCurrentRepository.save((Object)alert);
            }
        } else {
            logger.info("Opening new alert for subscriber: {}, service: {}", (Object)subscriberNumber, (Object)service);
            SubscriberAlertCurrent newAlert = new SubscriberAlertCurrent();
            newAlert.setSubscriberNumber(subscriberNumber);
            newAlert.setService(service);
            newAlert.setSeverity(Integer.valueOf(severity));
            newAlert.setOpenedAt(currentTime);
            newAlert.setLastSeenAt(currentTime);
            newAlert.setReason(reason);
            newAlert.setHistoryId(UUID.randomUUID().toString());
            this.subscriberAlertCurrentRepository.save((Object)newAlert);
            this.snmpService.sendTrapToTelemetry(currentTime, Constants.SNMP_AGENT_CALL_SERVER_SUBSCRIBER_TRAP, service, "", "", "", severity, subscriberNumber);
        }
    }

    @Transactional(transactionManager="telemetryTransactionManager")
    public void closeAlert(String subscriberNumber, String service) {
        SubscriberAlertCurrent alert;
        Optional existingAlert = this.subscriberAlertCurrentRepository.findBySubscriberNumberAndService(subscriberNumber, service);
        Long currentTime = Instant.now().getEpochSecond();
        logger.debug("Closing alert for subscriber: {}, service: {}", (Object)subscriberNumber, (Object)service);
        if (existingAlert.isPresent() && (alert = (SubscriberAlertCurrent)existingAlert.get()).getClosedAt() == null) {
            logger.info("Closing alert for subscriber: {}, service: {}", (Object)subscriberNumber, (Object)service);
            alert.setClosedAt(currentTime);
            alert.setReason("");
            alert.setHistoryId(UUID.randomUUID().toString());
            this.subscriberAlertCurrentRepository.save((Object)alert);
            this.snmpService.sendTrapToTelemetry(currentTime, Constants.SNMP_AGENT_CALL_SERVER_SUBSCRIBER_TRAP, service, "", "", "", 0, subscriberNumber);
        }
    }
}

