/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

@Configuration
@PropertySource(value={"classpath:git.properties"})
public class BuildInfo {
    private static final Logger logger = LogManager.getLogger(BuildInfo.class);
    @Autowired
    private Environment env;

    public String getCommitId() {
        return this.env.getProperty("git.commit.id.abbrev", "Release id not available");
    }

    public String getBranch() {
        return this.env.getProperty("git.branch", "Release id not available");
    }

    public String getVersion() {
        return this.env.getProperty("git.build.version", "Release id not available");
    }

    public String getBuildDateTime() {
        return this.env.getProperty("git.build.time", "Release time not available");
    }

    @PostConstruct
    public void init() {
        logger.info("============================ Build Info - Start ============================");
        logger.info("Build Branch : {}", (Object)this.getBranch());
        logger.info("Build ID : {}", (Object)this.getCommitId());
        logger.info("Build Time : {}", (Object)this.getBuildDateTime());
        logger.info("Build Version : {}", (Object)this.getVersion());
        logger.info("============================ Build Info - End   ============================");
    }
}

