/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.user.service;

import com.coraltele.telemetry.db.users.main.entity.Role;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.entity.UserRole;
import com.coraltele.telemetry.db.users.main.entity.UserRoleMenu;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRoleMenuRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRoleRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.user.model.MenuGroupModel;
import com.coraltele.telemetry.service.user.model.MenuModel;
import com.coraltele.telemetry.service.user.model.MenuSubGroupModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserRoleMenuService {
    private static final Logger logger = LogManager.getLogger(UserRoleMenuService.class);
    @Autowired
    private UserRoleMenuRepository userRoleMenuRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;

    public List<MenuGroupModel> menusForRolesOfParticularUser(String username) {
        RequestResponse returnData = new RequestResponse();
        ArrayList<MenuGroupModel> returnValue = new ArrayList<MenuGroupModel>();
        ArrayList<Role> listRole = new ArrayList<Role>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRoleTraverse : userRole) {
                listRole.add(userRoleTraverse.getRole());
            }
            List listUserRoleMenus = this.userRoleMenuRepository.findAllByRoleIn(listRole);
            MenuSubGroupModel currentSubGroup = null;
            MenuGroupModel currentGroup = null;
            for (UserRoleMenu userRoleMenu : listUserRoleMenus) {
                boolean subGroupFound = false;
                currentSubGroup = null;
                boolean groupFound = false;
                currentGroup = null;
                for (MenuGroupModel menuGroup : returnValue) {
                    if (!menuGroup.getName().equals(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getName())) continue;
                    groupFound = true;
                    currentGroup = menuGroup;
                }
                if (!groupFound) {
                    currentGroup = new MenuGroupModel();
                    currentGroup.setGMenuSeq(Integer.valueOf(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getGMenuSeq()));
                    currentGroup.setName(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getName());
                    currentGroup.setIconName(userRoleMenu.getMenu().getMenuSubGroup().getMenuGroup().getIcon());
                    returnValue.add(currentGroup);
                }
                if (currentGroup == null) continue;
                for (MenuSubGroupModel menuSubGroupModel : currentGroup.getSubGroups()) {
                    if (!menuSubGroupModel.getName().equals(userRoleMenu.getMenu().getMenuSubGroup().getName())) continue;
                    subGroupFound = true;
                    currentSubGroup = menuSubGroupModel;
                    break;
                }
                if (!subGroupFound) {
                    currentSubGroup = new MenuSubGroupModel();
                    currentGroup.getSubGroups().add(currentSubGroup);
                    currentSubGroup.setSGMenuSeq(Integer.valueOf(userRoleMenu.getMenu().getMenuSubGroup().getSGMenuSeq()));
                    currentSubGroup.setName(userRoleMenu.getMenu().getMenuSubGroup().getName());
                    currentSubGroup.setIconName(userRoleMenu.getMenu().getMenuSubGroup().getIcon());
                }
                if (currentSubGroup == null) continue;
                MenuModel menu = new MenuModel();
                menu.setSMenuSeq(Integer.valueOf(userRoleMenu.getMenu().getSMenuSeq()));
                menu.setMenuName(userRoleMenu.getMenu().getMenuName());
                menu.setIconName(userRoleMenu.getMenu().getIcon());
                menu.setMenuId(userRoleMenu.getMenu().getMenuId());
                menu.setUrlPath(userRoleMenu.getMenu().getUrlPath());
                menu.setMenuDetail(userRoleMenu.getMenu().getDescription());
                currentSubGroup.getMenus().add(menu);
                Collections.sort(currentSubGroup.getMenus());
            }
        }
        Collections.sort(returnValue);
        returnData.setStatus(0);
        returnData.setMessage("List of Data");
        logger.info(returnData.getMessage());
        return returnValue;
    }

    public List<String> rolesOfParticularUser(String username) {
        ArrayList<String> returnValue = new ArrayList<String>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRoleTraverse : userRole) {
                returnValue.add(userRoleTraverse.getRole().getShortCode());
            }
        }
        return returnValue;
    }
}

