/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.fileUpload.controller;

import com.coraltele.telemetry.component.service.ChatServiceV2;
import com.coraltele.telemetry.db.telemetry.main.entity.FileUpload;
import com.coraltele.telemetry.db.telemetry.main.repository.FileUploadRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.UserGroupRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.ChatModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.main.eventNotification.model.EventNotifyModel;
import com.coraltele.telemetry.service.main.fileUpload.model.FileStatusModel;
import com.coraltele.telemetry.service.main.fileUpload.model.FileUploadModel;
import com.coraltele.telemetry.service.main.fileUpload.service.FileUploadService;
import com.coraltele.telemetry.service.pbx.ExtensionService;
import com.coraltele.telemetry.service.user.service.UserService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/api/v2/fileUpload"})
public class FileUploadMasterController {
    private static final Logger logger = LogManager.getLogger(FileUploadMasterController.class);
    @Autowired
    FileUploadService fileUploadService;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    UserService userService;
    @Autowired
    UserRepository userRepository;
    @Autowired
    ExtensionService extensionService;
    @Autowired
    ExtensionRepository extensionRepository;
    @Autowired
    FileUploadRepository fileUploadRepository;
    @Autowired
    private ChatServiceV2 chatService;
    private final String BASE_UPLOAD_DIR = "/home/coralswitch/clips/";

    private void sendNotificationToGroupUsers(String assignedUser, MultipartFile file, Principal principal, String fileType) {
        if (StringUtils.hasLength((String)assignedUser)) {
            logger.info("Sending notification to assigned user: {}", (Object)assignedUser);
            this.sendTaskEvents(assignedUser, file, principal, fileType);
        }
    }

    public EventNotifyModel sendTaskEvents(String assignedUser, MultipartFile file, Principal principal, String fileType) {
        EventNotifyModel eventData = new EventNotifyModel();
        eventData.setEventEpoch(Long.valueOf(System.currentTimeMillis() / 1000L));
        eventData.setReadByUser(Boolean.valueOf(false));
        eventData.setEventData((Object)(fileType + "Uploaded for " + assignedUser));
        if (fileType.equalsIgnoreCase("audio")) {
            eventData.setEventId(Constants.EventStatus.MESSAGE_VOICE_UPDATE_EVENT);
        } else if (fileType.equalsIgnoreCase("video")) {
            eventData.setEventId(Constants.EventStatus.MESSAGE_VIDEO_UPDATE_EVENT);
        } else {
            eventData.setEventId(Constants.EventStatus.MESSAGE_IMAGE_UPDATE_EVENT);
        }
        eventData.setEventSeverity(Integer.valueOf(2));
        eventData.setEventUUID(UUID.randomUUID().toString());
        eventData.setEventMessage("File Uploaded");
        eventData.setEventDestination(assignedUser);
        eventData.setEventSource(principal.getName());
        return eventData;
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllFileUploads(@RequestBody SearchRequest searchRequest, Principal principal) {
        RequestResponse returnValue = this.fileUploadService.getAllFileUploads(searchRequest, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    @Transactional(transactionManager="telemetryTransactionManager")
    public ResponseEntity<RequestResponse> createTemp(@RequestParam(value="file") MultipartFile file, @RequestParam(value="fileDescription", required=false) String fileDescription, @RequestParam(value="groupId", required=false) String groupId, @RequestParam(value="userId", required=false) String userId, @RequestParam(value="groupUpload", required=true) boolean groupUpload, Principal principal) {
        FileUploadModel model;
        RequestResponse requestResponse = new RequestResponse();
        String[] groupList = groupId.replace("[", "").replace("]", "").replace("\"", "").split(",");
        String[] userList = userId.replace("[", "").replace("]", "").replace("\"", "").split(",");
        if (file == null || file.getOriginalFilename() == null) {
            requestResponse.setMessage("File is missing or invalid.");
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        if (groupUpload) {
            if (groupList.length == 0 || groupList.length == 1 && groupList[0].trim().isEmpty()) {
                requestResponse.setMessage("Group list cannot be empty when uploadFile is true.");
                requestResponse.setIssue(Constants.NodeStatus.ERROR);
                return ResponseEntity.badRequest().body((Object)requestResponse);
            }
        } else if (userList.length == 0 || userList.length == 1 && userList[0].trim().isEmpty()) {
            requestResponse.setMessage("User list is required when uploadFile is false.");
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        String fileName = file.getOriginalFilename();
        String fileExtension = this.fileUploadService.getFileExtension(fileName);
        String baseFileName = fileName.substring(0, fileName.lastIndexOf(46));
        String fileType = this.fileUploadService.determineFileType(fileExtension);
        Path userDir = Paths.get("/home/coralswitch/clips/", fileType);
        try {
            Files.createDirectories(userDir, new FileAttribute[0]);
            Path path = userDir.resolve(fileName);
            int counter = 1;
            while (Files.exists(path, new LinkOption[0])) {
                String newFileName = baseFileName + "_" + counter + fileExtension;
                path = userDir.resolve(newFileName);
                ++counter;
            }
            Files.write(path, file.getBytes(), new OpenOption[0]);
            requestResponse.setMessage("Uploaded successfully");
            requestResponse.setMessageDetail(path.toString());
            requestResponse.setIssue(Constants.NodeStatus.OK);
        }
        catch (FileAlreadyExistsException e) {
            requestResponse.setMessage("File with the same name already exists.");
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        catch (SecurityException e) {
            requestResponse.setMessage("Permission denied to write file.");
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        catch (IOException e) {
            logger.error("Failed to save file due to an I/O error: {}", (Object)e.getMessage(), (Object)e);
            requestResponse.setMessage("Failed to save file due to an I/O error. Please check directory permissions and available space.");
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        catch (Exception e) {
            requestResponse.setMessage("Unexpected error occurred while saving the file.");
            requestResponse.setIssue(Constants.NodeStatus.ERROR);
            return ResponseEntity.badRequest().body((Object)requestResponse);
        }
        if (groupUpload) {
            model = new FileUploadModel();
            model.setFilePath(requestResponse.getMessageDetail());
            model.setFileType(fileType);
            model.setFileDescription(fileDescription);
            for (String groupName : groupList) {
                model.setGroupId(groupName);
                FileUpload temp = new FileUpload();
                temp.setCreatedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
                temp.setCreatedBy(principal.getName());
                temp.setFileDescription(model.getFileDescription());
                temp.setFilePath(model.getFilePath());
                temp.setFileType(model.getFileType());
                temp.setGroupUpload(Boolean.valueOf(true));
                temp.setGroupId(model.getGroupId());
                temp.setFileName(fileName);
                FileUpload fileSaved = (FileUpload)this.fileUploadRepository.save((Object)temp);
                try {
                    Optional user;
                    List list = this.extensionRepository.findByDepartment(groupName);
                    String groupExtensionNumber = "";
                    for (Extension row : list) {
                        List user2;
                        if (StringUtils.hasLength((String)row.getExtensionType()) && row.getExtensionType().equals("ec")) {
                            groupExtensionNumber = row.getExtension();
                        }
                        if ((user2 = this.userRepository.findByContactNo(row.getExtension())).isEmpty()) continue;
                        this.sendNotificationToGroupUsers(((User)user2.get(0)).getUsername(), file, principal, fileType);
                    }
                    if (!StringUtils.hasLength((String)groupExtensionNumber) || !(user = this.userRepository.findByUsername(principal.getName())).isPresent() || !StringUtils.hasLength((String)((User)user.get()).getContactNo())) continue;
                    ChatModel.SendMessageRequest chatReq = new ChatModel.SendMessageRequest();
                    chatReq.setKind("G");
                    chatReq.setContent(model.getFilePath());
                    chatReq.setMessageType(fileType);
                    chatReq.setSender(((User)user.get()).getContactNo());
                    chatReq.setTarget(groupExtensionNumber);
                    chatReq.setReferenceId(Long.valueOf(fileSaved.getId().longValue()));
                    chatReq.setReferenceUUID("");
                    this.chatService.sendMessage(chatReq);
                }
                catch (Exception e) {
                    logger.error("Error while send events for file-upload");
                }
            }
        } else {
            model = new FileUploadModel();
            model.setFilePath(requestResponse.getMessageDetail());
            model.setFileType(fileType);
            model.setFileDescription(fileDescription);
            for (String username : userList) {
                FileUpload temp = new FileUpload();
                temp.setCreatedOn(Long.valueOf(System.currentTimeMillis() / 1000L));
                temp.setCreatedBy(principal.getName());
                temp.setFileDescription(model.getFileDescription());
                temp.setFilePath(model.getFilePath());
                temp.setFileType(model.getFileType());
                temp.setGroupUpload(Boolean.valueOf(false));
                temp.setUserId(username);
                temp.setFileName(fileName);
                FileUpload fileSaved = (FileUpload)this.fileUploadRepository.save((Object)temp);
                try {
                    this.sendNotificationToGroupUsers(username, file, principal, fileType);
                }
                catch (Exception e) {
                    logger.error("Error while send events for file-upload");
                }
                List extList = this.extensionRepository.findByDesignation(username);
                for (Extension ext : extList) {
                    Optional user;
                    if (!StringUtils.hasLength((String)ext.getExtension()) || !(user = this.userRepository.findByUsername(principal.getName())).isPresent() || !StringUtils.hasLength((String)((User)user.get()).getContactNo())) continue;
                    ChatModel.SendMessageRequest chatReq = new ChatModel.SendMessageRequest();
                    chatReq.setKind("D");
                    chatReq.setContent(model.getFilePath());
                    chatReq.setMessageType(fileType);
                    chatReq.setSender(((User)user.get()).getContactNo());
                    chatReq.setTarget(ext.getExtension());
                    chatReq.setReferenceId(Long.valueOf(fileSaved.getId().longValue()));
                    chatReq.setReferenceUUID("");
                    this.chatService.sendMessage(chatReq);
                }
            }
        }
        requestResponse.setMessage("File uploaded");
        requestResponse.setMessageDetail("File uploaded and data saved successfully");
        requestResponse.setIssue(Constants.NodeStatus.OK);
        return ResponseEntity.ok((Object)requestResponse);
    }

    @GetMapping(value={"/play/{id}"})
    public ResponseEntity<StreamingResponseBody> playFile(@PathVariable(value="id") Integer id) {
        try {
            String path = this.fileUploadService.getFilePath(id);
            if (!StringUtils.hasLength((String)path)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            Path baseDir = Paths.get(path, new String[0]);
            if (!Files.exists(baseDir, new LinkOption[0]) || !Files.isReadable(baseDir)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            InputStream inputStream = Files.newInputStream(baseDir, new OpenOption[0]);
            String contentType = Files.probeContentType(baseDir);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            String filename = baseDir.getFileName().toString();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"inline; filename=\"" + filename + "\""})).body(outputStream -> {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    outputStream.flush();
                }
            });
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/download/{id}"})
    public ResponseEntity<StreamingResponseBody> downloadFile(@PathVariable(value="id") Integer id) {
        try {
            String filePath = this.fileUploadService.getFilePath(id);
            if ("Id doesn't exist".equals(filePath)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            Path path = Paths.get(filePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || !Files.isReadable(path)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = "application/octet-stream";
            String fileName = path.getFileName().toString();
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            StreamingResponseBody stream = outputStream -> {
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                    outputStream.flush();
                }
                inputStream.close();
            };
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + fileName + "\""})).body((Object)stream);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll(Principal principal) {
        RequestResponse returnValue = this.fileUploadService.getAll(principal);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/play1/{id}"})
    public ResponseEntity<StreamingResponseBody> playFile1(@PathVariable(value="id") Integer id) {
        try {
            String path = this.fileUploadService.getFilePath(id);
            if (!StringUtils.hasLength((String)path)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            Path baseDir = Paths.get(path, new String[0]);
            if (!Files.exists(baseDir, new LinkOption[0]) || !Files.isReadable(baseDir)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = Files.probeContentType(baseDir);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            String filename = baseDir.getFileName().toString();
            StreamingResponseBody stream = outputStream -> {
                try (InputStream inputStream = Files.newInputStream(baseDir, new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                        outputStream.flush();
                    }
                }
            };
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"inline; filename=\"" + filename + "\""})).body((Object)stream);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @GetMapping(value={"/download1/{id}"})
    public ResponseEntity<StreamingResponseBody> downloadFile1(@PathVariable(value="id") Integer id) {
        try {
            String filePath = this.fileUploadService.getFilePath(id);
            if ("Id doesn't exist".equals(filePath)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            Path path = Paths.get(filePath, new String[0]);
            if (!Files.exists(path, new LinkOption[0]) || !Files.isReadable(path)) {
                return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
            }
            String contentType = Files.probeContentType(path);
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            String fileName = path.getFileName().toString();
            StreamingResponseBody stream = outputStream -> {
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, bytesRead);
                        outputStream.flush();
                    }
                }
            };
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.parseMediaType((String)contentType)).header("Content-Disposition", new String[]{"attachment; filename=\"" + fileName + "\""})).body((Object)stream);
        }
        catch (IOException e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PostMapping(value={"/updateStatus"})
    public ResponseEntity<RequestResponse> updateStatus(@RequestBody FileStatusModel data, Principal principal) {
        RequestResponse returnValue = this.fileUploadService.createFileHistory(data, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

