/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.category.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Category;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.specification.CategorySpecification;
import com.coraltele.telemetry.db.telemetry.main.entity.CategorySensor;
import com.coraltele.telemetry.db.telemetry.main.repository.CategorySensorRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.coralnms.category.model.CategoryActionModel;
import com.coraltele.telemetry.service.coralnms.category.model.CategoryFileListModel;
import com.coraltele.telemetry.service.coralnms.category.model.CategoryModel;
import com.coraltele.telemetry.service.main.catgeorySensor.model.CategorySensorModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    private static final Logger logger = LogManager.getLogger(CategoryService.class);
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    CategorySensorRepository categorySensorRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<CategoryModel> getCategory() {
        ArrayList<CategoryModel> returnValue = new ArrayList<CategoryModel>();
        List categories = this.categoryRepository.findAll();
        for (Category category : categories) {
            CategoryModel row = new CategoryModel();
            row.setCode(category.getCode());
            row.setDescription(category.getDescription());
            row.setHasSelfDashboard(Boolean.valueOf(Boolean.TRUE.equals(category.getHasSelfDashboard())));
            row.setHasManagementInterface(Boolean.valueOf(Boolean.TRUE.equals(category.getHasManagementInterface())));
            row.setManagementURL(category.getManagementURL());
            row.setWidth(category.getWidth());
            row.setHeight(category.getHeight());
            row.setImageName(category.getImageName());
            row.setSvgIcon(category.getSvgIcon());
            if (category.getCode().equalsIgnoreCase("imsi")) {
                row.getActions().add(new CategoryActionModel("Factory Reset", "${{baseURL}}api/v2/device/action/reset/{id}"));
                row.getActions().add(new CategoryActionModel("Clear Data", "${{baseURL}}api/v2/device/action/clearData/{id}"));
            }
            List categorySensors = this.categorySensorRepository.findByCategoryCode(row.getCode());
            for (CategorySensor categorySensor : categorySensors) {
                CategorySensorModel sensor = new CategorySensorModel();
                sensor.setId(categorySensor.getId());
                sensor.setCategoryCode(category.getCode());
                sensor.setSensorType(categorySensor.getSensorType());
                sensor.setConfiguration(categorySensor.getConfiguration());
                row.getSensors().add(sensor);
            }
            returnValue.add(row);
        }
        return returnValue;
    }

    public RequestResponse createData(CategoryModel data) {
        logger.debug("create new Category : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Category category = new Category();
            category.setCode(data.getCode());
            category.setDescription(data.getDescription());
            category.setManagementURL(data.getManagementURL());
            if (data.getManagementURL() == null || data.getManagementURL().equals("")) {
                category.setHasManagementInterface(Boolean.valueOf(false));
            } else {
                category.setHasManagementInterface(Boolean.valueOf(true));
            }
            category.setHasSelfDashboard(data.getHasSelfDashboard());
            category.setHeight(data.getHeight());
            category.setImageName(data.getImageName());
            category.setWidth(data.getWidth());
            this.categoryRepository.save((Object)category);
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("category created successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setIssue(Constants.NodeStatus.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to create category");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse updateById(CategoryModel data) {
        logger.debug("Update category {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional category = this.categoryRepository.findById(data.getId());
        if (!category.isPresent()) {
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("category not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCode() != null) {
            ((Category)category.get()).setCode(data.getCode());
        }
        if (data.getDescription() != null) {
            ((Category)category.get()).setDescription(data.getDescription());
        }
        if (data.getHeight() != null) {
            ((Category)category.get()).setHeight(data.getHeight());
        }
        if (data.getImageName() != null) {
            ((Category)category.get()).setImageName(data.getImageName());
        }
        if (data.getManagementURL() != null) {
            ((Category)category.get()).setManagementURL(data.getManagementURL());
        }
        if (data.getHasManagementInterface() != null) {
            ((Category)category.get()).setHasManagementInterface(data.getHasManagementInterface());
        }
        if (data.getHasSelfDashboard() != null) {
            ((Category)category.get()).setHasSelfDashboard(data.getHasSelfDashboard());
        }
        if (data.getWidth() != null) {
            ((Category)category.get()).setWidth(data.getWidth());
        }
        this.categoryRepository.save(category.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("category Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteCategoryById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getId()) {
            Optional category = this.categoryRepository.findById(Integer.valueOf(ids));
            if (category.isPresent()) {
                addValue.add(category.get());
                this.categoryRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(0);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("records has been deleted");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllCategoryByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = CategorySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.categoryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.categoryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateImageName(CategoryModel data) {
        logger.debug("Update category {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional category = this.categoryRepository.findById(data.getId());
        if (!category.isPresent()) {
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("category not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getImageName() != null) {
            ((Category)category.get()).setImageName(data.getImageName());
        }
        this.categoryRepository.save(category.get());
        returnValue.setStatus(0);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("imageName Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse storeDataIntoFile() throws IOException {
        RequestResponse returnValue = new RequestResponse();
        List list = this.categoryRepository.findAll();
        ArrayList<CategoryFileListModel> addValue = new ArrayList<CategoryFileListModel>();
        ObjectMapper objectMapper = new ObjectMapper();
        String filePath = "/etc/coraltele/masters/category.json";
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
                logger.info("New File Created Successfully");
            } else {
                logger.info("File Already Exists");
            }
            FileWriter fileWriter = new FileWriter(filePath);
            for (Category category : list) {
                if (!Boolean.TRUE.equals(category.getExport())) continue;
                CategoryFileListModel data = new CategoryFileListModel();
                data.setId(category.getId());
                data.setCode(category.getCode());
                data.setDescription(category.getDescription());
                data.setHasManagementInterface(category.getHasManagementInterface());
                data.setHasSelfDashboard(category.getHasSelfDashboard());
                data.setHeight(category.getHeight());
                data.setImageName(category.getImageName());
                data.setManagementURL(category.getManagementURL());
                data.setWidth(category.getWidth());
                data.setExport(category.getExport());
                addValue.add(data);
            }
            String dataReceived = objectMapper.writeValueAsString(addValue);
            fileWriter.write(dataReceived);
            fileWriter.close();
            returnValue.setStatus(0);
            returnValue.setMessage("Stored ");
            returnValue.setMessageDetail("Data Stored Successfully");
            logger.info("Data Have Been Stored Successfully ");
        }
        catch (FileNotFoundException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Error while Storing Data Into File. ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs::", (Throwable)e);
        }
        return returnValue;
    }

    private boolean doesCategoryExist(Integer id) {
        return this.categoryRepository.existsById((Object)id);
    }

    public RequestResponse retrieveDataFromFileAndStoreInTable() throws IOException {
        RequestResponse returnValue = new RequestResponse();
        String filePath = "/etc/coraltele/masters/category.json";
        try {
            CategoryFileListModel[] data;
            File file = new File(filePath);
            if (!file.exists()) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("File Not Found");
                returnValue.setMessageDetail("File Not Present at the Server");
                logger.error("File not found");
                return returnValue;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            for (CategoryFileListModel categoryFileListModel : data = (CategoryFileListModel[])objectMapper.readValue(file, CategoryFileListModel[].class)) {
                Integer id = categoryFileListModel.getId();
                Category category = new Category();
                category.setCode(categoryFileListModel.getCode());
                category.setDescription(categoryFileListModel.getDescription());
                category.setHasManagementInterface(categoryFileListModel.getHasManagementInterface());
                category.setHasSelfDashboard(categoryFileListModel.getHasSelfDashboard());
                category.setHeight(categoryFileListModel.getHeight());
                category.setImageName(categoryFileListModel.getImageName());
                category.setManagementURL(categoryFileListModel.getManagementURL());
                category.setWidth(categoryFileListModel.getWidth());
                if (categoryFileListModel.getExport() != null && !categoryFileListModel.getExport().equals("")) {
                    category.setExport(categoryFileListModel.getExport());
                } else {
                    category.setExport(Boolean.valueOf(true));
                }
                if (this.doesCategoryExist(id)) {
                    String updateSql = "UPDATE coralnms.m_category SET code=?, description=?, has_management_interface=?, has_self_dashboard=?, height=?, image_name=?, managementurl=?, width=?, export=? WHERE id=?";
                    this.jdbcTemplate.update(updateSql, new Object[]{category.getCode(), category.getDescription(), category.getHasManagementInterface(), category.getHasSelfDashboard(), category.getHeight(), category.getImageName(), category.getManagementURL(), category.getWidth(), category.getExport(), id});
                    continue;
                }
                String insertSql = "INSERT INTO coralnms.m_category (code, description, has_management_interface, has_self_dashboard, height, image_name, managementurl, width, export, id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                this.jdbcTemplate.update(insertSql, new Object[]{category.getCode(), category.getDescription(), category.getHasManagementInterface(), category.getHasSelfDashboard(), category.getHeight(), category.getImageName(), category.getManagementURL(), category.getWidth(), category.getExport(), id});
            }
            returnValue.setStatus(0);
            returnValue.setMessage("Data Retrieved and Stored");
            returnValue.setMessageDetail("Data Retrieved from File and Stored into Table Successfully");
            logger.info("Data Retrieved and Stored Successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present at the Server");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Error while Retrieving Data from File");
            returnValue.setMessageDetail("Unable to Retrieve Data from File");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        return returnValue;
    }
}

