/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ICMPHelper {
    private static final Logger logger = LogManager.getLogger(ICMPHelper.class);

    private ICMPHelper() {
    }

    public static boolean isIPAddressReachable(String ipAddress) {
        try {
            return InetAddress.getByName(ipAddress).isReachable(Constants.DISCOVERY_TIMEOUT) || ICMPHelper.pingCheck((String)ipAddress);
        }
        catch (IOException e) {
            logger.error("Unable to reach ip address {} during InetAddress check  ", (Object)ipAddress, (Object)e);
            return false;
        }
    }

    public static boolean pingCheck(String ipAddress) {
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder("ping", "-c", Constants.PING_COUNT_FOR_NOT_REACHABLE.toString(), "-W", "1", ipAddress);
            Process process = processBuilder.start();
            int sentPackets = 0;
            int receivedPackets = 0;
            process.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if (!line.contains("packets transmitted")) continue;
                for (String part : parts = line.split(",")) {
                    if (part.contains("transmitted")) {
                        sentPackets = Integer.parseInt(part.trim().split(" ")[0]);
                        continue;
                    }
                    if (!part.contains("received")) continue;
                    receivedPackets = Integer.parseInt(part.trim().split(" ")[0]);
                }
            }
            return sentPackets > 0 && receivedPackets > 0;
        }
        catch (IOException | InterruptedException e) {
            logger.error("Unable to reach ip address {} during ping check  ", (Object)ipAddress, (Object)e);
            return false;
        }
    }
}

