/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import com.coraltele.telemetry.condition.EnableRedisPubSub;
import com.coraltele.telemetry.db.telemetry.main.repository.ExtensionStatusRepository;
import com.coraltele.telemetry.service.messaging.service.ChannelUpdateMessageSubscriber;
import com.coraltele.telemetry.service.messaging.service.CoreEventPublisher;
import com.coraltele.telemetry.service.messaging.service.CoreEventSubscriber;
import com.coraltele.telemetry.service.messaging.service.MessagePublisher;
import com.coraltele.telemetry.service.messaging.service.MultiChannelSubscriber;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.GenericToStringSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@Conditional(value={EnableRedisPubSub.class})
public class RedisConfig {
    @Autowired
    ExtensionStatusRepository extensionStatusRepository;

    @Bean
    JedisConnectionFactory jedisConnectionFactory() {
        return new JedisConnectionFactory();
    }

    @Bean
    public RedisTemplate<String, Object> redisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory());
        template.setValueSerializer((RedisSerializer)new GenericToStringSerializer(Object.class));
        return template;
    }

    @Bean
    MessageListenerAdapter coreMessageListener() {
        return new MessageListenerAdapter((Object)new CoreEventSubscriber());
    }

    @Bean
    MessageListenerAdapter multiChannelMessageListener() {
        return new MessageListenerAdapter((Object)new MultiChannelSubscriber());
    }

    @Bean
    RedisMessageListenerContainer redisContainer() {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory((RedisConnectionFactory)this.jedisConnectionFactory());
        container.addMessageListener((MessageListener)this.coreMessageListener(), (Topic)this.enbChannel());
        container.addMessageListener((MessageListener)this.channelUpdateMessageListener(), (Topic)this.extensionUpdate());
        container.addMessageListener((MessageListener)this.multiChannelMessageListener(), (Topic)this.imsv2RegisterChannel());
        container.addMessageListener((MessageListener)this.multiChannelMessageListener(), (Topic)this.imsv2DeRegisterChannel());
        return container;
    }

    @Bean
    MessageListenerAdapter channelUpdateMessageListener() {
        ChannelUpdateMessageSubscriber channelUpdateMessageSubscriber = new ChannelUpdateMessageSubscriber();
        channelUpdateMessageSubscriber.setExtensionStatusRepository(this.extensionStatusRepository);
        return new MessageListenerAdapter((Object)channelUpdateMessageSubscriber);
    }

    @Bean
    MessagePublisher coreMessagePublisher() {
        return new CoreEventPublisher(this.redisTemplate(), this.enbChannel());
    }

    @Bean
    ChannelTopic enbChannel() {
        return new ChannelTopic("enb-channel");
    }

    @Bean
    ChannelTopic extensionUpdate() {
        return new ChannelTopic("extension-update");
    }

    @Bean
    ChannelTopic imsv2RegisterChannel() {
        return new ChannelTopic("imsv2register");
    }

    @Bean
    ChannelTopic imsv2DeRegisterChannel() {
        return new ChannelTopic("imsv2deregister");
    }
}

