/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.timeseries.service;

import com.coraltele.telemetry.background.MetricsCollectionProcess;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetList;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetListRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesChart;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesDataModel;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesDataSet;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesLabelModel;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesResponseModel;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesValueModel;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class MetricsService {
    private static final Logger logger = LogManager.getLogger(MetricsService.class);
    @Autowired
    WidgetListRepository widgetListRepository;
    @Autowired
    MetricsCollectionProcess metricsCollectionProcess;

    public List<TimeSeriesDataModel> getData(String widgetId) {
        ArrayList<TimeSeriesDataModel> returnValue = new ArrayList<TimeSeriesDataModel>();
        RestTemplate restTemplate = new RestTemplate();
        Optional widgetConfiguration = this.widgetListRepository.findByCode(widgetId);
        if (widgetConfiguration.isPresent()) {
            Long endTime = Instant.now().toEpochMilli() / 1000L;
            Long startTime = endTime - (long)((widgetConfiguration.get() == null ? 10 : ((WidgetList)widgetConfiguration.get()).getMetricsDataDuration()) * 60);
            String instanceName = ((WidgetList)widgetConfiguration.get()).getMetricsInstanceName();
            String instanceFilter = instanceName != null && !instanceName.isEmpty() ? instanceName + ":9100" : "";
            String metricsName = ((WidgetList)widgetConfiguration.get()).getMetricsName();
            String labelFilter = "";
            if (((WidgetList)widgetConfiguration.get()).getMetricsName().contains("/")) {
                metricsName = ((WidgetList)widgetConfiguration.get()).getMetricsName().split("/")[0];
                labelFilter = ((WidgetList)widgetConfiguration.get()).getMetricsName().split("/")[1];
            }
            String url = String.format("%s/api/v1/query_range?query=%s%s&start=%s.000&end=%s.000&step=14", Constants.TIME_SERIES_DB_URL, metricsName, "", startTime.toString(), endTime.toString());
            try {
                TimeSeriesResponseModel response = (TimeSeriesResponseModel)restTemplate.getForObject(url, TimeSeriesResponseModel.class, new Object[0]);
                String attributeName = ((WidgetList)widgetConfiguration.get()).getName();
                TimeSeriesDataModel data = null;
                if (response != null && response.getStatus().equals("success")) {
                    for (TimeSeriesValueModel valueModel : response.getData().getResult()) {
                        if (!instanceFilter.isEmpty() && !valueModel.getMetric().getInstance().equals(instanceFilter) || !labelFilter.isEmpty() && !valueModel.getMetric().getMetricData().equals(labelFilter)) continue;
                        for (String[] value : valueModel.getValues()) {
                            Long epoch = Long.parseLong(value[0]);
                            String epochValue = value[1];
                            if (((WidgetList)widgetConfiguration.get()).getMetricsDataDivision() != null) {
                                epochValue = ((WidgetList)widgetConfiguration.get()).getMetricsInvertValue() != null && ((WidgetList)widgetConfiguration.get()).getMetricsInvertValue() != false ? Double.toString(((WidgetList)widgetConfiguration.get()).getMaxValue() - Double.parseDouble(value[1]) / (double)((WidgetList)widgetConfiguration.get()).getMetricsDataDivision().intValue()) : Long.toString(Long.parseLong(value[1]) / (long)((WidgetList)widgetConfiguration.get()).getMetricsDataDivision().intValue());
                            }
                            data = new TimeSeriesDataModel();
                            data.setAttributeName(attributeName);
                            data.setAttributeValue(epochValue);
                            data.setEventEpoch(epoch);
                            data.setReceivedEpoch(epoch);
                            if (((WidgetList)widgetConfiguration.get()).getWidgetType().getCode().startsWith("speed")) continue;
                            returnValue.add(data);
                        }
                    }
                    if (((WidgetList)widgetConfiguration.get()).getWidgetType().getCode().startsWith("speed")) {
                        returnValue.add(data);
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to fetch data for widget {}", (Object)widgetId, (Object)e);
            }
        }
        return returnValue;
    }

    public RequestResponse updateSensorData(Principal principal, String sensorId, TimeSeriesLabelModel[] data) {
        RequestResponse returnValue = new RequestResponse();
        Optional widgetConfiguration = this.widgetListRepository.findBySensorId(sensorId);
        if (widgetConfiguration.isPresent()) {
            if (((WidgetList)widgetConfiguration.get()).getCreatedBy().equals(principal.getName())) {
                this.metricsCollectionProcess.submitData(((WidgetList)widgetConfiguration.get()).getBaseCode(), ((WidgetList)widgetConfiguration.get()).getWidgetName(), data);
            } else {
                returnValue.setStatus(-1);
                returnValue.setMessage("Widget not associated with user");
            }
        } else {
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to locate widget");
        }
        return returnValue;
    }

    public TimeSeriesChart getData2(Principal principal, String sensorId) {
        TimeSeriesChart returnValue = new TimeSeriesChart();
        Optional widgetConfiguration = this.widgetListRepository.findByCode(sensorId);
        if (widgetConfiguration.isPresent()) {
            Long endTime = Instant.now().toEpochMilli() / 1000L;
            Long startTime = endTime - (long)((((WidgetList)widgetConfiguration.get()).getMetricsDataDuration() == null ? 10 : ((WidgetList)widgetConfiguration.get()).getMetricsDataDuration()) * 60);
            TreeMap timeIndex = new TreeMap(Comparator.reverseOrder());
            RestTemplate restTemplate = new RestTemplate();
            String metricsName = ((WidgetList)widgetConfiguration.get()).getBaseCode().replace("-", "_");
            String url = String.format("%s/api/v1/query_range?query=%s%s&start=%s.000&end=%s.000&step=14", Constants.TIME_SERIES_DB_URL, metricsName, "", startTime.toString(), endTime.toString());
            logger.info("Fetching data for metrics {} {}", (Object)metricsName, (Object)url);
            try {
                TimeSeriesResponseModel response = (TimeSeriesResponseModel)restTemplate.getForObject(url, TimeSeriesResponseModel.class, new Object[0]);
                if (response != null && response.getStatus().equals("success")) {
                    Double[] doubleArray;
                    Object object;
                    Integer maxValues = 0;
                    Integer currentIndex = -1;
                    Integer dataSetCount = response.getData().getResult().size();
                    returnValue.setSeries(new TimeSeriesDataSet[dataSetCount.intValue()]);
                    for (TimeSeriesValueModel valueModel : response.getData().getResult()) {
                        if (valueModel.getValues().size() <= maxValues) continue;
                        maxValues = valueModel.getValues().size();
                    }
                    for (TimeSeriesValueModel valueModel : response.getData().getResult()) {
                        object = currentIndex;
                        currentIndex = Integer.valueOf(currentIndex + 1);
                        doubleArray = currentIndex;
                        returnValue.getSeries()[currentIndex.intValue()] = new TimeSeriesDataSet();
                        returnValue.getSeries()[currentIndex].setValues(new Double[maxValues.intValue()]);
                        returnValue.getSeries()[currentIndex].setSeriesName(valueModel.getMetric().getMetricData());
                    }
                    currentIndex = -1;
                    for (TimeSeriesValueModel valueModel : response.getData().getResult()) {
                        object = currentIndex;
                        currentIndex = currentIndex + 1;
                        doubleArray = currentIndex;
                        for (String[] value : valueModel.getValues()) {
                            Long epoch = Long.parseLong(value[0]);
                            Double[] dataItem = null;
                            if (timeIndex.containsKey(epoch)) {
                                dataItem = (Double[])timeIndex.get(epoch);
                            } else {
                                dataItem = new Double[dataSetCount.intValue()];
                                timeIndex.put(epoch, dataItem);
                            }
                            dataItem[currentIndex.intValue()] = Double.parseDouble(value[1]);
                        }
                    }
                    Integer valueIndex = -1;
                    for (Map.Entry dataItem : timeIndex.entrySet()) {
                        doubleArray = valueIndex;
                        Integer n = valueIndex = Integer.valueOf(valueIndex + 1);
                        returnValue.getLabel().add(dataItem.getKey());
                        currentIndex = -1;
                        for (Double timeData : (Double[])dataItem.getValue()) {
                            Integer n2 = currentIndex;
                            Integer n3 = currentIndex = Integer.valueOf(currentIndex + 1);
                            returnValue.getSeries()[currentIndex.intValue()].getValues()[valueIndex.intValue()] = timeData;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to fetch data for widget {}", (Object)sensorId, (Object)e);
            }
        }
        return returnValue;
    }
}

