/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.polygon.routeCoordinate.service;

import com.coraltele.telemetry.db.telemetry.main.entity.Route;
import com.coraltele.telemetry.db.telemetry.main.entity.RouteCoordinate;
import com.coraltele.telemetry.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.telemetry.db.telemetry.main.entity.UserRouteHistory;
import com.coraltele.telemetry.db.telemetry.main.entity.UserZone;
import com.coraltele.telemetry.db.telemetry.main.repository.RouteCoordinateRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UserCoordinateRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UserRouteHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.telemetry.db.users.main.entity.ShiftTime;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.entity.UserShift;
import com.coraltele.telemetry.db.users.main.repository.ShiftTimeRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.repository.UserShiftRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.service.coralnms.geo_pin.model.DeviceInformationModel;
import com.coraltele.telemetry.service.coralnms.geo_pin.service.GeoTaggingService;
import com.coraltele.telemetry.service.main.polygon.area.model.CoordinateModel;
import com.coraltele.telemetry.service.main.polygon.route.model.RouteModel;
import com.coraltele.telemetry.service.main.polygon.route.model.UserShiftModel;
import com.coraltele.telemetry.service.main.polygon.route.service.RouteService;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.AreaRouteDetailModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.CoordinateDataModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.LatLongModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.RouteCoordinateModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.RouteProgressModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.UserDetailHistoryModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.UserPathTraceModel;
import com.coraltele.telemetry.service.main.service.UserCoordinateService;
import com.coraltele.telemetry.service.pbx.ExtensionService;
import com.coraltele.telemetry.service.user.service.UserService;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RouteCoordinateService {
    private static final Logger logger = LogManager.getLogger(RouteCoordinateService.class);
    @Autowired
    private RouteCoordinateRepository repository;
    @Autowired
    private UserService userService;
    @Autowired
    UserRouteHistoryRepository userRouteHistoryRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    GeoTaggingService geoTaggingService;
    @Autowired
    UserZoneRepository areaRepository;
    @Autowired
    UserShiftRepository userShiftRepository;
    @Autowired
    ShiftTimeRepository shiftTimeRepository;
    @Autowired
    RouteService routeService;
    @Autowired
    UserCoordinateService userCoordinateService;
    @Autowired
    ExtensionsRepository extensionsRepository;
    @Autowired
    UserCoordinateRepository userCoordinateRepository;
    @Autowired
    ExtensionService extensionService;
    private String monitoredUser = "";

    public RequestResponse createMultiData(RouteCoordinateModel data, String mode) {
        Long lastEpoch;
        RequestResponse returnValue = new RequestResponse();
        logger.info("Data for update battery and accuracy:{}", (Object)data);
        String username = data.getUserName();
        String extension = this.userService.getContactNumber(username);
        if (!this.userCoordinateService.checkUserExist(username)) {
            this.userCoordinateService.createUser(username);
        }
        if ((lastEpoch = this.userCoordinateService.getLastCoordinateUpdate(username)) == null) {
            lastEpoch = 0L;
        }
        Long currentEpoch = Instant.now().getEpochSecond();
        try {
            if (data.getLocation() != null) {
                try {
                    if (Boolean.TRUE.equals(Constants.BATTERY_RSRP_EXTENSION_UPDATE_IN_SWITCH_DB)) {
                        this.updateExtensionForBattery(extension, data.getBatteryPercentage(), data.getDeviceId(), data.getRsrpData().getSim1(), data.getRsrpData().getSim2(), currentEpoch);
                    }
                    this.updateCoordinateBattery(username, currentEpoch, username, data.getBatteryPercentage(), data.getDeviceId(), data.getRsrpData().getSim1(), data.getRsrpData().getSim2(), extension);
                }
                catch (Exception e) {
                    logger.error("Unable to Update extension or userCoordinate:{}", (Object)e.getMessage());
                }
                List coordinatesToUse = data.getLocation();
                Iterator originalIterator = null;
                if (Constants.MAP_URL.equals("googlemap")) {
                    coordinatesToUse = this.callSnapToRoadsApi(data.getLocation());
                    originalIterator = data.getLocation().iterator();
                }
                for (CoordinateDataModel row : coordinatesToUse) {
                    try {
                        CoordinateDataModel original = Constants.MAP_URL.equals("googlemap") ? (CoordinateDataModel)originalIterator.next() : row;
                        RouteCoordinate record = new RouteCoordinate();
                        record.setCreatedBy(username);
                        record.setCreatedOn(currentEpoch);
                        record.setDeviceId(data.getDeviceId());
                        record.setGpsAccuracy(row.getGpsAccuracy());
                        record.setExtension(extension);
                        record.setDataMode(mode);
                        if (Boolean.FALSE.equals(Constants.DISABLE_IMSI_LOCATION_UPDATE)) {
                            record.setLatitude(row.getLatitude());
                            record.setLongitude(row.getLongitude());
                        }
                        record.setRawLatitude(original.getLatitude());
                        record.setRawLongitude(original.getLongitude());
                        if (row.getLocationId() != null) {
                            record.setLocationId(row.getLocationId());
                        }
                        record.setEpochDate(row.getEpochDate());
                        if (lastEpoch < row.getEpochDate()) {
                            lastEpoch = row.getEpochDate();
                            this.userCoordinateService.updateUserCoordinate(username, row.getLatitude(), row.getLongitude(), row.getEpochDate(), username, extension, data.getBatteryPercentage(), data.getDeviceId(), data.getRsrpData().getSim1(), data.getRsrpData().getSim2());
                        }
                        this.repository.save((Object)record);
                    }
                    catch (Exception e) {
                        logger.error("Failed to save record for coordinates: {}, {}", (Object)row.getLatitude(), (Object)row.getLongitude(), (Object)e);
                    }
                }
            }
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setMessage("Data saved successfully");
            returnValue.setMessageDetail("Coordinates stored successfully");
            logger.info("List of Coordinates Saved: {}", (Object)data.getLocation());
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Unable to store data");
            returnValue.setMessageDetail("An error occurred while processing: " + e.getMessage());
            logger.error("Error saving RouteCoordinate data: {}", (Object)e.getMessage(), (Object)e);
        }
        return returnValue;
    }

    public RequestResponse routeProgress(RouteProgressModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ReturnField field = new ReturnField();
        try {
            if (!data.isAbort() && data.getStatus().equalsIgnoreCase("start")) {
                UserRouteHistory routeData = new UserRouteHistory();
                routeData.setRouteId(data.getRouteId());
                routeData.setShiftId(data.getShiftId());
                routeData.setUserId(data.getUserId());
                routeData.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                routeData.setStartEpoch(data.getStartEpoch());
                routeData.setDescription(data.getDescription());
                routeData.setIsAbort(Boolean.valueOf(false));
                routeData.setCreatedBy(principal.getName());
                routeData.setUuid(data.getUuid());
                this.userRouteHistoryRepository.save((Object)routeData);
                field.setId(routeData.getId().intValue());
                field.setDescription(data.getStatus());
                returnValue.setIssue(Constants.NodeStatus.OK);
                returnValue.setStatus(0);
                returnValue.setMessage("Route Started Successfully");
                returnValue.setData((Object)field);
                logger.info("Route Start Successfully:{}", (Object)data.getStatus());
            } else if (data.getStatus().equalsIgnoreCase("end")) {
                Optional userRouteHistory = this.userRouteHistoryRepository.findById((Object)data.getId());
                if (userRouteHistory.isPresent()) {
                    ((UserRouteHistory)userRouteHistory.get()).setIsAbort(Boolean.valueOf(data.isAbort()));
                    ((UserRouteHistory)userRouteHistory.get()).setEndEpoch(data.getEndEpoch());
                    ((UserRouteHistory)userRouteHistory.get()).setDescription(data.getStatus());
                    this.userRouteHistoryRepository.save(userRouteHistory.get());
                    field.setId(data.getId().intValue());
                    field.setDescription(data.getStatus());
                    returnValue.setIssue(Constants.NodeStatus.OK);
                    returnValue.setStatus(0);
                    returnValue.setMessage("Route End Successfully");
                    returnValue.setData((Object)field);
                    logger.info("Route End Successfully:{}", (Object)data.getStatus());
                }
                logger.info("Unable to end Route");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to change route progress");
        }
        return returnValue;
    }

    public RequestResponse getUserDetails(String username) {
        RequestResponse returnValue = new RequestResponse();
        AreaRouteDetailModel data = new AreaRouteDetailModel();
        try {
            Optional user = this.userRepository.findByUsername(username);
            if (user.isPresent()) {
                Optional areaData;
                data.setUserId(((User)user.get()).getUsername());
                if (this.userCoordinateService.checkUserExist(((User)user.get()).getUsername())) {
                    UserCoordinate userCoordinate = this.userCoordinateService.getUserCoordinate(username);
                    data.setUserLat(userCoordinate.getGeoX());
                    data.setUserLong(userCoordinate.getGeoY());
                } else {
                    this.userCoordinateService.createUser(username);
                    data.setUserLat("0");
                    data.setUserLong("0");
                }
                RouteModel areaInfo = new RouteModel();
                Integer areaId = ((User)user.get()).getAreaId();
                if (areaId != null && (areaData = this.areaRepository.findById((Object)areaId)).isPresent()) {
                    areaInfo.setId(areaId);
                    areaInfo.setName(((UserZone)areaData.get()).getName());
                    areaInfo.setShapeId(((UserZone)areaData.get()).getType());
                    if (((UserZone)areaData.get()).getCoordinate() != null) {
                        ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                        ArrayList<Coordinate> areaCoordinates = new ArrayList<Coordinate>();
                        for (Coordinate coordinate : ((UserZone)areaData.get()).getCoordinate().getCoordinates()) {
                            CoordinateModel coordModel = new CoordinateModel();
                            coordModel.setLongitude(String.valueOf(coordinate.x));
                            coordModel.setLatitude(String.valueOf(coordinate.y));
                            coordinateModels.add(coordModel);
                            areaCoordinates.add(new Coordinate(coordinate.x, coordinate.y));
                        }
                        areaInfo.setCoordinates(coordinateModels);
                    }
                    data.setAreaData(areaInfo);
                }
                ArrayList<UserShiftModel> userShiftData = new ArrayList<UserShiftModel>();
                List list = this.userShiftRepository.findByUserId(username);
                if (!list.isEmpty()) {
                    for (UserShift userShift : list) {
                        UserShiftModel userShiftModel = new UserShiftModel();
                        ShiftTime shiftTime = this.getShiftData(userShift.getShiftId());
                        if (shiftTime != null) {
                            Route routeData;
                            LocalDateTime fromDateTime = DateFormatUtility.epochToLocalDTime((Long)shiftTime.getFromDateTime());
                            LocalDateTime toDateTime = DateFormatUtility.epochToLocalDTime((Long)shiftTime.getToDateTime());
                            userShiftModel.setId(shiftTime.getId());
                            userShiftModel.setShiftName(shiftTime.getName());
                            userShiftModel.setShiftFromDate(fromDateTime.toLocalDate().toString());
                            userShiftModel.setShiftFromDate(toDateTime.toLocalDate().toString());
                            userShiftModel.setFromTime(fromDateTime.toLocalTime().toString());
                            userShiftModel.setToTime(toDateTime.toLocalTime().toString());
                            if (userShift.getRouteId() != null && (routeData = this.routeService.getRouteData(userShift.getRouteId())) != null) {
                                RouteModel routeModel = new RouteModel();
                                routeModel.setId(routeData.getId());
                                routeModel.setName(routeData.getName());
                                routeModel.setShapeId(routeData.getType());
                                if (routeData.getCoordinate() != null) {
                                    ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                                    for (Coordinate coordinate : routeData.getCoordinate().getCoordinates()) {
                                        CoordinateModel coordModel = new CoordinateModel();
                                        coordModel.setLongitude(String.valueOf(coordinate.x));
                                        coordModel.setLatitude(String.valueOf(coordinate.y));
                                        coordinateModels.add(coordModel);
                                    }
                                    routeModel.setCoordinates(coordinateModels);
                                }
                                userShiftModel.setRouteData(routeModel);
                            }
                        }
                        userShiftData.add(userShiftModel);
                    }
                }
                data.setUserShiftData(userShiftData);
            }
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setStatus(0);
            returnValue.setMessage("Area/Route details");
            returnValue.setMessageDetail("Data fetched successfully");
            returnValue.setData((Object)data);
        }
        catch (Exception e) {
            logger.error("Unable to find data:{}", (Object)e.getMessage());
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to find details of user");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }

    public ShiftTime getShiftData(Integer id) {
        Optional data = this.shiftTimeRepository.findById((Object)id);
        if (data.isPresent()) {
            return (ShiftTime)data.get();
        }
        return null;
    }

    public DeviceInformationModel getDeviceData(RouteCoordinateModel data) {
        DeviceInformationModel record = new DeviceInformationModel();
        record.setBatteryPercentage(data.getBatteryPercentage());
        record.setDeviceId(data.getDeviceId());
        record.setRsrpData(data.getRsrpData());
        record.setUsername(data.getUserName());
        return record;
    }

    public void updateExtensionForBattery(String extension, Integer batteryPercentage, String deviceId, Integer sim1, Integer sim2, Long lastUpdatedOn) {
        try {
            Optional extData = this.extensionsRepository.findByExtension(extension);
            if (extData.isPresent()) {
                ((Extension)extData.get()).setBatteryPercentage(batteryPercentage);
                ((Extension)extData.get()).setDeviceId(deviceId);
                ((Extension)extData.get()).setRsRpSim1(sim1);
                ((Extension)extData.get()).setRsRpSim2(sim2);
                ((Extension)extData.get()).setDeviceLastUpdated(lastUpdatedOn);
                this.extensionsRepository.save(extData.get());
            }
        }
        catch (Exception e) {
            logger.error("Unable to update extension for battery and rsrp:{}", (Object)e.getMessage());
        }
    }

    public void updateCoordinateBattery(String username, Long updatedEpoch, String updatedBy, Integer batteryPercentage, String deviceId, Integer sim1, Integer sim2, String extension) {
        List getUserCoordinate = this.userCoordinateRepository.findByUsername(username);
        if (!getUserCoordinate.isEmpty()) {
            for (UserCoordinate userCoordinate : getUserCoordinate) {
                userCoordinate.setUpdatedOn(updatedEpoch);
                userCoordinate.setHealthUpdatedOn(updatedEpoch);
                userCoordinate.setUpdatedBy(updatedBy);
                userCoordinate.setBatteryPercentage(batteryPercentage);
                userCoordinate.setDeviceId(deviceId);
                userCoordinate.setRsRpSim1(sim1);
                userCoordinate.setRsRpSim2(sim2);
                String department = this.extensionService.getDepartment(extension);
                if (department != null && StringUtils.hasText((String)department)) {
                    userCoordinate.setDepartment(department);
                }
                this.userCoordinateRepository.save((Object)userCoordinate);
                logger.info("UserCoordinate updated successfully for user: {}", (Object)username);
            }
        } else {
            logger.error("No record found for user: {}", (Object)username);
        }
    }

    private List<CoordinateDataModel> callSnapToRoadsApi(List<CoordinateDataModel> originalCoordinates) {
        String apiKey = "AIzaSyAZVqRpoEL3WRH4f0Tsj4BSwNMv781-GYM";
        ArrayList<CoordinateDataModel> snappedList = new ArrayList();
        try {
            List<CoordinateDataModel> validPoints = originalCoordinates.stream().filter(coord -> {
                try {
                    return Float.parseFloat(coord.getGpsAccuracy()) <= 25.0f;
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toList());
            if (validPoints.isEmpty()) {
                logger.warn("No valid GPS coordinates to snap.");
                return snappedList;
            }
            return validPoints;
        }
        catch (Exception e) {
            logger.error("Failed to call SnapToRoads API: {}", (Object)e.getMessage(), (Object)e);
            snappedList = originalCoordinates;
            return snappedList;
        }
    }

    private double haversineMeters(double lat1, double lon1, double lat2, double lon2) {
        int R = 6371000;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        return 1.2742E7 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
    }

    public RequestResponse getUserDetailsHistory(UserDetailHistoryModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<UserPathTraceModel> result = new ArrayList<UserPathTraceModel>();
        try {
            List coordinates = this.repository.findByExtensionAndEpochDateBetween(data.getExtension(), data.getFromDate(), data.getToDate());
            if (coordinates.isEmpty()) {
                logger.error("Data is Not Found");
                returnValue.setIssue(Constants.NodeStatus.OK);
                returnValue.setMessage("Data is Not Found In Range");
                returnValue.setMessageDetail("Contact to Administrator");
                returnValue.setData(Collections.emptyList());
                return returnValue;
            }
            UserPathTraceModel path = new UserPathTraceModel();
            path.setUserName(((RouteCoordinate)coordinates.get(0)).getExtension());
            List locationList = coordinates.stream().map(c -> new LatLongModel(c.getLatitude(), c.getLongitude(), c.getEpochDate())).collect(Collectors.toList());
            path.setLocation(locationList);
            result.add(path);
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setStatus(0);
            returnValue.setMessage("Area/Route details");
            returnValue.setMessageDetail("Data fetched successfully");
            returnValue.setData(result);
        }
        catch (Exception e) {
            logger.error("Unable to find data: {}", (Object)e.getMessage());
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to find details of user");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }

    public RequestResponse monitorUser(String monitorUser) {
        RequestResponse returnValue = new RequestResponse();
        try {
            this.monitoredUser = monitorUser;
            returnValue.setStatus(0);
            returnValue.setMessage("User Monitor");
            returnValue.setMessageDetail("User Monitor successfully");
        }
        catch (Exception e) {
            logger.error("Unable to find data: {}", (Object)e.getMessage());
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to find details of user");
        }
        return returnValue;
    }

    public RequestResponse clearMonitorUser() {
        RequestResponse returnValue = new RequestResponse();
        try {
            this.monitoredUser = "";
            returnValue.setStatus(0);
            returnValue.setMessage("Monitor Cleared");
            returnValue.setMessageDetail("Monitor user cleared successfully");
        }
        catch (Exception e) {
            logger.error("Error clearing monitor user: {}", (Object)e.getMessage());
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to clear monitor user");
        }
        return returnValue;
    }

    public String getMonitoredUser() {
        return this.monitoredUser == null ? "" : this.monitoredUser;
    }
}

