/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.polygon.area.service;

import com.coraltele.telemetry.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.telemetry.db.telemetry.main.entity.UserZone;
import com.coraltele.telemetry.db.telemetry.main.repository.UserCoordinateRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.telemetry.db.telemetry.main.specification.UserZoneSpecification;
import com.coraltele.telemetry.db.users.main.entity.ShiftTime;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.entity.UserShift;
import com.coraltele.telemetry.db.users.main.repository.ShiftTimeRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.db.users.main.repository.UserShiftRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.EventDetail;
import com.coraltele.telemetry.helper.EventNotification;
import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.ReturnField;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.coralnms.geo_pin.service.GeoTaggingService;
import com.coraltele.telemetry.service.main.eventNotification.model.EventNotifyModel;
import com.coraltele.telemetry.service.main.eventNotification.service.EventNotifyService;
import com.coraltele.telemetry.service.main.polygon.area.model.AreaModel;
import com.coraltele.telemetry.service.main.polygon.area.model.CoordinateModel;
import com.coraltele.telemetry.service.main.polygon.area.model.UserAreaModel;
import com.coraltele.telemetry.service.main.polygon.route.model.RouteModel;
import com.coraltele.telemetry.service.main.service.UserCoordinateService;
import com.coraltele.telemetry.service.user.model.UserNotifyModel;
import com.coraltele.telemetry.service.user.service.UserService;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AreaService {
    private static final Logger logger = LogManager.getLogger(AreaService.class);
    @Autowired
    UserZoneRepository areaRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserService userService;
    @Autowired
    GeoTaggingService geoTaggingService;
    @Autowired
    EventNotifyService eventNotifyService;
    @Autowired
    UserCoordinateService userCoordinateService;
    @Autowired
    UserCoordinateRepository userCoordinateRepository;
    @Autowired
    UserShiftRepository userShiftRepository;
    @Autowired
    ShiftTimeRepository shiftTimeRepository;
    @Autowired
    UserZoneRepository userZoneRepository;

    public RequestResponse createData(AreaModel data, Principal principal) {
        logger.debug("Creating new area: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional areaOptional = this.areaRepository.findByName(data.getName());
            if (areaOptional.isPresent()) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Area Creation Failed");
                returnValue.setMessageDetail("Area with name '" + data.getName() + "' already exists");
                logger.warn(returnValue.getMessageDetail());
                return returnValue;
            }
            UserZone areaData = new UserZone();
            areaData.setCreatedBy(principal.getName());
            areaData.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            areaData.setName(data.getName());
            areaData.setType(data.getShapeId());
            areaData.setProject("kumbh");
            GeometryFactory geometryFactory = new GeometryFactory();
            Coordinate[] coordinates = (Coordinate[])data.getCoordinates().stream().map(coord -> new Coordinate(Double.parseDouble(coord.getLongitude().trim()), Double.parseDouble(coord.getLatitude().trim()))).toArray(Coordinate[]::new);
            if (coordinates.length > 0 && !coordinates[0].equals((Object)coordinates[coordinates.length - 1])) {
                coordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
                coordinates[coordinates.length - 1] = coordinates[0];
            }
            Polygon serviceArea = geometryFactory.createPolygon(coordinates);
            logger.info("Generated Polygon WKT: " + serviceArea.toText());
            areaData.setCoordinate(serviceArea);
            this.areaRepository.save((Object)areaData);
            ReturnField field = new ReturnField();
            field.setId(areaData.getId().intValue());
            field.setDescription(areaData.getName());
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setMessage("Area Created");
            returnValue.setMessageDetail("Area saved successfully");
            returnValue.setData((Object)field);
            logger.info(returnValue.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid argument: {}", (Object)e.getMessage());
        }
        catch (JpaSystemException e) {
            logger.error("JPA system error: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Unexpected error: {}", (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse updateById(AreaModel data, Principal principal) {
        logger.debug("Update Area {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional areaData = this.areaRepository.findById((Object)data.getId());
        if (!areaData.isPresent()) {
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Area Not Found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        try {
            if (!data.getName().equals(((UserZone)areaData.get()).getName()) && this.areaRepository.existsByName(data.getName())) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Area Update Failed");
                returnValue.setMessageDetail("Selected area: " + data.getName() + ",already exists");
                return returnValue;
            }
            if (data.getName() != null) {
                ((UserZone)areaData.get()).setName(data.getName());
            }
            if (data.getShapeId() != null) {
                ((UserZone)areaData.get()).setType(data.getShapeId());
            }
            if (data.getCoordinates() != null) {
                GeometryFactory geometryFactory = new GeometryFactory();
                Coordinate[] coordinates = (Coordinate[])data.getCoordinates().stream().map(coord -> new Coordinate(Double.parseDouble(coord.getLongitude().trim()), Double.parseDouble(coord.getLatitude().trim()))).toArray(Coordinate[]::new);
                if (coordinates.length > 0 && !coordinates[0].equals((Object)coordinates[coordinates.length - 1])) {
                    coordinates = Arrays.copyOf(coordinates, coordinates.length + 1);
                    coordinates[coordinates.length - 1] = coordinates[0];
                }
                Polygon serviceArea = geometryFactory.createPolygon(coordinates);
                logger.info("Generated Polygon WKT: " + serviceArea.toText());
                ((UserZone)areaData.get()).setCoordinate(serviceArea);
            }
            ((UserZone)areaData.get()).setUpdatedBy(principal.getName());
            ((UserZone)areaData.get()).setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
            this.areaRepository.save(areaData.get());
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setMessage("Updated");
            returnValue.setMessageDetail("Area Updated Successfully");
            logger.info(returnValue.getMessage());
            try {
                List list = this.userRepository.findByAreaId(data.getId());
                if (!list.isEmpty()) {
                    for (User user : list) {
                        long epoch = System.currentTimeMillis() / 1000L;
                        this.userRepository.findById(user.getId()).ifPresent(assignedUser -> {
                            EventNotifyModel eventData = new EventNotifyModel();
                            eventData.setReadByUser(Boolean.valueOf(false));
                            eventData.setEventData((Object)("Area Updated, Confirm coordinates of area:" + ((UserZone)areaData.get()).getName()));
                            eventData.setEventId(Constants.EventStatus.USER_ZONE_UPDATE_EVENT);
                            eventData.setEventSeverity(Integer.valueOf(1));
                            eventData.setEventUUID(UUID.randomUUID().toString());
                            eventData.setEventMessage("Area updated with new data");
                            eventData.setEventEpoch(Long.valueOf(epoch));
                            eventData.setEventDestination(user.getUsername());
                            eventData.setEventSource(principal.getName());
                            this.eventNotifyService.sendNotification(eventData);
                        });
                        logger.info("area updated notification send to user:{}", (Object)user.getUsername());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info("Unable to send event on area update:{}", (Object)e.getMessage());
            }
        }
        catch (IllegalArgumentException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            logger.error("Invalid argument: {}", (Object)e.getMessage());
        }
        catch (JpaSystemException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            logger.error("JPA system error: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            logger.error("Unexpected error: {}", (Object)e.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getId()) {
            Optional areaData = this.areaRepository.findById((Object)ids);
            if (areaData.isPresent()) {
                addValue.add(areaData.get());
                continue;
            }
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.areaRepository.deleteAll(addValue);
        try {
            List list = this.userRepository.findByAreaIdIn(data.getId());
            if (!list.isEmpty()) {
                for (User user : list) {
                    LocalDateTime currentDateTime = LocalDateTime.now();
                    LocalDateTime startOfDay = currentDateTime.toLocalDate().atStartOfDay();
                    long epoch = startOfDay.toEpochSecond(ZoneOffset.UTC);
                    this.userRepository.findById(user.getId()).ifPresent(assignedUser -> {
                        EventNotifyModel eventData = new EventNotifyModel();
                        eventData.setReadByUser(Boolean.valueOf(false));
                        eventData.setEventData((Object)("Area Deleted, please verify the coordinates:" + assignedUser.getUsername()));
                        eventData.setEventId(Constants.EventStatus.USER_ZONE_DELETE_EVENT);
                        eventData.setEventSeverity(Integer.valueOf(1));
                        eventData.setEventUUID(UUID.randomUUID().toString());
                        eventData.setEventMessage("Area Deleted");
                        eventData.setEventEpoch(Long.valueOf(epoch));
                        eventData.setEventDestination(user.getUsername());
                        eventData.setEventSource(principal.getName());
                        this.eventNotifyService.sendNotification(eventData);
                    });
                    logger.info("area deleted for user:{}", (Object)user.getUsername());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Unable to send event on area delete:{}", (Object)e.getMessage());
        }
        returnValue.setIssue(Constants.NodeStatus.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse deleteByType(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Object ids : data.getStringId()) {
            Optional areaData = this.areaRepository.findByType((String)ids);
            if (areaData.isPresent()) {
                addValue.add(areaData.get());
                continue;
            }
            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records Not Found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        this.areaRepository.deleteAll(addValue);
        try {
            ArrayList<Integer> list1 = new ArrayList<Integer>();
            for (String id : data.getStringId()) {
                Optional listOfArea = this.areaRepository.findByType(id);
                list1.add(((UserZone)listOfArea.get()).getId());
            }
            List list = this.userRepository.findByAreaIdIn(list1);
            if (!list.isEmpty()) {
                for (User user : list) {
                    LocalDateTime currentDateTime = LocalDateTime.now();
                    LocalDateTime startOfDay = currentDateTime.toLocalDate().atStartOfDay();
                    long epoch = startOfDay.toEpochSecond(ZoneOffset.UTC);
                    this.userRepository.findById(user.getId()).ifPresent(assignedUser -> {
                        EventNotifyModel eventData = new EventNotifyModel();
                        Optional areaType = this.areaRepository.findById((Object)user.getAreaId());
                        eventData.setReadByUser(Boolean.valueOf(false));
                        eventData.setEventData((Object)("Area Deleted, confirm the area:" + ((UserZone)areaType.get()).getName()));
                        eventData.setEventId(Constants.EventStatus.USER_ZONE_UPDATE_EVENT);
                        eventData.setEventSeverity(Integer.valueOf(1));
                        eventData.setEventUUID(UUID.randomUUID().toString());
                        eventData.setEventMessage("Area Deleted");
                        eventData.setEventEpoch(Long.valueOf(epoch));
                        eventData.setEventDestination(user.getUsername());
                        eventData.setEventSource(principal.getName());
                        this.eventNotifyService.sendNotification(eventData);
                    });
                    logger.info("area deleted notification send to user:{}", (Object)user.getUsername());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("Unable to send event on area update:{}", (Object)e.getMessage());
        }
        returnValue.setIssue(Constants.NodeStatus.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAll() {
        List areas = this.areaRepository.findAll();
        ArrayList<AreaModel> areaModels = new ArrayList<AreaModel>();
        RequestResponse returnValue = new RequestResponse();
        for (UserZone area : areas) {
            AreaModel model = new AreaModel();
            model.setId(area.getId());
            model.setName(area.getName());
            model.setShapeId(area.getType());
            if (area.getCoordinate() != null) {
                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                for (Coordinate coordinate : area.getCoordinate().getCoordinates()) {
                    CoordinateModel coordModel = new CoordinateModel();
                    coordModel.setLongitude(String.valueOf(coordinate.x));
                    coordModel.setLatitude(String.valueOf(coordinate.y));
                    coordinateModels.add(coordModel);
                }
                model.setCoordinates(coordinateModels);
            }
            areaModels.add(model);
        }
        returnValue.setIssue(Constants.NodeStatus.OK);
        returnValue.setMessage("OK");
        returnValue.setData(areaModels);
        logger.info("Fetched {} areas successfully", (Object)areaModels.size());
        return returnValue;
    }

    public RequestResponse getAllArea(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserZoneSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.areaRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.areaRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AreaModel> entityToModelConversion(List<UserZone> areas) {
        ArrayList<AreaModel> addValue = new ArrayList<AreaModel>();
        for (UserZone row : areas) {
            AreaModel data = new AreaModel();
            data.setId(row.getId());
            data.setName(row.getName());
            data.setShapeId(row.getType());
            if (row.getCoordinate() != null) {
                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                for (Coordinate coordinate : row.getCoordinate().getCoordinates()) {
                    CoordinateModel coordModel = new CoordinateModel();
                    coordModel.setLongitude(String.valueOf(coordinate.x));
                    coordModel.setLatitude(String.valueOf(coordinate.y));
                    coordinateModels.add(coordModel);
                }
                data.setCoordinates(coordinateModels);
            }
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getCoordinate(Integer areaId, String shapeId) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<UserAreaModel> data = new ArrayList<UserAreaModel>();
        try {
            Optional areaData;
            List userList = new ArrayList();
            if (areaId != null) {
                userList = this.userRepository.findByAreaId(areaId);
            } else if (shapeId != null && (areaData = this.areaRepository.findByType(shapeId)).isPresent()) {
                userList = this.userRepository.findByAreaId(((UserZone)areaData.get()).getId());
            }
            if (!userList.isEmpty()) {
                for (User user : userList) {
                    UserAreaModel row = new UserAreaModel();
                    if (this.userCoordinateService.checkUserExist(user.getUsername())) {
                        UserCoordinate userCoordinate = this.userCoordinateService.getUserCoordinateData(user.getUsername());
                        if (userCoordinate != null) {
                            row.setUserLat(userCoordinate.getGeoX());
                            row.setUserLong(userCoordinate.getGeoY());
                        }
                    } else {
                        row.setUserLat("0");
                        row.setUserLong("0");
                    }
                    row.setUser(user.getUsername());
                    data.add(row);
                }
                returnValue.setIssue(Constants.NodeStatus.OK);
                returnValue.setStatus(0);
                returnValue.setMessage("list of users");
                returnValue.setData(data);
            } else {
                returnValue.setIssue(Constants.NodeStatus.OK);
                returnValue.setStatus(0);
                returnValue.setMessage("Selected area have no user");
            }
        }
        catch (Exception e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(2);
            returnValue.setMessage("Unable to find area of user");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }

    public void sendUserNotify(UserNotifyModel data) {
        try {
            EventNotification dataToSend = new EventNotification();
            EventDetail eventData = new EventDetail();
            eventData.setDescription(data.getDescription());
            dataToSend.setSubscriber(data.getUsername());
            dataToSend.setEventData(eventData);
            dataToSend.setEventEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            dataToSend.setEventType(data.getEventType());
            dataToSend.setEventLevel(Integer.valueOf(5));
            dataToSend.setEventSeverity("Area update alert");
            Messaging.sendEvent((EventNotification)dataToSend);
            logger.info("Event send successfully:{}", (Object)dataToSend);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public RequestResponse getAreaOfUser(String username, Principal principal, boolean isUser) {
        RequestResponse returnValue = new RequestResponse();
        UserAreaModel data = new UserAreaModel();
        long currentEpochSeconds = Instant.now().getEpochSecond();
        try {
            Optional userData;
            Optional optional = userData = isUser ? this.userRepository.findByUsername(username) : this.userRepository.findByUsername(principal.getName());
            if (!userData.isPresent() || !StringUtils.hasText((String)((User)userData.get()).getUsername())) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setStatus(2);
                returnValue.setMessage("Selected user does not exist");
                return returnValue;
            }
            String userUsername = ((User)userData.get()).getUsername();
            this.userCoordinateRepository.findByUsername(userUsername).stream().findFirst().ifPresent(userCoordinate -> {
                data.setUserLat(userCoordinate.getGeoX());
                data.setUserLong(userCoordinate.getGeoY());
            });
            List userShiftList = this.userShiftRepository.findByUserId(userUsername);
            Integer shiftIdRequired = userShiftList.stream().map(UserShift::getShiftId).map(arg_0 -> ((ShiftTimeRepository)this.shiftTimeRepository).findById(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(shiftTime -> currentEpochSeconds >= shiftTime.getFromDateTime() && currentEpochSeconds <= shiftTime.getToDateTime()).map(ShiftTime::getId).findFirst().orElse(0);
            if (shiftIdRequired == 0) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setStatus(2);
                returnValue.setMessage("No active shift found for the user");
                return returnValue;
            }
            List userShiftByShiftId = this.userShiftRepository.findByShiftId(shiftIdRequired);
            if (userShiftByShiftId.isEmpty() || ((UserShift)userShiftByShiftId.get(0)).getZoneId() == null) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setStatus(2);
                returnValue.setMessage("User is not associated with any area/zone");
                return returnValue;
            }
            Integer areaId = ((UserShift)userShiftByShiftId.get(0)).getZoneId();
            Optional areaData = this.userZoneRepository.findById((Object)areaId);
            if (!areaData.isPresent()) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setStatus(2);
                returnValue.setMessage("Selected user has no defined area");
                return returnValue;
            }
            UserZone userZone = (UserZone)areaData.get();
            RouteModel areaInfo = new RouteModel();
            areaInfo.setId(areaId);
            areaInfo.setName(userZone.getName());
            areaInfo.setShapeId(userZone.getType());
            if (userZone.getCoordinate() != null) {
                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                ArrayList<Coordinate> areaCoordinates = new ArrayList<Coordinate>();
                for (Coordinate coordinate : userZone.getCoordinate().getCoordinates()) {
                    CoordinateModel coordModel = new CoordinateModel();
                    coordModel.setLongitude(String.valueOf(coordinate.x));
                    coordModel.setLatitude(String.valueOf(coordinate.y));
                    coordinateModels.add(coordModel);
                    areaCoordinates.add(new Coordinate(coordinate.x, coordinate.y));
                }
                areaInfo.setCoordinates(coordinateModels);
                if (data.getUserLat() != null && data.getUserLong() != null) {
                    Point userPoint;
                    GeometryFactory geometryFactory = new GeometryFactory();
                    Polygon areaPolygon = geometryFactory.createPolygon(areaCoordinates.toArray(new Coordinate[0]));
                    if (areaPolygon.contains((Geometry)(userPoint = geometryFactory.createPoint(new Coordinate(Double.parseDouble(data.getUserLong()), Double.parseDouble(data.getUserLat())))))) {
                        data.setCurrentPosition("inside");
                    } else {
                        data.setCurrentPosition("outside");
                        this.sendOutsideZoneNotification(((User)userData.get()).getUsername(), principal.getName());
                    }
                } else {
                    data.setCurrentPosition("not-defined");
                }
            }
            data.setAreaData(areaInfo);
            data.setUser(principal.getName());
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setStatus(0);
            returnValue.setMessage("Area fetched successfully");
            returnValue.setData((Object)data);
        }
        catch (Exception e) {
            logger.error("Error while fetching area for user: {}", (Object)e.getMessage(), (Object)e);
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setStatus(2);
            returnValue.setMessage("Unable to find the area of the user");
            returnValue.setMessageDetail("Contact the administrator");
        }
        return returnValue;
    }

    private void sendOutsideZoneNotification(String username, String source) {
        try {
            LocalDateTime currentDateTime = LocalDateTime.now();
            LocalDateTime startOfDay = currentDateTime.toLocalDate().atStartOfDay();
            long epoch = startOfDay.toEpochSecond(ZoneOffset.UTC);
            EventNotifyModel eventData = new EventNotifyModel();
            eventData.setReadByUser(Boolean.valueOf(false));
            eventData.setEventData((Object)"User Outside from Zone");
            eventData.setEventId(Constants.EventStatus.USER_ZONE_ALERT_EVENT);
            eventData.setEventSeverity(Integer.valueOf(1));
            eventData.setEventUUID(UUID.randomUUID().toString());
            eventData.setEventMessage("User Outside from defined Zone");
            eventData.setEventEpoch(Long.valueOf(epoch));
            eventData.setEventDestination(username);
            eventData.setEventSource(source);
            this.eventNotifyService.sendNotification(eventData);
        }
        catch (Exception e) {
            logger.error("Unable to send notification for outside user: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

