/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.category.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.coralnms.category.model.CategoryModel;
import com.coraltele.telemetry.service.coralnms.category.service.CategoryService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/category"})
@RestController
public class CategoryController {
    @Autowired
    CategoryService categoryService;

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> list() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.categoryService.getCategory();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody CategoryModel data) {
        RequestResponse returnValue = this.categoryService.createData(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody CategoryModel data) {
        RequestResponse returnValue = this.categoryService.updateById(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.categoryService.deleteCategoryById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/filteredList"})
    public ResponseEntity<RequestResponse> getFilterDataV2(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.categoryService.getAllCategoryByFilter(searchRequest);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateImageName"})
    public ResponseEntity<RequestResponse> updateImage(@RequestBody CategoryModel data) {
        RequestResponse returnValue = this.categoryService.updateImageName(data);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/export"})
    public ResponseEntity<RequestResponse> storeDataIntoFile() throws IOException {
        RequestResponse returnValue = this.categoryService.storeDataIntoFile();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

