/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.billing.callMos.service;

import com.coraltele.telemetry.db.telephony.pbx.entity.NodeConfiguration;
import com.coraltele.telemetry.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.billing.callMos.model.MosDataModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Component;

@Component
public class MessageProducerService {
    private static final Logger logger = LogManager.getLogger(MessageProducerService.class);
    @Autowired
    NodeConfigurationRepository nodeConfigurationRepository;

    public RequestResponse createMos(MosDataModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            List ipList = this.nodeConfigurationRepository.findAll();
            String jsonMessage = this.convertToJson(data);
            String ownIp = this.getServerIp();
            if (!ipList.isEmpty()) {
                for (NodeConfiguration row : ipList) {
                    if (1 != row.getIsBillingEnabled()) continue;
                    this.sendMessageToQueue(jsonMessage, ownIp, row.getServerCode());
                    logger.info("Data sent to queue {} on own ActiveMQ", (Object)row.getServerCode());
                }
                returnValue.setStatus(0);
                returnValue.setMessage("Success, Message sent to billing servers");
            } else {
                returnValue.setStatus(0);
                returnValue.setMessage("No billing servers found");
            }
        }
        catch (Exception e) {
            logger.error("Error sending message: {}", (Object)e.getMessage(), (Object)e);
            returnValue.setStatus(-1);
            returnValue.setMessage("Error, Failed to send message");
        }
        return returnValue;
    }

    public String getServerCode() {
        Properties prop = new Properties();
        FileInputStream input = null;
        String serverCode = "";
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        try {
            input = new FileInputStream(fileName);
            prop.load(input);
            if (prop.getProperty("servercode") != null && prop.getProperty("servercode").length() > 0) {
                serverCode = prop.getProperty("servercode");
                logger.info("Server code for recording: {}", (Object)serverCode);
            }
        }
        catch (Exception e) {
            logger.error("Unable to find ServerCode", (Throwable)e);
        }
        return serverCode.trim();
    }

    public String getServerIp() {
        String serverIp = "";
        try {
            Optional ipAddress = this.nodeConfigurationRepository.findByServerCode(this.getServerCode());
            if (ipAddress.isPresent()) {
                serverIp = ((NodeConfiguration)ipAddress.get()).getIpAddress();
            } else {
                logger.error("IpAddress not exist");
            }
        }
        catch (Exception e) {
            logger.error("Unable to find ipAddress", (Throwable)e);
        }
        return serverIp.trim();
    }

    private void sendMessageToQueue(String message, String ownIp, String serverCode) {
        String queueName = serverCode + ".call.mos";
        String brokerUrl = "tcp://" + ownIp + ":9890";
        try {
            JmsTemplate customJmsTemplate = this.createJmsTemplate(brokerUrl);
            customJmsTemplate.convertAndSend(queueName, (Object)message);
            logger.info("Sent message to queue: {} on broker: {}", (Object)queueName, (Object)brokerUrl);
        }
        catch (Exception e) {
            logger.error("Failed to send message to broker: {} - Error: {}", (Object)brokerUrl, (Object)e.getMessage(), (Object)e);
        }
    }

    private JmsTemplate createJmsTemplate(String brokerUrl) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("admin", "admin", brokerUrl);
        JmsTemplate jmsTemplate = new JmsTemplate((ConnectionFactory)connectionFactory);
        jmsTemplate.setDeliveryPersistent(true);
        return jmsTemplate;
    }

    private String convertToJson(MosDataModel data) {
        try {
            return new ObjectMapper().writeValueAsString((Object)data);
        }
        catch (Exception e) {
            logger.error("Error converting data to JSON", (Throwable)e);
            return "{}";
        }
    }
}

