/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telemetry.main.repository;

import com.coraltele.telemetry.db.telemetry.main.entity.TelephonyDeployment;
import com.coraltele.telemetry.model.interface_model.IRLU;
import com.coraltele.telemetry.model.interface_model.IServerNode;
import com.coraltele.telemetry.model.interface_model.ITelephonyTreeData;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;

public interface TelephonyDeploymentRepository
extends CrudRepository<TelephonyDeployment, Long> {
    public List<TelephonyDeployment> findAll();

    @Query(value="select a.id,a.nodeip,a.priority,a.rlucode,a.servercode,a.virtualip,a.hostname,b.severity,b.severity_updated_on,b.status,b.node_name as nodename\nfrom telephonydeployment a\ninner join coralnms.scada_assets b on a.nodeip = b.ip_address\norder by a.rlucode,a.priority;", nativeQuery=true)
    public List<ITelephonyTreeData> getTreeData();

    @Query(value="select a.id,a.nodeip,a.priority,a.rlucode,a.servercode,a.virtualip,a.hostname,b.severity,b.severity_updated_on,b.status,b.node_name as nodename\nfrom telephonydeployment a\ninner join coralnms.scada_assets b on a.nodeip = b.ip_address\nwhere a.virtualip = ?1 and a.hostname = b.node_name\norder by a.rlucode,a.priority;", nativeQuery=true)
    public List<ITelephonyTreeData> getActiveIP(String var1);

    @Query(value="select rlucode, max(hostname) as hostname, max(virtualip) as virtualip from telephonydeployment group by rlucode order by rlucode", nativeQuery=true)
    public List<IRLU> getRLU();

    @Query(value="select nodename,max(nodeip) as ipaddress  from (select a.id,a.nodeip,a.priority,a.rlucode,a.servercode,a.virtualip,a.hostname,b.severity,b.severity_updated_on,b.status,b.node_name as nodename\nfrom telephonydeployment a\ninner join coralnms.scada_assets b on a.nodeip = b.ip_address\n) a1  group by nodename order by nodename;", nativeQuery=true)
    public List<IServerNode> getNodeList();
}

