/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.component.service.AlertEngineService;
import com.coraltele.telemetry.db.telemetry.main.entity.MonitoredField;
import com.coraltele.telemetry.db.telemetry.main.entity.MonitoredFieldValueRule;
import com.coraltele.telemetry.db.telemetry.main.repository.MonitoredFieldRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.MonitoredFieldValueRuleRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.pbx.repository.ExtensionsRepository;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FieldMonitorService {
    private static final Logger logger = LoggerFactory.getLogger(FieldMonitorService.class);
    @Autowired
    private MonitoredFieldRepository monitoredFieldRepository;
    @Autowired
    private MonitoredFieldValueRuleRepository monitoredFieldValueRuleRepository;
    @Autowired
    private ExtensionsRepository extensionsRepo;
    @Autowired
    private AlertEngineService alertEngineService;

    public void monitorFields() {
        logger.info("Starting field monitoring cycle.");
        List fields = this.monitoredFieldRepository.findByEnabledTrue();
        for (MonitoredField field : fields) {
            this.extensionsRepo.findAll().forEach(ext -> this.evaluateField(field, ext));
        }
        logger.info("Finished field monitoring cycle.");
    }

    private void evaluateField(MonitoredField field, Extension ext) {
        try {
            Field javaField = ReflectionUtils.findField(Extension.class, (String)field.getColumnName());
            if (javaField == null) {
                logger.error("Monitored field '{}' does not exist on Extension entity.", (Object)field.getColumnName());
                return;
            }
            javaField.setAccessible(true);
            String value = ReflectionUtils.getField((Field)javaField, (Object)ext).toString();
            if (!StringUtils.hasText((String)value)) {
                this.handleOutcome(field, ext, "Value is missing", field.getMissingSeverity());
                return;
            }
            List rules = this.monitoredFieldValueRuleRepository.findByField(field.getUuid());
            boolean matchFound = false;
            for (MonitoredFieldValueRule rule : rules) {
                if (!rule.getMatchValue().equals(String.valueOf(value))) continue;
                this.handleOutcome(field, ext, "Matches rule " + rule.getId(), rule.getSeverity());
                matchFound = true;
                break;
            }
            if (!matchFound) {
                this.handleOutcome(field, ext, "No matching rule found", field.getUnmatchedSeverity());
            }
        }
        catch (Exception e) {
            logger.error("Error evaluating monitored field '{}' for subscriber {}", new Object[]{field.getService(), ext.getId(), e});
        }
    }

    private void handleOutcome(MonitoredField field, Extension ext, String reason, Integer severity) {
        if (severity.equals(0)) {
            this.alertEngineService.closeAlert(ext.getExtension(), field.getService());
        } else {
            this.alertEngineService.raiseAlert(ext.getExtension(), field.getService(), severity.intValue(), reason);
        }
    }
}

