/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Category;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.DeviceModel;
import com.coraltele.telemetry.db.telemetry.main.repository.DeviceModelRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.helper.SIPHelper;
import com.coraltele.telemetry.model.DeviceDetailModel;
import com.coraltele.telemetry.model.DeviceManagerConfigurationModel;
import com.coraltele.telemetry.service.main.DeviceModel.service.DeviceModelService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DeviceManagerService {
    private static final Logger logger = LogManager.getLogger(DeviceManagerService.class);
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    @Autowired
    ExtensionRepository extensionRepository;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    private DeviceModelRepository deviceModelRepository;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DeviceModelService deviceModelService;
    private String AcsTokenForAutoDeploy;
    private String SipAndLDAPServerIP;

    public DeviceDetailModel getProductDetails(String productClass) {
        DeviceDetailModel returnValue = new DeviceDetailModel();
        Optional productDetail = this.deviceModelRepository.findByProductClass(productClass);
        if (productDetail.isPresent()) {
            returnValue.setOui(((DeviceModel)productDetail.get()).getOui());
            returnValue.setManufacturer(((DeviceModel)productDetail.get()).getManufacturer());
            returnValue.setProductClass(((DeviceModel)productDetail.get()).getProductClass());
            returnValue.setFirmware_version(((DeviceModel)productDetail.get()).getFirmwareVersion());
            returnValue.setConfiguration_version(((DeviceModel)productDetail.get()).getConfigurationVersion());
        }
        return returnValue;
    }

    private byte[] readFileContent(String filePath) throws IOException {
        return Files.readAllBytes(Paths.get(filePath, new String[0]));
    }

    public RequestResponse resetOrReboot(String macAddress, String ApiName) {
        RequestResponse returnValue = new RequestResponse();
        List sCADAAssetData = this.scadaAssetRepository.findByMacAddress(macAddress);
        try {
            DeviceDetailModel deviceData = new DeviceDetailModel();
            if (!sCADAAssetData.isEmpty() && StringUtils.hasText((String)((SCADAAsset)sCADAAssetData.get(0)).getCategory())) {
                Optional category = this.categoryRepository.findByCode(((SCADAAsset)sCADAAssetData.get(0)).getCategory());
                deviceData = this.getProductDetails(((Category)category.get()).getProductClass());
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.set("Cookie", "session={\"AuthToken\":\"" + this.getAcsGlobelToken() + "\"}");
            String requestBody = "[{\"device\": \"" + deviceData.getOui() + "-" + deviceData.getProductClass() + "-" + macAddress + "\", \"name\": \"" + ApiName + "\", \"status\": \"success\"}]";
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            String url = "http://" + Constants.TR069_SERVER_IP + "/api/devices/" + deviceData.getOui() + "-" + deviceData.getProductClass() + "-" + macAddress + "/tasks";
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                logger.info(ApiName + " api call successful.");
                returnValue.setStatus(0);
                returnValue.setMessage((String)response.getBody());
                returnValue.setMessageDetail(ApiName + " api call successfully.");
                return returnValue;
            }
            logger.error("API call failed with status code: ", (Object)response.getStatusCode());
            returnValue.setStatus(-1);
            returnValue.setMessage(ApiName + " API call failed.");
            return returnValue;
        }
        catch (Exception e) {
            logger.error("Exception error :{}", (Object)e.getMessage());
            returnValue.setStatus(-1);
            returnValue.setMessage("Error while " + ApiName + " the device.");
            return returnValue;
        }
    }

    public RequestResponse update(String macAddress, String updateCall) {
        RequestResponse returnValue = new RequestResponse();
        List sCADAAssetData = this.scadaAssetRepository.findByMacAddress(macAddress);
        try {
            DeviceDetailModel deviceData = new DeviceDetailModel();
            if (!sCADAAssetData.isEmpty() && StringUtils.hasText((String)((SCADAAsset)sCADAAssetData.get(0)).getCategory())) {
                Optional category = this.categoryRepository.findByCode(((SCADAAsset)sCADAAssetData.get(0)).getCategory());
                deviceData = this.getProductDetails(((Category)category.get()).getProductClass());
            }
            String fileName = "";
            String bodyFileName = "";
            if (updateCall.equals("firmware")) {
                fileName = deviceData.getProductClass() + ".rom";
                bodyFileName = "1 Firmware Upgrade Image";
            } else if (updateCall.equals("configuration")) {
                fileName = "cfg" + macAddress + ".xml";
                bodyFileName = "3 Vendor Configuration File";
            }
            HttpHeaders header = new HttpHeaders();
            header.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            header.setContentType(MediaType.APPLICATION_JSON);
            header.set("Cookie", "session={\"AuthToken\":\"" + this.getAcsGlobelToken() + "\"}");
            String bodyData = "[{\"device\": \"" + deviceData.getOui() + "-" + deviceData.getProductClass() + "-" + macAddress + "\", \"name\": \"download\", \"fileName\": \"" + fileName + "\", \"fileType\": \"" + bodyFileName + "\", \"status\": \"pending\"}]";
            HttpEntity entity = new HttpEntity((Object)bodyData, (MultiValueMap)header);
            String url = "http://" + Constants.TR069_SERVER_IP + "/api/devices/" + deviceData.getOui() + "-" + deviceData.getProductClass() + "-" + macAddress + "/tasks";
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                logger.info("Update file api call successful.");
                returnValue.setStatus(0);
                returnValue.setMessage((String)response.getBody());
                returnValue.setMessageDetail("Update file api call successfully.");
                return returnValue;
            }
            logger.error("Update api file failed: ");
            returnValue.setStatus(-1);
            returnValue.setMessage("Api update file failed to update.");
            return returnValue;
        }
        catch (Exception e) {
            logger.error("Update api file failed:{}", (Object)e.getMessage());
            returnValue.setStatus(-1);
            returnValue.setMessage("Error in Update api of file failed.");
            return returnValue;
        }
    }

    public RequestResponse upload(byte[] FileData, String macAddress, String updateCall, String Version2) {
        RequestResponse returnValue = new RequestResponse();
        try {
            List scadaAsset = this.scadaAssetRepository.findByMacAddress(macAddress);
            DeviceDetailModel deviceData = new DeviceDetailModel();
            if (!scadaAsset.isEmpty() && StringUtils.hasText((String)((SCADAAsset)scadaAsset.get(0)).getCategory())) {
                DeviceModel updatedData;
                DeviceModel deviceModel;
                int versionNumber;
                Optional category = this.categoryRepository.findByCode(((SCADAAsset)scadaAsset.get(0)).getCategory());
                deviceData = this.getProductDetails(((Category)category.get()).getProductClass());
                Optional data = this.deviceModelRepository.findByProductClass(deviceData.getProductClass());
                String fileName = "";
                String fileDir = "";
                String bodyFileName = "";
                String ApiName = "";
                String DeviceVersion = null;
                byte[] fileContent = null;
                if (updateCall.equals("firmware")) {
                    fileName = deviceData.getProductClass() + ".rom";
                    fileDir = "firmware";
                    bodyFileName = "1 Firmware Upgrade Image";
                    ApiName = "firmware";
                    DeviceVersion = deviceData.getFirmware_version();
                    versionNumber = Integer.parseInt(DeviceVersion);
                    DeviceVersion = Integer.toString(versionNumber + 1);
                    if (data.isPresent() && DeviceVersion != null && !DeviceVersion.isEmpty()) {
                        deviceModel = (DeviceModel)data.get();
                        deviceModel.setFirmwareVersion(DeviceVersion);
                        updatedData = (DeviceModel)this.deviceModelRepository.save((Object)deviceModel);
                        logger.info("Current firmware version is updated in device model table." + updatedData);
                    }
                } else if (updateCall.equals("configuration")) {
                    fileName = "cfg" + macAddress + ".xml";
                    fileDir = "configs";
                    bodyFileName = "3 Vendor Configuration File";
                    ApiName = "configuration";
                    DeviceVersion = deviceData.getConfiguration_version();
                    versionNumber = Integer.parseInt(DeviceVersion.trim());
                    DeviceVersion = Integer.toString(++versionNumber);
                    if (data.isPresent() && DeviceVersion != null && !DeviceVersion.isEmpty()) {
                        deviceModel = (DeviceModel)data.get();
                        deviceModel.setConfigurationVersion(DeviceVersion);
                        updatedData = (DeviceModel)this.deviceModelRepository.save((Object)deviceModel);
                        logger.info("Current configuration version is updated in device model table." + updatedData);
                    }
                }
                if (FileData == null || FileData.length == 0) {
                    String filePath = "/var/www/html/" + fileDir + "/" + fileName;
                    fileContent = this.readFileContent(filePath);
                } else {
                    fileContent = FileData;
                    if (updateCall.equals("configuration")) {
                        DeviceVersion = deviceData.getConfiguration_version();
                    } else if (updateCall.equals("firmware")) {
                        DeviceVersion = deviceData.getFirmware_version();
                    }
                    versionNumber = Integer.parseInt(DeviceVersion);
                    DeviceVersion = Integer.toString(versionNumber + 1);
                    if (data.isPresent() && DeviceVersion != null && !DeviceVersion.isEmpty() && updateCall.equals("configuration")) {
                        deviceModel = (DeviceModel)data.get();
                        deviceModel.setConfigurationVersion(DeviceVersion);
                        updatedData = (DeviceModel)this.deviceModelRepository.save((Object)deviceModel);
                        logger.info("Current configuration version is updated in device model table." + updatedData);
                    } else if (data.isPresent() && DeviceVersion != null && !DeviceVersion.isEmpty() && updateCall.equals("firmware")) {
                        deviceModel = (DeviceModel)data.get();
                        deviceModel.setFirmwareVersion(DeviceVersion);
                        updatedData = (DeviceModel)this.deviceModelRepository.save((Object)deviceModel);
                        logger.info("Current firmware version is updated in device model table." + updatedData);
                    }
                }
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
                headers.set("Cookie", "session={\"AuthToken\":\"" + this.getAcsGlobelToken() + "\"}");
                headers.set("Metadata-Filetype", bodyFileName);
                headers.set("Metadata-Oui", deviceData.getOui());
                headers.set("Metadata-Productclass", deviceData.getProductClass());
                headers.set("Metadata-Version", DeviceVersion);
                HttpEntity entity = new HttpEntity((Object)fileContent, (MultiValueMap)headers);
                String url = "http://" + Constants.TR069_SERVER_IP + "/api/files/" + fileName;
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, entity, String.class, new Object[0]);
                if (response.getStatusCode() == HttpStatus.OK) {
                    RequestResponse updateResponse = this.update(macAddress, updateCall);
                    logger.info(ApiName + " File upload and update api call successfully.");
                    returnValue.setStatus(0);
                    returnValue.setMessage((String)response.getBody());
                    returnValue.setMessageDetail(ApiName + " File upload and update api call successfully.");
                    if (updateResponse.getStatus() == -1) {
                        returnValue.setStatus(-1);
                        returnValue.setMessage("API to upload " + ApiName + " file upload and update fail.");
                        return returnValue;
                    }
                    return returnValue;
                }
                returnValue.setStatus(-1);
                returnValue.setMessage("Upload " + ApiName + " to device manager failed for : " + macAddress);
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            returnValue.setStatus(-1);
            returnValue.setMessage("Upload to device manager failed for : " + macAddress + " : Product class not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Upload to device manager failed for : " + macAddress);
            logger.error(returnValue.getMessage(), (Throwable)e);
            return returnValue;
        }
    }

    public RequestResponse ACSLoginCall() {
        RequestResponse returnValue = new RequestResponse();
        try {
            String url = "http://" + Constants.TR069_SERVER_IP + "/login";
            String username = "admin";
            String password = "admin";
            String requestBody = "{\"username\":\"" + username + "\", \"password\":\"" + password + "\"}";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange(url, HttpMethod.POST, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                String Token = (String)response.getBody();
                int startIndex = Token.indexOf(":") + 2;
                int endIndex = Token.lastIndexOf("\"");
                Token = Token.substring(startIndex, endIndex);
                returnValue.setStatus(0);
                returnValue.setMessageDetail("Get acs token call successfully.");
                returnValue.setMessage(Token);
                logger.info(returnValue.getMessageDetail());
                this.setAcsGlobelToken(Token);
                return returnValue;
            }
            returnValue.setStatus(-1);
            returnValue.setMessage(null);
            returnValue.setMessageDetail("Get acs token call failed.");
            logger.error(returnValue.getMessageDetail());
            return returnValue;
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage(null);
            returnValue.setMessageDetail("Exception error in get acs token call failed.");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
            return returnValue;
        }
    }

    public RequestResponse getListOfMacAddress() {
        RequestResponse returnValue = new RequestResponse();
        String directoryPath = Constants.DEVICE_MANAGER_FILES_PATH;
        String fileNameStart = "cfg";
        String endFileName = ".xml";
        try {
            File directory = new File(directoryPath);
            if (directory.exists() && directory.isDirectory()) {
                File[] files = directory.listFiles((dir, name) -> name.startsWith(fileNameStart) && name.endsWith(endFileName));
                if (files != null && files.length > 0) {
                    StringBuilder macAddresses = new StringBuilder();
                    for (File file : files) {
                        String fileName = file.getName();
                        String macAddress = fileName.substring(fileNameStart.length(), fileName.length() - endFileName.length());
                        macAddresses.append(macAddress).append(",");
                    }
                    if (macAddresses.length() > 0) {
                        macAddresses.setLength(macAddresses.length() - 1);
                    }
                    returnValue.setStatus(0);
                    returnValue.setMessage("Successfully retrieved list of MAC addresses.");
                    returnValue.setData((Object)macAddresses.toString());
                    return returnValue;
                }
                returnValue.setStatus(-1);
                returnValue.setMessage("No MAC address files found.");
                return returnValue;
            }
            throw new RuntimeException("Directory not found: " + directoryPath);
        }
        catch (Exception e) {
            logger.error("Error retrieving MAC address list: " + e.getMessage(), (Throwable)e);
            returnValue.setStatus(-1);
            returnValue.setMessage("Unexpected error occurred during MAC address list retrieval.");
            return returnValue;
        }
    }

    public Boolean getChangeMacAddress(String oldMacAddress, String macAddress) {
        String directoryPath = Constants.DEVICE_MANAGER_FILES_PATH;
        String oldFileName = "cfg" + oldMacAddress + ".xml";
        String newFileName = "cfg" + macAddress + ".xml";
        try {
            File directory = new File(directoryPath);
            if (directory.exists() && directory.isDirectory()) {
                File oldFile = new File(directoryPath + File.separator + oldFileName);
                File newFile = new File(directoryPath + File.separator + newFileName);
                if (oldFile.exists()) {
                    if (!newFile.exists()) {
                        ProcessBuilder processBuilder = new ProcessBuilder("mv", oldFile.getAbsolutePath(), newFile.getAbsolutePath());
                        processBuilder.directory(directory);
                        Process process = processBuilder.start();
                        int exitCode = process.waitFor();
                        if (exitCode == 0) {
                            logger.info("File renamed successfully from " + oldFileName + " to " + newFileName);
                            return true;
                        }
                        logger.info("Error renaming the file.");
                        return false;
                    }
                    logger.info("File with new name already exists: " + newFileName);
                    return false;
                }
                logger.info("Old file does not exist: " + oldFileName);
                return false;
            }
            throw new RuntimeException("Directory not found: " + directoryPath);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error processing files: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public RequestResponse methodOfUploadConfig(String fileName, byte[] FileData, String macAddress) {
        RequestResponse returnValue = new RequestResponse();
        List sCADAAssetData = this.scadaAssetRepository.findByMacAddress(macAddress);
        try {
            DeviceDetailModel deviceData = new DeviceDetailModel();
            if (!sCADAAssetData.isEmpty() && StringUtils.hasText((String)((SCADAAsset)sCADAAssetData.get(0)).getCategory())) {
                Optional category = this.categoryRepository.findByCode(((SCADAAsset)sCADAAssetData.get(0)).getCategory());
                deviceData = this.getProductDetails(((Category)category.get()).getProductClass());
            }
            String DeviceVersion = deviceData.getConfiguration_version();
            int versionNumber = Integer.parseInt(DeviceVersion);
            DeviceVersion = Integer.toString(versionNumber + 1);
            String bodyFileName = "3 Vendor Configuration File";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.set("Cookie", "session={\"AuthToken\":\"" + this.getAcsGlobelToken() + "\"}");
            headers.set("Metadata-Filetype", bodyFileName);
            headers.set("Metadata-Oui", deviceData.getOui());
            headers.set("Metadata-Productclass", deviceData.getProductClass());
            headers.set("Metadata-Version", DeviceVersion);
            HttpEntity entity = new HttpEntity((Object)FileData, (MultiValueMap)headers);
            String url = "http://" + Constants.TR069_SERVER_IP + "/api/files/" + fileName;
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.PUT, entity, String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                if (DeviceVersion != null && !DeviceVersion.isEmpty()) {
                    deviceData.setConfiguration_version(DeviceVersion);
                    DeviceModel updatedData = this.deviceModelService.updateDeviceFromDto(deviceData);
                    logger.info("Current configuration version is updated in device model table." + updatedData);
                }
                logger.info("Configuration file upload api call successfully.");
                returnValue.setStatus(0);
                returnValue.setMessage((String)response.getBody());
                returnValue.setMessageDetail("Configuration file upload api call successfully and history added.");
                return returnValue;
            }
            returnValue.setStatus(-1);
            returnValue.setMessage("Configuration file upload to device manager failed for : " + macAddress);
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        catch (Exception e) {
            returnValue.setStatus(-1);
            returnValue.setMessage("Configuration file upload Internal server error macAddress: " + macAddress);
            logger.error(returnValue.getMessage(), (Throwable)e);
            return returnValue;
        }
    }

    public String getAcsGlobelToken() {
        if (this.AcsTokenForAutoDeploy == null) {
            RequestResponse returnValue = this.ACSLoginCall();
            return returnValue.getMessage();
        }
        return this.AcsTokenForAutoDeploy;
    }

    public void setAcsGlobelToken(String token) {
        this.AcsTokenForAutoDeploy = token;
    }

    private void updateXmlElement(Document document, String tagName, String value) {
        NodeList nodes = document.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            Element element = (Element)nodes.item(0);
            element.setTextContent(value);
        }
    }

    public static void updateFileIfDifferent(String fileName, byte[] updatedFileData) {
        Path path = Paths.get(Constants.DEVICE_MANAGER_FILES_PATH, fileName);
        try {
            byte[] existingData;
            if (Files.exists(path, new LinkOption[0]) && Arrays.equals(existingData = Files.readAllBytes(path), updatedFileData)) {
                return;
            }
            Files.write(path, updatedFileData, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Error in file write {}", (Object)e.getMessage());
        }
    }

    public String findVirtualIp() {
        String virtualIp = "";
        try {
            List rluList = this.controlRluServerRepository.findAllByOrderByRluCodeAsc();
            if (!rluList.isEmpty()) {
                virtualIp = ((ControlRluServer)rluList.get(0)).getVirtualIp();
                if (rluList.size() == 1) {
                    virtualIp = ((ControlRluServer)rluList.get(0)).getVirtualIp();
                } else {
                    for (ControlRluServer rlu : rluList) {
                        if (!"main".equalsIgnoreCase(rlu.getRluCode())) continue;
                        virtualIp = rlu.getVirtualIp();
                        break;
                    }
                }
            }
            logger.info("Finding virtual ip  success: {}", (Object)virtualIp);
        }
        catch (Exception e) {
            logger.error("Error finding virtual ip Server: {}", (Throwable)e);
        }
        return virtualIp;
    }

    public boolean updatePortToFileSecond(String filePath, byte[] fileData, DeviceManagerConfigurationModel.Account postData, String fileName, String macAddress, Document document) {
        try {
            ArrayList<String> videoDisableCodecList;
            ArrayList<String> videoEnableCodecList;
            ArrayList<Integer> audioEnableCodecList;
            String ActiveAccount;
            String profileNo;
            String accountNo;
            String sipPort;
            String password;
            block98: {
                if (postData == null) {
                    logger.error("PostData is null or inactive \u2014 no update performed.");
                    return false;
                }
                Optional data = null;
                password = "NA";
                sipPort = Constants.SIP_PORT;
                accountNo = postData.getAccountNo();
                profileNo = "0";
                ActiveAccount = "0";
                audioEnableCodecList = new ArrayList<Integer>();
                ArrayList<Integer> audioDisableCodecList = new ArrayList<Integer>();
                videoEnableCodecList = new ArrayList<String>();
                videoDisableCodecList = new ArrayList<String>();
                if (postData.getExtensionNo() != null && !"NA".equals(postData.getExtensionNo())) {
                    try {
                        data = this.extensionRepository.findByExtension(postData.getExtensionNo());
                        if (data.isPresent()) {
                            String e = (Extension)data.get();
                            String rowPassword = e.getSipPassword();
                            password = SIPHelper.decryptContains((String)rowPassword);
                            ActiveAccount = "1";
                            try {
                                String value = this.findVirtualIp();
                                if (value != null && !value.isEmpty()) {
                                    this.setSipAndLDAPServerIP(value);
                                }
                            }
                            catch (Exception ex) {
                                logger.error("Error while fetching getVirtualIp() code: " + ex.getMessage(), (Throwable)ex);
                            }
                            try {
                                if (e.getPCMU() != null && e.getPCMU().booleanValue()) {
                                    audioEnableCodecList.add(0);
                                } else {
                                    audioDisableCodecList.add(0);
                                }
                                if (e.getPCMA() != null && e.getPCMA().booleanValue()) {
                                    audioEnableCodecList.add(8);
                                } else {
                                    audioDisableCodecList.add(8);
                                }
                                if (e.getOpus() != null && e.getOpus().booleanValue()) {
                                    audioEnableCodecList.add(120);
                                } else {
                                    audioDisableCodecList.add(120);
                                }
                                if (e.getG722() != null && e.getG722().booleanValue()) {
                                    audioEnableCodecList.add(9);
                                } else {
                                    audioDisableCodecList.add(9);
                                }
                                if (e.getG729() != null && e.getG729().booleanValue()) {
                                    audioEnableCodecList.add(18);
                                } else {
                                    audioDisableCodecList.add(18);
                                }
                                if (e.getG723() != null && e.getG723().booleanValue()) {
                                    audioEnableCodecList.add(4);
                                } else {
                                    audioDisableCodecList.add(4);
                                }
                                if (e.getG726() != null && e.getG726().booleanValue()) {
                                    audioEnableCodecList.add(19);
                                } else {
                                    audioDisableCodecList.add(19);
                                }
                                if (e.getH264() != null && e.getH264().booleanValue()) {
                                    videoEnableCodecList.add("H264");
                                } else {
                                    videoDisableCodecList.add("H264");
                                }
                                if (e.getH263() != null && e.getH263().booleanValue()) {
                                    videoEnableCodecList.add("H263");
                                } else {
                                    videoDisableCodecList.add("H263");
                                }
                                if (e.getVp8() != null && e.getVp8().booleanValue()) {
                                    videoEnableCodecList.add("VP8");
                                } else {
                                    videoDisableCodecList.add("VP8");
                                }
                                if (videoEnableCodecList.isEmpty()) {
                                    videoEnableCodecList.add("H264");
                                }
                                break block98;
                            }
                            catch (Exception ex) {
                                logger.error("Error while fetching codec info: " + ex.getMessage(), (Throwable)ex);
                            }
                            break block98;
                        }
                        this.setSipAndLDAPServerIP("");
                        logger.info("Extension not found in extension table: " + macAddress);
                    }
                    catch (Exception e) {
                        this.setSipAndLDAPServerIP("");
                        logger.error("Error while fetching extension: {} " + e.getMessage());
                    }
                } else {
                    postData.setLabel("NA");
                    postData.setExtensionNo("NA");
                    sipPort = "NA";
                }
            }
            switch (accountNo) {
                case "1": {
                    this.updateXmlElement(document, "P271", ActiveAccount);
                    this.updateXmlElement(document, "P24082", profileNo);
                    this.updateXmlElement(document, "P20000", postData.getLabel());
                    this.updateXmlElement(document, "P35", postData.getExtensionNo());
                    this.updateXmlElement(document, "P36", postData.getExtensionNo());
                    this.updateXmlElement(document, "P34", password);
                    this.updateXmlElement(document, "P3", postData.getExtensionNo());
                    this.updateXmlElement(document, "P40", String.valueOf(sipPort));
                    break;
                }
                case "2": {
                    this.updateXmlElement(document, "P401", ActiveAccount);
                    this.updateXmlElement(document, "P24083", profileNo);
                    this.updateXmlElement(document, "P20001", postData.getLabel());
                    this.updateXmlElement(document, "P735", postData.getExtensionNo());
                    this.updateXmlElement(document, "P736", postData.getExtensionNo());
                    this.updateXmlElement(document, "P734", password);
                    this.updateXmlElement(document, "P703", postData.getExtensionNo());
                    this.updateXmlElement(document, "P740", String.valueOf(sipPort));
                    break;
                }
                case "3": {
                    this.updateXmlElement(document, "P501", ActiveAccount);
                    this.updateXmlElement(document, "P24084", profileNo);
                    this.updateXmlElement(document, "P20002", postData.getLabel());
                    this.updateXmlElement(document, "P504", postData.getExtensionNo());
                    this.updateXmlElement(document, "P505", postData.getExtensionNo());
                    this.updateXmlElement(document, "P506", password);
                    this.updateXmlElement(document, "P507", postData.getExtensionNo());
                    this.updateXmlElement(document, "P513", String.valueOf(sipPort));
                    break;
                }
                case "4": {
                    this.updateXmlElement(document, "P601", ActiveAccount);
                    this.updateXmlElement(document, "P24085", profileNo);
                    this.updateXmlElement(document, "P20003", postData.getLabel());
                    this.updateXmlElement(document, "P604", postData.getExtensionNo());
                    this.updateXmlElement(document, "P605", postData.getExtensionNo());
                    this.updateXmlElement(document, "P606", password);
                    this.updateXmlElement(document, "P607", postData.getExtensionNo());
                    this.updateXmlElement(document, "P613", String.valueOf(sipPort));
                    break;
                }
                case "5": {
                    this.updateXmlElement(document, "P20360", ActiveAccount);
                    this.updateXmlElement(document, "P24086", profileNo);
                    this.updateXmlElement(document, "P20378", postData.getLabel());
                    this.updateXmlElement(document, "P1704", postData.getExtensionNo());
                    this.updateXmlElement(document, "P1705", postData.getExtensionNo());
                    this.updateXmlElement(document, "P1706", password);
                    this.updateXmlElement(document, "P1707", postData.getExtensionNo());
                    this.updateXmlElement(document, "P1713", String.valueOf(sipPort));
                    break;
                }
                case "6": {
                    this.updateXmlElement(document, "P20361", ActiveAccount);
                    this.updateXmlElement(document, "P24087", profileNo);
                    this.updateXmlElement(document, "P20379", postData.getLabel());
                    this.updateXmlElement(document, "P1804", postData.getExtensionNo());
                    this.updateXmlElement(document, "P1805", postData.getExtensionNo());
                    this.updateXmlElement(document, "P1806", password);
                    this.updateXmlElement(document, "P1807", postData.getExtensionNo());
                    this.updateXmlElement(document, "P1813", String.valueOf(sipPort));
                    break;
                }
                case "7": {
                    this.updateXmlElement(document, "P24090", ActiveAccount);
                    this.updateXmlElement(document, "P24088", profileNo);
                    this.updateXmlElement(document, "P24100", postData.getLabel());
                    this.updateXmlElement(document, "P24110", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24120", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24130", password);
                    this.updateXmlElement(document, "P24140", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24150", String.valueOf(sipPort));
                    break;
                }
                case "8": {
                    this.updateXmlElement(document, "P24091", ActiveAccount);
                    this.updateXmlElement(document, "P24089", profileNo);
                    this.updateXmlElement(document, "P24101", postData.getLabel());
                    this.updateXmlElement(document, "P24111", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24121", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24131", password);
                    this.updateXmlElement(document, "P24141", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24151", String.valueOf(sipPort));
                    break;
                }
                case "9": {
                    this.updateXmlElement(document, "P24092", ActiveAccount);
                    this.updateXmlElement(document, "P24720", profileNo);
                    this.updateXmlElement(document, "P24102", postData.getLabel());
                    this.updateXmlElement(document, "P24112", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24122", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24132", password);
                    this.updateXmlElement(document, "P24142", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24152", String.valueOf(sipPort));
                    break;
                }
                case "10": {
                    this.updateXmlElement(document, "P24093", ActiveAccount);
                    this.updateXmlElement(document, "P24721", profileNo);
                    this.updateXmlElement(document, "P24103", postData.getLabel());
                    this.updateXmlElement(document, "P24113", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24123", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24133", password);
                    this.updateXmlElement(document, "P24143", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24153", String.valueOf(sipPort));
                    break;
                }
                case "11": {
                    this.updateXmlElement(document, "P24094", ActiveAccount);
                    this.updateXmlElement(document, "P24722", profileNo);
                    this.updateXmlElement(document, "P24104", postData.getLabel());
                    this.updateXmlElement(document, "P24114", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24124", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24134", password);
                    this.updateXmlElement(document, "P24144", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24154", String.valueOf(sipPort));
                    break;
                }
                case "12": {
                    this.updateXmlElement(document, "P24095", ActiveAccount);
                    this.updateXmlElement(document, "P24723", profileNo);
                    this.updateXmlElement(document, "P24105", postData.getLabel());
                    this.updateXmlElement(document, "P24115", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24125", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24135", password);
                    this.updateXmlElement(document, "P24145", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24155", String.valueOf(sipPort));
                    break;
                }
                case "13": {
                    this.updateXmlElement(document, "P24096", ActiveAccount);
                    this.updateXmlElement(document, "P24724", profileNo);
                    this.updateXmlElement(document, "P24106", postData.getLabel());
                    this.updateXmlElement(document, "P24116", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24126", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24136", password);
                    this.updateXmlElement(document, "P24146", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24156", String.valueOf(sipPort));
                    break;
                }
                case "14": {
                    this.updateXmlElement(document, "P24097", ActiveAccount);
                    this.updateXmlElement(document, "P24725", profileNo);
                    this.updateXmlElement(document, "P24107", postData.getLabel());
                    this.updateXmlElement(document, "P24117", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24127", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24137", password);
                    this.updateXmlElement(document, "P24147", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24157", String.valueOf(sipPort));
                    break;
                }
                case "15": {
                    this.updateXmlElement(document, "P24098", ActiveAccount);
                    this.updateXmlElement(document, "P24726", profileNo);
                    this.updateXmlElement(document, "P24108", postData.getLabel());
                    this.updateXmlElement(document, "P24118", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24128", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24138", password);
                    this.updateXmlElement(document, "P24148", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24158", String.valueOf(sipPort));
                    break;
                }
                case "16": {
                    this.updateXmlElement(document, "P24099", ActiveAccount);
                    this.updateXmlElement(document, "P24727", profileNo);
                    this.updateXmlElement(document, "P24109", postData.getLabel());
                    this.updateXmlElement(document, "P24119", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24129", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24139", password);
                    this.updateXmlElement(document, "P24149", postData.getExtensionNo());
                    this.updateXmlElement(document, "P24159", String.valueOf(sipPort));
                    break;
                }
                default: {
                    logger.error("Invalid account number: " + accountNo);
                    return false;
                }
            }
            switch (profileNo) {
                case "1": {
                    this.updateXmlElement(document, "P747", this.getSipAndLDAPServerIP());
                    break;
                }
                case "2": {
                    this.updateXmlElement(document, "P502", this.getSipAndLDAPServerIP());
                    break;
                }
                case "3": {
                    this.updateXmlElement(document, "P602", this.getSipAndLDAPServerIP());
                    break;
                }
                case "4": {
                    this.updateXmlElement(document, "P20362", this.getSipAndLDAPServerIP());
                    break;
                }
                case "5": {
                    this.updateXmlElement(document, "P20363", this.getSipAndLDAPServerIP());
                    break;
                }
                default: {
                    this.updateXmlElement(document, "P47", this.getSipAndLDAPServerIP());
                }
            }
            try {
                if (audioEnableCodecList.isEmpty()) {
                    this.updateXmlElement(document, "P57", "0");
                    this.updateXmlElement(document, "P58", "8");
                    this.updateXmlElement(document, "P59", "120");
                    this.updateXmlElement(document, "P60", "255");
                    this.updateXmlElement(document, "P61", "255");
                    this.updateXmlElement(document, "P62", "255");
                } else {
                    this.updateXmlElement(document, "P57", "255");
                    this.updateXmlElement(document, "P58", "255");
                    this.updateXmlElement(document, "P59", "255");
                    this.updateXmlElement(document, "P60", "255");
                    this.updateXmlElement(document, "P61", "255");
                    this.updateXmlElement(document, "P62", "255");
                    int runner = 57;
                    for (Integer audioEnableCodec : audioEnableCodecList) {
                        this.updateXmlElement(document, "P" + String.valueOf(runner), String.valueOf(audioEnableCodec));
                        if (++runner <= 62) continue;
                        break;
                    }
                }
                this.updateXmlElement(document, "P25201", String.join((CharSequence)",", videoEnableCodecList) + ",");
                this.updateXmlElement(document, "P25207", String.join((CharSequence)",", videoDisableCodecList) + ",");
                logger.info("Codec info updated successfully for MAC: " + macAddress);
            }
            catch (Exception e) {
                logger.error("Error while updating codec info: " + e.getMessage(), (Throwable)e);
            }
            String IpAddress2 = "";
            String StaticIP = "0";
            try {
                List scadaAssetData = this.scadaAssetRepository.findByMacAddress(macAddress);
                if (!scadaAssetData.isEmpty()) {
                    SCADAAsset scadaAsset = (SCADAAsset)scadaAssetData.get(0);
                    IpAddress2 = scadaAsset.getIpAddress();
                    logger.info("SCADA asset device IP address found: {}", (Object)IpAddress2);
                } else {
                    logger.info("No SCADA asset found for MAC address: {}", (Object)macAddress);
                }
            }
            catch (Exception e) {
                logger.error("Error finding IP address in SCADA asset for MAC address: {}", (Object)macAddress, (Object)e);
            }
            if (IpAddress2 == null || IpAddress2.isEmpty() || !IpAddress2.contains(".")) {
                logger.error("Invalid or missing IP address for MAC: {}", (Object)macAddress);
            } else {
                StaticIP = "1";
                try {
                    String[] parts = IpAddress2.split("\\.");
                    if (parts.length != 4) {
                        logger.error("Invalid IP format: {}", (Object)IpAddress2);
                    }
                    String p1 = parts[0];
                    String p2 = parts[1];
                    String p3 = parts[2];
                    String p4 = parts[3];
                    String m1 = "255";
                    String m2 = "255";
                    String m3 = "255";
                    String m4 = "0";
                    String g1 = p1;
                    String g2 = p2;
                    String g3 = p3;
                    String g4 = "254";
                    this.updateXmlElement(document, "P9", p1);
                    this.updateXmlElement(document, "P10", p2);
                    this.updateXmlElement(document, "P11", p3);
                    this.updateXmlElement(document, "P12", p4);
                    this.updateXmlElement(document, "P13", m1);
                    this.updateXmlElement(document, "P14", m2);
                    this.updateXmlElement(document, "P15", m3);
                    this.updateXmlElement(document, "P16", m4);
                    this.updateXmlElement(document, "P17", g1);
                    this.updateXmlElement(document, "P18", g2);
                    this.updateXmlElement(document, "P19", g3);
                    this.updateXmlElement(document, "P20", g4);
                    this.updateXmlElement(document, "P8", StaticIP);
                }
                catch (Exception ex) {
                    logger.error("Error while processing IP address fields: {}", (Object)IpAddress2, (Object)ex);
                }
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Error updating and uploading configuration: " + e.getMessage());
            return false;
        }
    }

    public static boolean checkFilePresence(String fileName) {
        try {
            Path destinationPath = Paths.get(Constants.DEVICE_MANAGER_FILES_PATH, fileName);
            if (Files.exists(destinationPath, new LinkOption[0])) {
                return true;
            }
            Path sourcePath = Paths.get(Constants.DEVICE_MANAGER_FILES_PATH, Constants.DEVICE_MANAGER_TFTP_SAMPLE_FILE_NAME);
            if (!Files.exists(sourcePath, new LinkOption[0])) {
                logger.error("Sample file not found: " + sourcePath);
                return false;
            }
            Files.createDirectories(destinationPath.getParent(), new FileAttribute[0]);
            Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public RequestResponse updateSipExtensionSecond(String fileName, String macAddress, DeviceManagerConfigurationModel.Account data, Document document) {
        RequestResponse result = new RequestResponse();
        try {
            byte[] fileData;
            boolean updateSuccess;
            String filePath = Constants.DEVICE_MANAGER_FILES_PATH + File.separator + Constants.DEVICE_MANAGER_TFTP_SAMPLE_FILE_NAME;
            boolean fileExists = DeviceManagerService.checkFilePresence((String)fileName);
            if (fileExists) {
                filePath = Constants.DEVICE_MANAGER_FILES_PATH + File.separator + fileName;
            }
            if (updateSuccess = this.updatePortToFileSecond(filePath, fileData = this.readFileContent(filePath), data, fileName, macAddress, document)) {
                result.setStatus(0);
                result.setMessage("SIP extension updated successfully.");
            } else {
                result.setStatus(1);
                result.setMessage("Failed to update SIP extension.");
            }
        }
        catch (IOException e) {
            result.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.setMessage("Internal server error: Failed to read file. " + e.getMessage());
        }
        catch (Exception e) {
            result.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            result.setMessage("Internal server error: " + e.getMessage());
        }
        return result;
    }

    private void updateTag(Document document, String attrValue, String newValue) {
        NodeList allNodes = document.getElementsByTagName("*");
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Element element;
            Node node = allNodes.item(i);
            if (node.getNodeType() != 1 || !attrValue.equals((element = (Element)node).getAttribute("para"))) continue;
            element.setTextContent(newValue);
            return;
        }
    }

    private void updateLineData(Document document, List<DeviceManagerConfigurationModel.Blf> blfList) {
        for (DeviceManagerConfigurationModel.Blf blf : blfList) {
            int lineIndex = blf.getKey();
            String base = "LineKey" + lineIndex;
            this.updateTag(document, base + "_Type", blf.getType());
            this.updateTag(document, base + "_Mode", blf.getMode());
            this.updateTag(document, base + "_Value", blf.getValue() != null ? blf.getValue() : "");
            this.updateTag(document, base + "_Label", blf.getLabel() != null ? blf.getLabel() : "");
            this.updateTag(document, base + "_Account", String.valueOf(blf.getAccount() - 1));
            this.updateTag(document, base + "_Extension", blf.getExtension() != null ? blf.getExtension() : "");
        }
    }

    public String getSipAndLDAPServerIP() {
        return this.SipAndLDAPServerIP != null ? this.SipAndLDAPServerIP : "";
    }

    public void setSipAndLDAPServerIP(String SipAndLDAPServerIP) {
        this.SipAndLDAPServerIP = SipAndLDAPServerIP;
    }

    public RequestResponse updateConfiguration(String macAddress, DeviceManagerConfigurationModel data) {
        RequestResponse result;
        block44: {
            result = new RequestResponse();
            String fileName = "cfg" + macAddress + ".xml";
            String filePath = Constants.DEVICE_MANAGER_FILES_PATH + File.separator + fileName;
            logger.info("Device manager path and fileName {}" + filePath + Constants.DEVICE_MANAGER_TFTP_SAMPLE_FILE_NAME);
            try {
                if (macAddress == null || macAddress.trim().isEmpty()) {
                    result.setStatus(-1);
                    result.setMessage("MAC Address is missing.");
                    return result;
                }
                File file = new File(filePath);
                boolean fileExists = false;
                if (!file.exists()) {
                    fileExists = DeviceManagerService.checkFilePresence((String)fileName);
                }
                if (!fileExists && !file.exists()) {
                    result.setStatus(-1);
                    result.setMessage("Config file not found.");
                    result.setMessageDetail("Configuration file and sample file both not found: " + filePath);
                    return result;
                }
                byte[] fileData = Files.readAllBytes(Paths.get(filePath, new String[0]));
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(new ByteArrayInputStream(fileData));
                document.getDocumentElement().normalize();
                try {
                    List accounts = data.getAccount();
                    if (accounts == null || accounts.isEmpty()) {
                        throw new IllegalArgumentException("Missing SIP account data");
                    }
                    boolean allSuccess = true;
                    for (DeviceManagerConfigurationModel.Account acc : accounts) {
                        RequestResponse resp = this.updateSipExtensionSecond(fileName, macAddress, acc, document);
                        if (resp.getStatus() == 0) continue;
                        allSuccess = false;
                    }
                    if (!allSuccess) {
                        result.setStatus(-1);
                        result.setMessage("Some SIP extension updates and account delete both failed.");
                    } else {
                        result.setStatus(1);
                        result.setMessage("SIP extensions updated and accounts delete both successfully.");
                    }
                }
                catch (Exception e) {
                    logger.error("ACCOUNT update failed: {}", (Object)e.getMessage());
                    result.setStatus(-1);
                    result.setMessage("Account update failed.");
                    result.setMessageDetail(e.getMessage());
                }
                try {
                    if (data.getBlf() != null) {
                        this.updateLineData(document, data.getBlf());
                    }
                }
                catch (Exception e) {
                    logger.error("BLF update failed: {}", (Object)e.getMessage());
                    result.setMessageDetail("BLF update failed: " + e.getMessage());
                }
                try {
                    String nameFilter = Constants.LDAP_NAME_FILTER;
                    String numberFilter = Constants.LDAP_NUMBER_FILTER;
                    int tlsMode = Constants.LDAP_TLS_MODE;
                    int port = Constants.LDAP_PORT;
                    String base = Constants.LDAP_BASE_DN;
                    String userName = Constants.LDAP_USER_NAME;
                    String password = Constants.LDAP_PASSWORD;
                    int maxHits = Constants.LDAP_MAX_HITS;
                    String nameAttributes = Constants.LDAP_NAME_ATTRIBUTES;
                    String numberAttributes = Constants.LDAP_NUMBER_ATTRIBUTES;
                    String displayName = Constants.LDAP_DISPLAY_NAME;
                    int searchDelay = Constants.LDAP_SEARCH_DELAY;
                    int protocol = Constants.LDAP_PROTOCOL;
                    boolean lookupForIncomingCall = Constants.LDAP_LOOKUP_FOR_INCOMING_CALL;
                    int sortingResults = Constants.LDAP_SORTING_RESULTS;
                    boolean lookupForDial = Constants.LDAP_LOOKUP_FOR_DIAL;
                    String syncTime = Constants.LDAP_SYNC_TIME;
                    String ldapGroupAttribute = Constants.LDAP_GROUP_ATTRIBUTE;
                    int ldapDisplayMode = Constants.LDAP_DISPLAY_MODE;
                    if (StringUtils.hasText((String)Constants.TR069_SERVER_IP)) {
                        String ipServer = Constants.TR069_SERVER_IP.split(":")[0];
                        String acsUrl = "http://" + ipServer + ":7547";
                        this.updateXmlElement(document, "P8101", acsUrl);
                    } else {
                        String acsUrl = "http://127.0.0.1:7547";
                        this.updateXmlElement(document, "P8101", acsUrl);
                    }
                    if (nameFilter != null && !nameFilter.isEmpty()) {
                        this.updateXmlElement(document, "P5430", nameFilter);
                    }
                    if (numberFilter != null && !numberFilter.isEmpty()) {
                        this.updateXmlElement(document, "P5431", numberFilter);
                    }
                    if (tlsMode >= 0) {
                        this.updateXmlElement(document, "P24916", String.valueOf(tlsMode));
                    }
                    if (this.getSipAndLDAPServerIP() != null) {
                        this.updateXmlElement(document, "P5432", this.getSipAndLDAPServerIP());
                    }
                    if (port > 0) {
                        this.updateXmlElement(document, "P5433", String.valueOf(port));
                    }
                    if (base != null && !base.isEmpty()) {
                        this.updateXmlElement(document, "P5434", base);
                    }
                    if (userName != null && !userName.isEmpty()) {
                        this.updateXmlElement(document, "P5435", userName);
                    }
                    if (password != null && !password.isEmpty()) {
                        this.updateXmlElement(document, "P5436", password);
                    }
                    if (maxHits > 0) {
                        this.updateXmlElement(document, "P5437", String.valueOf(maxHits));
                    }
                    if (nameAttributes != null && !nameAttributes.isEmpty()) {
                        this.updateXmlElement(document, "P23136", nameAttributes);
                    }
                    if (numberAttributes != null && !numberAttributes.isEmpty()) {
                        this.updateXmlElement(document, "P23137", numberAttributes);
                    }
                    if (displayName != null && !displayName.isEmpty()) {
                        this.updateXmlElement(document, "P5440", displayName);
                    }
                    if (searchDelay >= 0) {
                        this.updateXmlElement(document, "P5442", String.valueOf(searchDelay));
                    }
                    if (protocol >= 0) {
                        this.updateXmlElement(document, "P5441", String.valueOf(protocol));
                    }
                    this.updateXmlElement(document, "P5443", lookupForIncomingCall ? "1" : "0");
                    this.updateXmlElement(document, "P5444", String.valueOf(sortingResults));
                    this.updateXmlElement(document, "P5445", lookupForDial ? "1" : "0");
                    if (syncTime != null && !syncTime.isEmpty()) {
                        this.updateXmlElement(document, "P20990", syncTime);
                    }
                    if (ldapGroupAttribute != null && !ldapGroupAttribute.isEmpty()) {
                        this.updateXmlElement(document, "P25254", ldapGroupAttribute);
                    }
                    if (ldapDisplayMode >= 0) {
                        this.updateXmlElement(document, "P25255", String.valueOf(ldapDisplayMode));
                    }
                }
                catch (Exception e) {
                    logger.error("LDAP update failed: {}", (Object)e.getMessage());
                    result.setMessageDetail("LDAP update failed: " + e.getMessage());
                }
                try {
                    String recordingAccountNo = Constants.RECORDING_ACCOUNT_NO;
                    String recordingUserID = Constants.RECORDING_USER_ID;
                    Boolean status = Constants.RECORDING_ENABLE;
                    if (status.booleanValue() && recordingUserID != null && recordingAccountNo != null) {
                        this.updateXmlElement(document, "P25098", "1223");
                        this.updateXmlElement(document, "P24998", recordingAccountNo);
                        this.updateXmlElement(document, "P24999", recordingUserID);
                    } else {
                        this.updateXmlElement(document, "P25098", "0");
                        this.updateXmlElement(document, "P24998", "0");
                        this.updateXmlElement(document, "P24999", "NA");
                    }
                }
                catch (Exception e) {
                    logger.error("Recording update failed: {}", (Object)e.getMessage());
                    result.setMessageDetail("Recording update failed: " + e.getMessage());
                }
                Transformer tempTransformer = TransformerFactory.newInstance().newTransformer();
                tempTransformer.setOutputProperty("omit-xml-declaration", "yes");
                ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
                tempTransformer.transform(new DOMSource(document), new StreamResult(tempOut));
                String updatedXml = tempOut.toString(StandardCharsets.UTF_8.name());
                byte[] updatedData = updatedXml.getBytes(StandardCharsets.UTF_8);
                DeviceManagerService.updateFileIfDifferent((String)fileName, (byte[])updatedData);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "no");
                transformer.transform(new DOMSource(document), new StreamResult(outputStream));
                byte[] updatedFileData = outputStream.toByteArray();
                Files.write(Paths.get(filePath, new String[0]), updatedFileData, new OpenOption[0]);
                logger.info("Updated XML saved to: {}", (Object)filePath);
                RequestResponse uploadResponse = this.methodOfUploadConfig(fileName, updatedData, macAddress);
                RequestResponse applyResponse = this.update(macAddress, "configuration");
                if (uploadResponse.getStatus() == 0 && applyResponse.getStatus() == 0) {
                    logger.info("Successfully configuration file pushed to device: {}", (Object)macAddress);
                    result.setStatus(0);
                    result.setMessage("Successfully File updated and File configuration pushed to device passed.");
                    result.setMessageDetail("Upload Status: " + uploadResponse.getStatus() + ", File push to phone Status: " + applyResponse.getStatus());
                } else {
                    logger.info("File configuration pushed to device failed: {}", (Object)macAddress);
                    result.setStatus(-1);
                    result.setMessage("File updated but File configuration pushed to device failed.");
                    result.setMessageDetail("Upload Status: " + uploadResponse.getStatus() + ", File push to phone Status: " + applyResponse.getStatus());
                }
                try {
                    List scadaAssetData = this.scadaAssetRepository.findByMacAddress(macAddress);
                    if (!scadaAssetData.isEmpty()) {
                        SCADAAsset scadaAsset = (SCADAAsset)scadaAssetData.get(0);
                        scadaAsset.setDeviceDetailsProvisioning(data.toString());
                        this.scadaAssetRepository.save((Object)scadaAsset);
                        logger.info("SCADA asset device details saved: {}", (Object)macAddress);
                        break block44;
                    }
                    logger.info("No SCADA asset found for MAC address: {}", (Object)macAddress);
                }
                catch (Exception e) {
                    logger.error("Error saving SCADA asset device details for MAC address: {}", (Object)macAddress, (Object)e);
                }
            }
            catch (Exception e) {
                logger.error("ERROR in updateConfiguration: {}", (Object)e.getMessage());
                result.setStatus(-1);
                result.setMessage("Exception occurred while updating configuration.");
                result.setMessageDetail(e.getMessage());
            }
        }
        return result;
    }

    public RequestResponse getConfiguration(String macAddress) {
        RequestResponse response = new RequestResponse();
        try {
            if (macAddress == null || macAddress.trim().isEmpty()) {
                response.setStatus(-1);
                response.setMessage("MAC Address is missing.");
                return response;
            }
            List data = this.scadaAssetRepository.findByMacAddress(macAddress);
            if (data != null) {
                response.setStatus(0);
                response.setMessage("Configuration fetched successfully.");
                response.setData((Object)data);
            } else {
                response.setStatus(-1);
                response.setMessage("No configuration found for this MAC Address.");
            }
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setMessage("Unexpected error while fetching configuration.");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }
}

