/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.chat.entity.ChatMessageV2;
import com.coraltele.telemetry.db.telemetry.chat.entity.Conversation;
import com.coraltele.telemetry.db.telemetry.chat.entity.ConversationParticipant;
import com.coraltele.telemetry.db.telemetry.chat.repository.ChatMessageRepositoryV2;
import com.coraltele.telemetry.db.telemetry.chat.repository.ConversationParticipantRepository;
import com.coraltele.telemetry.db.telemetry.chat.repository.ConversationRepository;
import com.coraltele.telemetry.db.telephony.main.entity.McxParticipant;
import com.coraltele.telemetry.db.telephony.main.repository.McxParticipantRepository;
import com.coraltele.telemetry.db.telephony.pbx.entity.Extension;
import com.coraltele.telemetry.db.telephony.repository.ExtensionRepository;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.entity.UserDepartment;
import com.coraltele.telemetry.db.users.main.repository.UserDepartmentRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.helper.HttpUtils;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.ChatModel;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChatServiceV2 {
    private static final Logger logger = LogManager.getLogger(ChatServiceV2.class);
    @Autowired
    private ConversationRepository conversationRepository;
    @Autowired
    private ConversationParticipantRepository participantRepository;
    @Autowired
    private ChatMessageRepositoryV2 messageRepository;
    @Autowired
    private McxParticipantRepository mcxParticipantRepository;
    @Autowired
    private ExtensionRepository extensionRepository;
    @Autowired
    private UserDepartmentRepository userDepartmentRepository;
    @Autowired
    private UserRepository userRepository;

    @Transactional(transactionManager="telemetryTransactionManager")
    public RequestResponse sendMessage(ChatModel.SendMessageRequest req) {
        ChatModel.VideoStreamStatus status;
        String conversationKey;
        RequestResponse rr = new RequestResponse();
        String string = conversationKey = req.getKind().equalsIgnoreCase("D") ? this.dmName(req.getSender(), req.getTarget()) : req.getTarget();
        if (req.getReferenceId() == null) {
            req.setReferenceId(Long.valueOf(0L));
        }
        if (req.getReferenceUUID() == null) {
            req.setReferenceUUID("");
        }
        Conversation conversation = this.conversationRepository.findByDirectKey(conversationKey).orElseGet(() -> {
            Conversation c = Conversation.builder().type(req.getKind()).name(conversationKey).directKey(conversationKey).open(true).createdAt(LocalDateTime.now()).createdBy(req.getSender()).lastMessageSequence(Long.valueOf(0L)).build();
            return (Conversation)this.conversationRepository.save((Object)c);
        });
        long nextSeq = Optional.ofNullable(conversation.getLastMessageSequence()).orElse(0L) + 1L;
        conversation.setLastMessageSequence(Long.valueOf(nextSeq));
        conversation.setLastMessageAt(LocalDateTime.now());
        this.conversationRepository.save((Object)conversation);
        ChatMessageV2 saved = (ChatMessageV2)this.messageRepository.save((Object)ChatMessageV2.builder().conversationId(conversation.getId()).sequence(Long.valueOf(nextSeq)).sender(req.getSender()).receiver(req.getTarget()).createdAt(LocalDateTime.now()).content(req.getContent()).messageType(req.getMessageType()).referenceId(req.getReferenceId()).referenceUUID(req.getReferenceUUID()).build());
        rr.setMessage("OK");
        rr.setData((Object)saved);
        ChatModel.OutboundMessage outbound = new ChatModel.OutboundMessage();
        outbound.setMessageId(String.valueOf(saved.getId()));
        outbound.setMessageType(saved.getMessageType());
        if (req.getKind().equalsIgnoreCase("D")) {
            outbound.setRecipients(new String[]{req.getTarget()});
        } else {
            List mcxParticipants = this.mcxParticipantRepository.findByJoinConference(req.getTarget());
            List<String> pNos = mcxParticipants.stream().map(McxParticipant::getParticipantNo).collect(Collectors.toList());
            Optional destinationExtension = this.extensionRepository.findByExtension(req.getTarget());
            if (destinationExtension.isPresent()) {
                List exts = this.extensionRepository.findByDepartment(((Extension)destinationExtension.get()).getDepartment());
                for (Extension ext : exts) {
                    if (pNos.contains(ext.getExtension())) continue;
                    pNos.add(ext.getExtension());
                }
                List deptUsers = this.userDepartmentRepository.findByDepartment(((Extension)destinationExtension.get()).getDepartment());
                for (UserDepartment ud : deptUsers) {
                    User user;
                    Optional userOpt = this.userRepository.findByUsername(ud.getUsername());
                    if (!userOpt.isPresent() || (user = (User)userOpt.get()).getContactNo() == null || user.getContactNo().isEmpty() || pNos.contains(user.getContactNo())) continue;
                    pNos.add(user.getContactNo());
                }
            }
            outbound.setRecipients(pNos.toArray(new String[0]));
        }
        outbound.setMessage(saved.toString());
        outbound.setMessageSentBy(saved.getSender());
        HttpUtils.sendTextMessage((ChatModel.OutboundMessage)outbound);
        if (req.getMessageType().equalsIgnoreCase("PlayPublishVideo")) {
            logger.info("Publishing video for conference {} stream {}", (Object)req.getTarget(), (Object)req.getContent());
            status = new ChatModel.VideoStreamStatus();
            status.setConferenceNo(req.getTarget());
            status.setStreamId(req.getContent());
            status.setVideoStreamBy(req.getSender());
            status.setStatus("Started");
            HttpUtils.sendStreamStatus((ChatModel.VideoStreamStatus)status);
        } else if (req.getMessageType().equalsIgnoreCase("StopPublishVideo")) {
            logger.info("Stopping video for conference {}", (Object)req.getTarget());
            status = new ChatModel.VideoStreamStatus();
            status.setConferenceNo(req.getTarget());
            status.setStreamId("");
            status.setVideoStreamBy("");
            status.setStatus("Stopped");
            HttpUtils.sendStreamStatus((ChatModel.VideoStreamStatus)status);
        }
        return rr;
    }

    public RequestResponse listMessages(ChatModel.ReadUptoRequest req) {
        RequestResponse rr = new RequestResponse();
        String conversationKey = req.getKind().equalsIgnoreCase("D") ? this.dmName(req.getSender(), req.getTarget()) : req.getTarget();
        Optional conversation = this.conversationRepository.findByDirectKey(conversationKey);
        if (conversation.isPresent()) {
            Conversation currentConversation = (Conversation)conversation.get();
            List msgs = req.getUptoSequence() == null || req.getUptoSequence() < 0L ? this.messageRepository.findByConversationIdOrderBySequenceAsc(currentConversation.getId()) : this.messageRepository.findByConversationIdAndSequenceGreaterThanOrderBySequenceAsc(currentConversation.getId(), req.getUptoSequence());
            rr.setMessage("OK");
            rr.setData((Object)msgs);
            return rr;
        }
        rr.setStatus(1);
        rr.setMessage("Conversation not found");
        rr.setData(null);
        return rr;
    }

    @Transactional(transactionManager="telemetryTransactionManager")
    public RequestResponse markRead(ChatModel.ReadUptoRequest req) {
        RequestResponse rr = new RequestResponse();
        String conversationKey = req.getKind().equalsIgnoreCase("D") ? this.dmName(req.getSender(), req.getTarget()) : req.getTarget();
        Optional conversation = this.conversationRepository.findByDirectKey(conversationKey);
        if (conversation.isPresent()) {
            Conversation currentConversation = (Conversation)conversation.get();
            ConversationParticipant p = this.participantRepository.findByConversationIdAndUsername(currentConversation.getId(), req.getSender()).orElseGet(() -> (ConversationParticipant)this.participantRepository.save((Object)ConversationParticipant.builder().conversationId(currentConversation.getId()).username(req.getSender()).lastReadSequence(Long.valueOf(0L)).joinedAt(LocalDateTime.now()).build()));
            long newSeq = Math.max(p.getLastReadSequence() == null ? 0L : p.getLastReadSequence(), Optional.ofNullable(req.getUptoSequence()).orElse(0L));
            p.setLastReadSequence(Long.valueOf(newSeq));
            this.participantRepository.save((Object)p);
            rr.setMessage("OK");
            rr.setData((Object)newSeq);
        } else {
            rr.setStatus(1);
            rr.setMessage("Conversation not found");
        }
        return rr;
    }

    private String dmName(String sender, String receiver) {
        String b;
        if (sender == null || receiver == null) {
            throw new IllegalArgumentException("params must not be null");
        }
        String a = sender.trim().toLowerCase();
        return a.compareTo(b = receiver.trim().toLowerCase()) <= 0 ? a + "-" + b : b + "-" + a;
    }
}

