/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.AlertWithAssetDataModel;
import com.coraltele.telemetry.model.ImsiWithAssetDataModel;
import com.coraltele.telemetry.service.coralnms.imsi.service.IMSIService;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/sync"})
public class ReceiveDataOnCentralNmsController {
    private static final Logger logger = LogManager.getLogger(ReceiveDataOnCentralNmsController.class);
    @Autowired
    private SCADAAssetService scadaAssetService;
    @Autowired
    private IMSIService imsiService;

    @PostMapping(value={"/scada"})
    public ResponseEntity<RequestResponse> receivedSCADAAsset(@RequestBody AlertWithAssetDataModel alertData) {
        logger.info("Received alert data from client: {}", (Object)alertData);
        RequestResponse response = this.scadaAssetService.saveReceivedSCADAAsset(alertData);
        if (response.getStatus() == 0) {
            return new ResponseEntity((Object)response, HttpStatus.OK);
        }
        return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @PostMapping(value={"/imsi"})
    public ResponseEntity<RequestResponse> receiveImsiData(@RequestBody ImsiWithAssetDataModel imsiData) {
        logger.info("Received IMSI data from client: {}", (Object)imsiData);
        RequestResponse response = this.imsiService.createReceivedImsiData(imsiData);
        if (response.getStatus() == 0) {
            return ResponseEntity.ok((Object)response);
        }
        return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }
}

