/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.ChatServiceV2;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.ChatModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/chat"})
public class ChatControllerV2 {
    @Autowired
    private ChatServiceV2 chatService;

    @PostMapping(value={"/message"})
    public ResponseEntity<RequestResponse> sendMessage(@RequestBody ChatModel.SendMessageRequest req) {
        RequestResponse rr = this.chatService.sendMessage(req);
        return rr.getStatus() == 0 ? ResponseEntity.ok((Object)rr) : new ResponseEntity((Object)rr, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/messages"})
    public ResponseEntity<RequestResponse> listMessages(@RequestBody ChatModel.ReadUptoRequest req) {
        RequestResponse rr = this.chatService.listMessages(req);
        return rr.getStatus() == 0 ? ResponseEntity.ok((Object)rr) : new ResponseEntity((Object)rr, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/read"})
    public ResponseEntity<RequestResponse> markRead(@RequestBody ChatModel.ReadUptoRequest req) {
        RequestResponse rr = this.chatService.markRead(req);
        return rr.getStatus() == 0 ? ResponseEntity.ok((Object)rr) : new ResponseEntity((Object)rr, HttpStatus.BAD_REQUEST);
    }
}

