DO $$
BEGIN
    IF EXISTS (
        SELECT 1
        FROM information_schema.tables
        WHERE table_schema = 'coralnms'
          AND table_name   = 'widget'
    ) THEN
        update coralnms.widget set export = false where export is null;

        delete from coralnms.widget where code is null;

        WITH dups AS (
            SELECT code
            FROM coralnms.widget
            GROUP BY code
            HAVING COUNT(*) > 1
        )
        DELETE FROM coralnms.widget w
        USING dups d
        WHERE w.code = d.code;

    END IF;
END$$;