/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.fileUpload.service;

import com.coraltele.telemetry.db.telemetry.main.entity.FileUpload;
import com.coraltele.telemetry.db.telemetry.main.entity.FileUploadHistory;
import com.coraltele.telemetry.db.telemetry.main.repository.FileUploadHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.FileUploadRepository;
import com.coraltele.telemetry.db.telemetry.main.specification.FileUploadSpecification;
import com.coraltele.telemetry.db.users.main.entity.UserGroup;
import com.coraltele.telemetry.db.users.main.repository.UserGroupRepository;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.helper.DateFormatUtility;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.model.SearchResponse;
import com.coraltele.telemetry.service.main.fileUpload.model.FileStatusModel;
import com.coraltele.telemetry.service.main.fileUpload.model.FileUploadModel;
import com.coraltele.telemetry.service.pbx.ExtensionService;
import com.coraltele.telemetry.service.user.service.UserService;
import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FileUploadService {
    private static final Logger logger = LogManager.getLogger(FileUploadService.class);
    @Autowired
    FileUploadRepository fileUploadRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    ExtensionService extensionService;
    @Autowired
    FileUploadHistoryRepository fileUploadHistoryRepository;

    public String getFileExtension(String fileName) {
        return fileName != null && fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(46)).toLowerCase() : "";
    }

    public String determineFileType(String fileExtension) {
        switch (fileExtension) {
            case ".mp3": 
            case ".wav": 
            case ".aac": 
            case ".flac": 
            case ".ogg": 
            case ".wma": 
            case ".m4a": 
            case ".aiff": 
            case ".amr": 
            case ".pcm": 
            case ".alac": 
            case ".dsd": 
            case ".ape": 
            case ".ra": 
            case ".au": 
            case ".mka": 
            case ".mid": {
                return "audio";
            }
            case ".mp4": 
            case ".avi": 
            case ".mkv": 
            case ".mov": 
            case ".wmv": 
            case ".flv": 
            case ".webm": 
            case ".mpeg": 
            case ".3gp": 
            case ".m4v": 
            case ".mpg": 
            case ".asf": 
            case ".rm": 
            case ".swf": 
            case ".vob": 
            case ".ts": 
            case ".f4v": 
            case ".mts": 
            case ".m2ts": 
            case ".divx": {
                return "video";
            }
            case ".jpg": 
            case ".jpeg": 
            case ".png": 
            case ".gif": 
            case ".bmp": 
            case ".tiff": 
            case ".svg": 
            case ".webp": 
            case ".ico": 
            case ".heic": 
            case ".psd": 
            case ".eps": 
            case ".raw": 
            case ".cr2": 
            case ".nef": 
            case ".orf": 
            case ".arw": 
            case ".dng": 
            case ".ai": {
                return "image";
            }
        }
        return "others";
    }

    public RequestResponse getAllFileUploads(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = FileUploadSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "name" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.fileUploadRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.fileUploadRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<FileUploadModel> entityToModelConversion(List<FileUpload> FileUploads) {
        ArrayList<FileUploadModel> addValue = new ArrayList<FileUploadModel>();
        for (FileUpload row : FileUploads) {
            FileUploadModel data = new FileUploadModel();
            data.setId(row.getId());
            data.setCreatedBy(row.getCreatedBy());
            data.setCreatedOn(this.dateFormatUtility.epochToLocalDateTime(row.getCreatedOn()));
            data.setFileDescription(row.getFileDescription());
            data.setFilePath(row.getFilePath());
            data.setFileType(row.getFileType());
            data.setGroupId(row.getGroupId());
            data.setDesignation(this.extensionService.getDesignationByUsername(row.getCreatedBy()));
            data.setUpdatedBy(row.getUpdatedBy());
            addValue.add(data);
        }
        return addValue;
    }

    public Long getGroupId(String username) {
        return this.userRepository.findByUsername(username).map(user -> {
            List list = this.userGroupRepository.findByUsers(Long.valueOf(user.getId()));
            return list.isEmpty() ? null : ((UserGroup)list.get(0)).getGroup();
        }).orElse(null);
    }

    public String getFilePath(Integer id) {
        Optional list = this.fileUploadRepository.findById((Object)id);
        if (list.isPresent()) {
            return ((FileUpload)list.get()).getFilePath();
        }
        return "Id doesn't exist";
    }

    public RequestResponse getAll(Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            String extension = this.userService.getContactNumber(principal.getName());
            if (StringUtils.hasText((String)extension)) {
                String department = this.extensionService.getDepartment(extension);
                List list = this.fileUploadRepository.findByGroupIdOrUserId(department, principal.getName());
                ArrayList<FileUploadModel> addValue = new ArrayList<FileUploadModel>();
                for (FileUpload row : list) {
                    if (this.isFileDelete(principal.getName(), row.getId())) continue;
                    FileUploadModel data = new FileUploadModel();
                    data.setId(row.getId());
                    data.setCreatedBy(row.getCreatedBy());
                    data.setCreatedOn(this.dateFormatUtility.epochToLocalDateTime(row.getCreatedOn()));
                    data.setFileDescription(row.getFileDescription());
                    data.setFilePath(row.getFilePath());
                    data.setFileType(row.getFileType());
                    data.setGroupId(row.getGroupId());
                    data.setDesignation(this.extensionService.getDesignationByUsername(row.getCreatedBy()));
                    data.setUpdatedBy(row.getUpdatedBy());
                    data.setFileName(data.getDesignation() + "." + data.getCreatedOn());
                    addValue.add(data);
                }
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setData(addValue);
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(0);
                returnValue.setMessage("Please set the extension of user");
                returnValue.setMessageDetail("user-profile contact not saved");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            returnValue.setStatus(-1);
            returnValue.setMessage("Contact to Administrator");
            returnValue.setMessageDetail("Something went wrong");
        }
        return returnValue;
    }

    public RequestResponse createFileHistory(FileStatusModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional getData = this.fileUploadHistoryRepository.findByUsernameAndFileId(principal.getName(), data.getFileId());
            if (getData.isPresent()) {
                ((FileUploadHistory)getData.get()).setDeleteByUser(data.getDeleteByUser());
                ((FileUploadHistory)getData.get()).setDownloadByUser(data.getDownloadByUser());
                ((FileUploadHistory)getData.get()).setReadByUser(data.getReadByUser());
                ((FileUploadHistory)getData.get()).setUsername(principal.getName());
                ((FileUploadHistory)getData.get()).setUpdatedBy(principal.getName());
                ((FileUploadHistory)getData.get()).setUpdatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                this.fileUploadHistoryRepository.save(getData.get());
                logger.info("data create for user:{} and fileName is:{}", (Object)principal.getName(), (Object)this.getFileName(data.getFileId()));
                returnValue.setStatus(0);
                returnValue.setMessage("Data update successfully");
                returnValue.setMessageDetail("data create for user:" + principal.getName() + "and fileName is:" + this.getFileName(data.getFileId()));
            } else {
                FileUploadHistory record = new FileUploadHistory();
                record.setCreatedBy(principal.getName());
                record.setUsername(principal.getName());
                record.setCreatedOn(Long.valueOf(Instant.now().getEpochSecond()));
                record.setDeleteByUser(data.getDeleteByUser());
                record.setReadByUser(data.getReadByUser());
                record.setDownloadByUser(data.getDownloadByUser());
                record.setDepartment(data.getDepartment());
                record.setFileId(data.getFileId());
                this.fileUploadHistoryRepository.save((Object)record);
                logger.info("data update for user:{} and fileName is:{}", (Object)principal.getName(), (Object)this.getFileName(data.getFileId()));
                returnValue.setStatus(0);
                returnValue.setMessage("Data update successfully");
                returnValue.setMessageDetail("data update for user:" + principal.getName() + "and fileName is:" + this.getFileName(data.getFileId()));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            returnValue.setStatus(-1);
            returnValue.setMessage("Unable to update data");
            returnValue.setMessageDetail("Contact to Administrator");
        }
        return returnValue;
    }

    public String getFileName(Integer id) {
        Optional data = this.fileUploadRepository.findById((Object)id);
        if (data.isPresent()) {
            return ((FileUpload)data.get()).getFileName();
        }
        return "";
    }

    public boolean isFileDelete(String username, Integer fileId) {
        Optional getData = this.fileUploadHistoryRepository.findByUsernameAndFileId(username, fileId);
        return getData.isPresent() && ((FileUploadHistory)getData.get()).getDeleteByUser() != false;
    }
}

