/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.helper.Constants;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SendEmail {
    public String respObjectConf = "";
    public String respObjectNms = "";
    public String mailFrom = "";
    public String subject = "";
    public String mailBody = "";
    public String mailTo = "";
    public String smtpHost = "";
    public String smtpPort = "";
    public String smtAuth = "";
    public String smtpSSL = "";
    public String smtpProtocol = "";
    public String smtpUserName = "";
    public String smtpPassword = "";
    private Boolean confFetched = null;
    @Autowired
    private final RestTemplate restTemplate;
    private static final Logger logger = LogManager.getLogger(SendEmail.class);

    public SendEmail(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public boolean sendMail(String mailTo, String mailFrom, String mailBody, String subject) {
        boolean isSent = false;
        if (Boolean.TRUE.equals(this.confFetched)) {
            try {
                String username = this.smtpUserName;
                String password = this.smtpPassword;
                Properties props = new Properties();
                props.put("mail.smtp.host", this.smtpHost);
                props.put("mail.smtp.port", this.smtpPort);
                props.put("mail.smtp.auth", this.smtAuth);
                props.put("mail.smtp.ssl.enable", this.smtpSSL);
                props.put("mail.smtp.ssl.protocols", this.smtpProtocol);
                Session session = Session.getInstance((Properties)props, (Authenticator)new /* Unavailable Anonymous Inner Class!! */);
                try {
                    MimeMessage message = new MimeMessage(session);
                    message.setFrom((Address)new InternetAddress(mailFrom));
                    message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)mailTo));
                    message.setSubject(subject);
                    message.setText(mailBody);
                    Transport.send((Message)message);
                    logger.info("send mail successfully {}", (Object)message);
                }
                catch (MessagingException e) {
                    logger.error("Error while sending email: {}", (Object)e.getMessage());
                }
                isSent = true;
                return isSent;
            }
            catch (Exception e) {
                logger.error("Email failed due to reason: {}", (Object)e.getMessage());
            }
        } else {
            logger.error("Configuration not fetched, unable to send mail");
        }
        return isSent;
    }

    @PostConstruct
    public void onService() throws JsonMappingException, JsonProcessingException {
        try {
            String restURLConf = "http://127.0.0.1/services/api/v2/callServerManagerFile/emailList/conf";
            String restUrlNms = "https://127.0.0.1/services/api/v2/callServerManagerFile/emailList/NMS";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseConf = this.restTemplate.exchange(restURLConf, HttpMethod.GET, entity, String.class, new Object[0]);
            ResponseEntity responseNms = this.restTemplate.exchange(restUrlNms, HttpMethod.GET, entity, String.class, new Object[0]);
            this.respObjectConf = (String)responseConf.getBody();
            this.respObjectNms = (String)responseNms.getBody();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNodeConf = objectMapper.readTree(this.respObjectConf);
            JsonNode jsonNodeNms = objectMapper.readTree(this.respObjectNms);
            JsonNode dataConf = jsonNodeConf.get("data").get(0);
            JsonNode dataNms = jsonNodeNms.get("data").get(0);
            this.mailFrom = dataConf.get("mailFrom").asText();
            this.subject = dataNms.get("subject").asText();
            this.mailBody = dataNms.get("emailBody").asText();
            this.mailTo = dataConf.get("mailUsername").asText();
            this.smtpHost = dataConf.get("mailServer").asText();
            this.smtpPort = dataConf.get("mailPort").asText();
            this.smtpProtocol = dataConf.get("mailProtocol").asText();
            this.smtAuth = dataConf.get("mailSmtPAuth").asText();
            this.smtpSSL = dataConf.get("mailTTls").asText();
            this.smtpPassword = dataConf.get("mailPassword").asText();
            this.smtpUserName = dataConf.get("mailUsername").asText();
            logger.info("the result is {}", (Object)this.mailTo);
            this.confFetched = true;
        }
        catch (Exception E) {
            logger.error("Unable to fetch mail configuration for NMS", (Object)E.getMessage());
            this.confFetched = false;
        }
    }
}

