/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telephony.pbx.service;

import com.coraltele.telemetry.db.telephony.pbx.entity.SmsDetails;
import com.coraltele.telemetry.db.telephony.pbx.repository.SmsDetailsRepository;
import java.net.URLDecoder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsDetailsService {
    private static final Logger logger = LogManager.getLogger(SmsDetailsService.class);
    @Autowired
    private SmsDetailsRepository smsDetailsRepository;

    public SmsDetails saveSms(String destination, String smsText) {
        try {
            String decodedDestination = this.decodeCustomEncoding(destination);
            String decodedSmsText = this.decodeCustomEncoding(smsText);
            SmsDetails sms = new SmsDetails();
            sms.setDestination(decodedDestination);
            sms.setSmsText(decodedSmsText);
            return (SmsDetails)this.smsDetailsRepository.save((Object)sms);
        }
        catch (Exception e) {
            System.err.println("Error saving SMS: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private String decodeCustomEncoding(String encodedText) {
        if (encodedText == null) {
            return null;
        }
        try {
            String standardEncoded = encodedText.replace("%20", "+").replace(":", "%3A").replace("@", "%40").replace(",", "%2C");
            return URLDecoder.decode(standardEncoded, "UTF-8");
        }
        catch (Exception e) {
            logger.error("Error decoding text: " + e.getMessage(), (Throwable)e);
            return encodedText;
        }
    }
}

