/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.JwtUtil;
import com.coraltele.telemetry.service.user.service.UserService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class StompConnectChannelInterceptor
implements ChannelInterceptor {
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    UserService userService;

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap(message);
        if (StompCommand.CONNECT.equals((Object)accessor.getCommand())) {
            List authorizationHeaderValues = accessor.getNativeHeader("Authorization");
            if (authorizationHeaderValues != null && !authorizationHeaderValues.isEmpty()) {
                String authorizationHeader = (String)authorizationHeaderValues.get(0);
                if (!StringUtils.hasLength((String)authorizationHeader) || !this.isValid(authorizationHeader)) {
                    throw new AccessDeniedException("Access Denied: Invalid Credentials");
                }
            } else {
                throw new AccessDeniedException("Access Denied: No Authorization details provided");
            }
        }
        return message;
    }

    private boolean isValid(String headerValue) {
        String[] authHeaderValues = headerValue.split(" ");
        if (authHeaderValues.length == 2 && authHeaderValues[0].equals("Bearer")) {
            return this.jwtUtil.validateToken(authHeaderValues[1]);
        }
        if (authHeaderValues.length == 2 && authHeaderValues[0].equals("Opaque")) {
            if (StringUtils.hasLength((String)Constants.WEBSOCKET_KEY)) {
                return Constants.WEBSOCKET_KEY.equals(authHeaderValues[1]);
            }
            return false;
        }
        return false;
    }
}

