/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages={"com.coraltele.telemetry.db.coralapps.repository"}, entityManagerFactoryRef="coralappsEntityManagerFactory", transactionManagerRef="coralappsTransactionManager")
public class CoralAppsDataSourceConfiguration {
    @Bean
    @ConfigurationProperties(value="spring.datasource.coralapps")
    public DataSource coralappsDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"coralappsEntityManagerFactory"})
    public LocalContainerEntityManagerFactoryBean coralappsEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
        em.setDataSource(this.coralappsDataSource());
        em.setPackagesToScan(new String[]{"com.coraltele.telemetry.db.coralapps"});
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        em.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQL10Dialect");
        properties.put("hibernate.hbm2ddl.auto", "update");
        em.setJpaPropertyMap(properties);
        return em;
    }

    @Bean(name={"coralappsTransactionManager"})
    public PlatformTransactionManager usersTransactionManager(@Qualifier(value="coralappsEntityManagerFactory") EntityManagerFactory entityManagerFactory) {
        return new JpaTransactionManager(entityManagerFactory);
    }
}

